/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.codeInsight;

import com.intellij.javascript.nodejs.env.NodeEnvironmentVariablesProvider;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSItemPresentation;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NodeFrameworkIndexingHandler
extends FrameworkIndexingHandler {
    private static final String[] PROCESS_ENV = new String[]{"process", "env"};

    @Override
    @NotNull
    public JSType adjustTypeBeforeAdd(@NotNull JSType type, @NotNull JSEvaluateContext context) {
        JSReferenceExpression processEnvExpr;
        if (type == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(0);
        }
        if (context == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(1);
        }
        if ((processEnvExpr = context.getProcessedExpression()) != null && NodeFrameworkIndexingHandler.isProcessEnv(type)) {
            JSTypeSource source = type.getSource();
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)processEnvExpr);
            Map<String, String> envs = NodeEnvironmentVariablesProvider.getInstance(processEnvExpr.getProject()).getEnvironment(virtualFile);
            List memberList = ContainerUtil.map(envs.entrySet(), entry -> NodeFrameworkIndexingHandler.createMember(processEnvExpr, source, (String)entry.getKey(), (String)entry.getValue()));
            JSStringType stringType = new JSStringType(true, source, JSTypeContext.INSTANCE);
            memberList.add(new JSRecordTypeImpl.IndexSignatureImpl((JSType)stringType, (JSType)stringType, (PsiElement)processEnvExpr, false));
            return new JSSimpleRecordTypeImpl(source, memberList);
        }
        JSType jSType = type;
        if (jSType == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(2);
        }
        return jSType;
    }

    @NotNull
    private static JSRecordType.TypeMember createMember(@NotNull JSReferenceExpression processEnvExpr, @NotNull JSTypeSource source, @NotNull String envVarName, final @Nullable String envVarValue) {
        if (processEnvExpr == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(3);
        }
        if (source == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(4);
        }
        if (envVarName == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(5);
        }
        FakeEnvElement provider = new FakeEnvElement(processEnvExpr, envVarName);
        JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(envVarName, (PsiElement)provider).forbidAstAccess();
        JSImplicitElementImpl element = new JSImplicitElementImpl(builder){

            @Override
            public ItemPresentation getPresentation() {
                return new JSItemPresentation((JSPsiElementBase)this){

                    @Override
                    @NotNull
                    public String getLocationString(boolean completion) {
                        String string = (String)ObjectUtils.notNull((Object)envVarValue, (Object)"undefined");
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/codeInsight/NodeFrameworkIndexingHandler$1$1", "getLocationString"));
                    }
                };
            }
        };
        return new JSRecordTypeImpl.PropertySignatureImpl(envVarName, (JSType)new JSStringLiteralTypeImpl(StringUtil.notNullize((String)envVarValue), true, source), true, true, new JSRecordMemberSourceFactory.SingleMemberSource((PsiElement)element));
    }

    private static boolean isProcessEnv(@NotNull JSType type) {
        if (type == null) {
            NodeFrameworkIndexingHandler.$$$reportNull$$$0(6);
        }
        if (type instanceof JSTypeImpl && "ProcessEnv".equals(type.getTypeText(JSType.TypeTextFormat.SIMPLE))) {
            return true;
        }
        PsiElement sourceElement = type.getSourceElement();
        return sourceElement instanceof JSProperty && "process.env".equals(((JSProperty)sourceElement).getQualifiedName());
    }

    public static boolean isProcessEnv(@Nullable JSReferenceExpression expr) {
        return JSSymbolUtil.isAccurateReferenceExpressionName(expr, PROCESS_ENV);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/codeInsight/NodeFrameworkIndexingHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processEnvExpr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVarName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/codeInsight/NodeFrameworkIndexingHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustTypeBeforeAdd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustTypeBeforeAdd";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMember";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isProcessEnv";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class FakeEnvElement
    extends FakePsiElement
    implements SyntheticElement {
        private final JSReferenceExpression myProcessEnvExpr;
        private final String myEnvVarName;

        private FakeEnvElement(@NotNull JSReferenceExpression processEnvExpr, @NotNull String envVarName) {
            if (processEnvExpr == null) {
                FakeEnvElement.$$$reportNull$$$0(0);
            }
            if (envVarName == null) {
                FakeEnvElement.$$$reportNull$$$0(1);
            }
            this.myProcessEnvExpr = processEnvExpr;
            this.myEnvVarName = envVarName;
        }

        public PsiElement getParent() {
            return this.myProcessEnvExpr;
        }

        public void navigate(boolean requestFocus) {
            VirtualFile contextFile = PsiUtilCore.getVirtualFile((PsiElement)this.myProcessEnvExpr);
            NodeEnvironmentVariablesProvider.getInstance(this.myProcessEnvExpr.getProject()).navigate(this.myEnvVarName, contextFile);
        }

        @Nullable
        @TestOnly
        public Navigatable getNavigatable() {
            NodeEnvironmentVariablesProvider provider = NodeEnvironmentVariablesProvider.getInstance(this.myProcessEnvExpr.getProject());
            return provider.getNavigatable(this.myEnvVarName, PsiUtilCore.getVirtualFile((PsiElement)this.myProcessEnvExpr));
        }

        public String getName() {
            return null;
        }

        public TextRange getTextRange() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processEnvExpr";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "envVarName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/nodejs/codeInsight/NodeFrameworkIndexingHandler$FakeEnvElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

