/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.javascript.jest.JestConfigurationType;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructure;
import com.intellij.javascript.testFramework.interfaces.mochaTdd.MochaTddFileStructureBuilder;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testing.JSTestRunnerManager;
import com.intellij.javascript.testing.JsTestRunConfigurationProducer;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTestFileType;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestRunConfigurationProducer
extends JsTestRunConfigurationProducer<JestRunConfiguration> {
    public JestRunConfigurationProducer() {
        super(JestUtil.PKG_DESCRIPTOR, Collections.emptyList());
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        JestConfigurationType jestConfigurationType = JestConfigurationType.getInstance();
        if (jestConfigurationType == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return jestConfigurationType;
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull JestRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        PsiElement element;
        if (configuration == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((element = context.getPsiLocation()) == null || !this.isTestRunnerPackageAvailableFor(element, context)) {
            return false;
        }
        TestElementInfo elementRunInfo = this.createTestElementRunInfo(element, configuration.getRunSettings());
        if (elementRunInfo == null) {
            return false;
        }
        JestRunSettings runSettings = elementRunInfo.getRunSettings();
        configuration.setRunSettings(runSettings);
        sourceElement.set((Object)elementRunInfo.getEnclosingTestElement());
        configuration.setGeneratedName();
        return true;
    }

    @Nullable
    private static JsTestElementPath createSuiteOrTestData(@NotNull PsiElement element) {
        if (element == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (element instanceof PsiFileSystemItem) {
            return null;
        }
        JSFile jsFile = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        TextRange textRange = element.getTextRange();
        if (jsFile == null || textRange == null) {
            return null;
        }
        JasmineFileStructure jasmineStructure = (JasmineFileStructure)JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        JsTestElementPath path = jasmineStructure.findTestElementPath(textRange);
        if (path != null) {
            return path;
        }
        MochaTddFileStructure tddStructure = (MochaTddFileStructure)MochaTddFileStructureBuilder.getInstance().fetchCachedTestFileStructure(jsFile);
        return tddStructure.findTestElementPath(textRange);
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull JestRunConfiguration configuration, @NotNull ConfigurationContext context) {
        PsiElement element;
        if (configuration == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if ((element = context.getPsiLocation()) == null) {
            return false;
        }
        TestElementInfo elementRunInfo = this.createTestElementRunInfo(element, configuration.getRunSettings());
        if (elementRunInfo == null) {
            return false;
        }
        JestRunSettings thisRunSettings = elementRunInfo.getRunSettings();
        JestRunSettings thatRunSettings = configuration.getRunSettings();
        if (!thisRunSettings.getConfigFileSystemDependentPath().equals(thatRunSettings.getConfigFileSystemDependentPath())) {
            return false;
        }
        if (thisRunSettings.getScopeKind() != thatRunSettings.getScopeKind()) {
            return false;
        }
        JestScopeKind scopeKind = thisRunSettings.getScopeKind();
        if (scopeKind == JestScopeKind.ALL) {
            return true;
        }
        if (scopeKind == JestScopeKind.TEST_FILE) {
            return thisRunSettings.getTestFileSystemDependentPath().equals(thatRunSettings.getTestFileSystemDependentPath());
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            return thisRunSettings.getTestFileSystemDependentPath().equals(thatRunSettings.getTestFileSystemDependentPath()) && thisRunSettings.getTestNames().equals(thatRunSettings.getTestNames());
        }
        return false;
    }

    @Nullable
    private TestElementInfo createTestElementRunInfo(@NotNull PsiElement element, @NotNull JestRunSettings templateRunSettings) {
        VirtualFile virtualFile;
        if (element == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if (templateRunSettings == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return null;
        }
        JsTestElementPath tep = JestRunConfigurationProducer.createSuiteOrTestData(element);
        if (tep == null) {
            return this.createFileInfo(element, virtualFile, templateRunSettings);
        }
        JestRunSettings.Builder builder = templateRunSettings.toBuilder();
        builder.setTestFilePath(virtualFile.getPath());
        String testName = tep.getTestName();
        if (testName == null) {
            builder.setScopeKind(JestScopeKind.SUITE);
            builder.setTestNames(tep.getSuiteNames());
        } else {
            builder.setScopeKind(JestScopeKind.TEST);
            ArrayList<String> names = new ArrayList<String>(tep.getSuiteNames());
            names.add(testName);
            builder.setTestNames(names);
        }
        return new TestElementInfo(builder.build(), tep.getTestElement());
    }

    @Nullable
    private TestElementInfo createFileInfo(@NotNull PsiElement element, @NotNull VirtualFile virtualFile, @NotNull JestRunSettings templateRunSettings) {
        JSFile psiFile;
        JSTestFileType testFileType;
        if (element == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (virtualFile == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        if (templateRunSettings == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        JSTestFileType jSTestFileType = testFileType = (psiFile = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class)) == null ? null : psiFile.getTestFileType();
        if (psiFile != null && testFileType == JSTestFileType.JASMINE) {
            JestRunSettings.Builder builder = templateRunSettings.toBuilder();
            builder.setScopeKind(JestScopeKind.TEST_FILE);
            builder.setTestFilePath(virtualFile.getPath());
            return new TestElementInfo(builder.build(), (PsiElement)psiFile);
        }
        JsonFile jsonFile = (JsonFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JsonFile.class);
        if (jsonFile != null) {
            JsonProperty jestProp;
            if (JestUtil.isJestConfigFile(jsonFile.getName())) {
                JestRunSettings.Builder builder = templateRunSettings.toBuilder();
                builder.setConfigFilePath(virtualFile.getPath());
                builder.setScopeKind(JestScopeKind.ALL);
                return new TestElementInfo(builder.build(), (PsiElement)jsonFile);
            }
            if (PackageJsonUtil.isPackageJsonFile((PsiFile)jsonFile) && (jestProp = PackageJsonUtil.findContainingTopLevelProperty(element)) != null && "jest".equals(jestProp.getName())) {
                return new TestElementInfo(templateRunSettings.toBuilder().setScopeKind(JestScopeKind.ALL).build(), (PsiElement)jestProp);
            }
        }
        return null;
    }

    @Nullable
    private VirtualFile guessWorkingDir(@NotNull Project project, @NotNull VirtualFile contextFile) {
        AtomicBoolean basedOnJestDependencyDeclared;
        Ref firstPackageJsonDir;
        VirtualFile workingDir;
        if (project == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        if (contextFile == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(13);
        }
        if ((workingDir = (VirtualFile)JSProjectUtil.processDirectoriesUpToContentRootAndFindFirst(project, contextFile, arg_0 -> this.lambda$guessWorkingDir$0(firstPackageJsonDir = Ref.create(), basedOnJestDependencyDeclared = new AtomicBoolean(false), project, arg_0))) != null && !workingDir.equals(firstPackageJsonDir.get()) && basedOnJestDependencyDeclared.get() && workingDir.findChild("lerna.json") != null) {
            return (VirtualFile)firstPackageJsonDir.get();
        }
        return workingDir;
    }

    private static boolean hasTestScript(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull PackageJsonData data) {
        if (project == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(14);
        }
        if (packageJson == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(15);
        }
        if (data == null) {
            JestRunConfigurationProducer.$$$reportNull$$$0(16);
        }
        if (!data.getTopLevelProperties().contains("scripts")) {
            return false;
        }
        try {
            NpmScriptsStructure structure = NpmScriptsService.getInstance(project).fetchBuildfileStructure(packageJson);
            return structure.getTaskNames().contains("test");
        }
        catch (JsbtTaskFetchException jsbtTaskFetchException) {
            return false;
        }
    }

    private /* synthetic */ VirtualFile lambda$guessWorkingDir$0(Ref firstPackageJsonDir, AtomicBoolean basedOnJestDependencyDeclared, Project project, VirtualFile dir) {
        VirtualFile config2 = dir.findChild("jest.config.js");
        if (config2 != null && !config2.isDirectory()) {
            return dir;
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(dir);
        if (packageJson != null) {
            firstPackageJsonDir.setIfNull((Object)dir);
            PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
            if (data.getTopLevelProperties().contains("jest")) {
                return dir;
            }
            if (JSTestRunnerManager.isDeclaredInPackageJson(data, this)) {
                basedOnJestDependencyDeclared.set(true);
                return dir;
            }
            if (JestRunConfigurationProducer.hasTestScript(project, packageJson, data)) {
                return dir;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestRunConfigurationProducer";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRunSettings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromCompatibleContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createSuiteOrTestData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromCompatibleContext";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTestElementRunInfo";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFileInfo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "guessWorkingDir";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasTestScript";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class TestElementInfo {
        private final JestRunSettings myRunSettings;
        private final PsiElement myEnclosingTestElement;

        TestElementInfo(@NotNull JestRunSettings runSettings, PsiElement enclosingTestElement) {
            if (runSettings == null) {
                TestElementInfo.$$$reportNull$$$0(0);
            }
            if (enclosingTestElement == null) {
                TestElementInfo.$$$reportNull$$$0(1);
            }
            if (runSettings.getWorkingDirSystemDependentPath().trim().isEmpty()) {
                VirtualFile contextFile = Objects.requireNonNull(PsiUtilCore.getVirtualFile((PsiElement)enclosingTestElement));
                VirtualFile workingDir = JestRunConfigurationProducer.this.guessWorkingDir(enclosingTestElement.getProject(), contextFile);
                if (workingDir != null) {
                    runSettings = runSettings.toBuilder().setWorkingDir(workingDir.getPath()).build();
                }
            }
            this.myRunSettings = runSettings;
            this.myEnclosingTestElement = enclosingTestElement;
        }

        @NotNull
        public JestRunSettings getRunSettings() {
            JestRunSettings jestRunSettings = this.myRunSettings;
            if (jestRunSettings == null) {
                TestElementInfo.$$$reportNull$$$0(2);
            }
            return jestRunSettings;
        }

        @NotNull
        public PsiElement getEnclosingTestElement() {
            PsiElement psiElement = this.myEnclosingTestElement;
            if (psiElement == null) {
                TestElementInfo.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enclosingTestElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/jest/JestRunConfigurationProducer$TestElementInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/jest/JestRunConfigurationProducer$TestElementInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunSettings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnclosingTestElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

