/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.execution.testframework.sm.runner.SMRunnerConsolePropertiesProvider;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.jest.JestConsoleProperties;
import com.intellij.javascript.jest.JestRunConfigurationEditor;
import com.intellij.javascript.jest.JestRunProfileState;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.javascript.testFramework.navigation.JSTestLocationProvider;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.javascript.testing.JsTestRunConfigurationProducer;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestRunConfiguration
extends LocatableConfigurationBase<JestRunConfiguration>
implements NodeDebugRunConfiguration,
PreferableRunConfiguration,
JSRunProfileWithCompileBeforeLaunchOption,
SMRunnerConsolePropertiesProvider {
    private static final Key<Boolean> WITH_UPDATE_SNAPSHOT = Key.create((String)"WITH_UPDATE_SNAPSHOT");
    private JestRunSettings mySettings;

    protected JestRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, String name) {
        if (project == null) {
            JestRunConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            JestRunConfiguration.$$$reportNull$$$0(1);
        }
        super(project, factory, name);
        this.mySettings = JestRunSettings.builder().build();
    }

    @NotNull
    public JestRunSettings getRunSettings() {
        JestRunSettings jestRunSettings = this.mySettings;
        if (jestRunSettings == null) {
            JestRunConfiguration.$$$reportNull$$$0(2);
        }
        return jestRunSettings;
    }

    public void setRunSettings(@NotNull JestRunSettings settings) {
        NodePackage pkg;
        if (settings == null) {
            JestRunConfiguration.$$$reportNull$$$0(3);
        }
        if ((pkg = settings.getJestPackage()) != null && pkg.isEmptyPath() && RunManager.getInstance((Project)this.getProject()).isTemplate((RunConfiguration)this)) {
            settings = settings.toBuilder().setJestPackage(null).build();
        }
        this.mySettings = settings;
        if (settings.getJestPackage() != null) {
            JestUtil.setJestPackage(this.getProject(), settings.getJestPackage());
        }
    }

    @Override
    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.mySettings.getInterpreterRef().resolve(this.getProject());
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new JestRunConfigurationEditor(this.getProject());
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            JestRunConfiguration.$$$reportNull$$$0(4);
        }
        super.readExternal(element);
        this.mySettings = JestUtil.readXml(element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            JestRunConfiguration.$$$reportNull$$$0(5);
        }
        super.writeExternal(element);
        JestUtil.writeXml(element, this.mySettings);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        JestUtil.checkRunConfiguration(this);
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            JestRunConfiguration.$$$reportNull$$$0(6);
        }
        if (environment == null) {
            JestRunConfiguration.$$$reportNull$$$0(7);
        }
        NodePackage pkg = this.getJestPackage();
        return new JestRunProfileState(this, environment, pkg);
    }

    @Override
    public boolean hasConfiguredDebugAddress() {
        return NodeCommandLineUtil.findDebugPort(this.mySettings.getNodeOptions()) != -1;
    }

    @NotNull
    public NodePackage getJestPackage() {
        if (RunManager.getInstance((Project)this.getProject()).isTemplate((RunConfiguration)this)) {
            NodePackage nodePackage = (NodePackage)ObjectUtils.notNull((Object)this.mySettings.getJestPackage(), (Object)new NodePackage(""));
            if (nodePackage == null) {
                JestRunConfiguration.$$$reportNull$$$0(8);
            }
            return nodePackage;
        }
        NodePackage pkg = this.mySettings.getJestPackage();
        if (pkg == null) {
            Project project = this.getProject();
            pkg = JestUtil.PKG_DESCRIPTOR.findFirstDirectDependencyPackage(project, null, JestUtil.findContextFile(this.mySettings));
            if (pkg.isEmptyPath()) {
                pkg = JestUtil.getJestPackage(project);
            } else {
                JestUtil.setJestPackage(project, pkg);
            }
            this.mySettings = this.mySettings.toBuilder().setJestPackage(pkg).build();
        }
        NodePackage nodePackage = pkg;
        if (nodePackage == null) {
            JestRunConfiguration.$$$reportNull$$$0(9);
        }
        return nodePackage;
    }

    @Nullable
    public String suggestedName() {
        JestRunSettings settings = this.mySettings;
        JestScopeKind scopeKind = settings.getScopeKind();
        if (scopeKind == JestScopeKind.TEST_FILE) {
            return PathUtil.getFileName((String)settings.getTestFileSystemDependentPath());
        }
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            return JsTestFqn.getPresentableName(settings.getTestNames());
        }
        if (StringUtil.isNotEmpty((String)settings.getConfigFileSystemDependentPath())) {
            return PathUtil.getFileName((String)settings.getConfigFileSystemDependentPath());
        }
        return TestRunnerBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
    }

    @Nullable
    public String getActionName() {
        JestScopeKind scopeKind = this.mySettings.getScopeKind();
        if (scopeKind == JestScopeKind.SUITE || scopeKind == JestScopeKind.TEST) {
            return StringUtil.notNullize((String)((String)ContainerUtil.getLastItem(this.mySettings.getTestNames())));
        }
        return super.getActionName();
    }

    public boolean isPreferredOver(@NotNull RunConfiguration otherRc, @NotNull PsiElement sourceElement) {
        CharSequence contents;
        if (otherRc == null) {
            JestRunConfiguration.$$$reportNull$$$0(10);
        }
        if (sourceElement == null) {
            JestRunConfiguration.$$$reportNull$$$0(11);
        }
        if (!StringUtil.contains((CharSequence)(contents = sourceElement.getContainingFile().getViewProvider().getContents()), (CharSequence)"@jest/globals")) {
            return false;
        }
        return StringUtil.contains((CharSequence)contents, (CharSequence)"'@jest/globals'") || StringUtil.contains((CharSequence)contents, (CharSequence)"\"@jest/globals\"");
    }

    public void onNewConfigurationCreated() {
        VirtualFile dir;
        if (this.mySettings.getWorkingDirSystemDependentPath().trim().isEmpty() && (dir = JsTestRunConfigurationProducer.guessWorkingDirectory(this.getProject(), this.mySettings.getConfigFileSystemDependentPath())) != null) {
            this.mySettings = this.mySettings.toBuilder().setWorkingDir(dir.getPath()).build();
        }
    }

    public void setOptionUpdateSnapshot() {
        WITH_UPDATE_SNAPSHOT.set((UserDataHolder)this, (Object)true);
    }

    public boolean isOptionUpdateSnapshot() {
        return WITH_UPDATE_SNAPSHOT.get((UserDataHolder)this) == Boolean.TRUE;
    }

    public void clearOptionUpdateSnapshot() {
        WITH_UPDATE_SNAPSHOT.set((UserDataHolder)this, null);
    }

    @NotNull
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor) {
        if (executor == null) {
            JestRunConfiguration.$$$reportNull$$$0(12);
        }
        JestConsoleProperties jestConsoleProperties = this.createTestConsoleProperties(executor, false);
        if (jestConsoleProperties == null) {
            JestRunConfiguration.$$$reportNull$$$0(13);
        }
        return jestConsoleProperties;
    }

    @NotNull
    public JestConsoleProperties createTestConsoleProperties(@NotNull Executor executor, boolean withTerminalConsole) {
        if (executor == null) {
            JestRunConfiguration.$$$reportNull$$$0(14);
        }
        return new JestConsoleProperties(this, executor, (SMTestLocator)new JSTestLocationProvider(true), withTerminalConsole);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestRunConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherRc";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getJestPackage";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestConsoleProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setRunSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isPreferredOver";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

