/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.psi.JSArgumentsHolder;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<JSArgumentsHolder, JSFunctionType, JSExpression> {
    private static final Set<Class<?>> ourArgumentListAllowedParentClassesSet = ContainerUtil.newHashSet((Object[])new Class[]{JSCallLikeExpression.class});
    private static final Set<Class<?>> ourStopSearch = Collections.singleton(JSFunction.class);
    public static final Function<JSType, String> TYPE_DESCRIBER = type -> JSLookupUtilImpl.getShortName(type.transformTypeHierarchy(t -> JSParameterInfoHandler.widenIfLiteral(t)).getTypeText(JSType.TypeTextFormat.PRESENTABLE));

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        Set<Class<?>> set = ourStopSearch;
        if (set == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(0);
        }
        return set;
    }

    private static void doAddSignature(@NotNull Map<String, JSFunctionType> typedSignatures, @NotNull JSFunctionType functionItem, @NotNull JSTypeSubstitutor typeSubstitutor) {
        String typedSignature;
        if (typedSignatures == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (functionItem == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if (typeSubstitutor == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(3);
        }
        if (!typedSignatures.containsKey(typedSignature = JSParameterInfoHandler.buildSignature((JSFunctionType)functionItem, (int)-1, (JSTypeSubstitutor)typeSubstitutor).text)) {
            typedSignatures.put(typedSignature, functionItem);
        }
    }

    public JSArgumentsHolder findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        JSArgumentsHolder argList;
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if ((argList = JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset())) == null) {
            return null;
        }
        if (this.skipTypeScript() && DialectDetector.isTypeScript((PsiElement)argList)) {
            return null;
        }
        Stream<JSFunctionType> resultStream = this.fillSignaturesForArgumentList(context, argList);
        if (resultStream != null) {
            context.setItemsToShow(resultStream.map(JSParameterInfoHandler::extendParametersForTuple).toArray());
            return argList;
        }
        context.setItemsToShow(null);
        return null;
    }

    @NotNull
    private static JSFunctionType extendParametersForTuple(@NotNull JSFunctionType type) {
        if (type == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(5);
        }
        List parameters = type.getParameters();
        JSFunctionType jSFunctionType = type.copyWithParameters(TypeScriptJSFunctionTypeImpl.expandRestTupleTypes(parameters, -1));
        if (jSFunctionType == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(6);
        }
        return jSFunctionType;
    }

    @Nullable
    public static JSArgumentsHolder findArgumentList(@Nullable PsiFile file2, int offset) {
        JSCallExpression callExpression;
        if (file2 == null) {
            return null;
        }
        JSArgumentsHolder argList = (JSArgumentsHolder)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file2, (int)offset, JSArgumentsHolder.class, (Class[])new Class[]{JSStatement.class, JSFunctionExpression.class});
        if (argList == null && (callExpression = (JSCallExpression)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file2, (int)offset, JSCallExpression.class, (Class[])new Class[]{JSStatement.class})) != null) {
            argList = callExpression.getArgumentList();
        }
        return argList != null && PsiTreeUtil.getContextOfType((PsiElement)file2.findElementAt(offset), TypeScriptTypeArgumentList.class, (boolean)true, (Class[])new Class[]{JSStatement.class}) == null ? argList : null;
    }

    @Nullable
    protected Stream<JSFunctionType> fillSignaturesForArgumentList(CreateParameterInfoContext context, @NotNull JSArgumentsHolder argList) {
        JSFunctionItem implicitFunction;
        if (argList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiElement psiElement = argList.getParent();
        if (!(psiElement instanceof JSCallLikeExpression)) {
            return null;
        }
        JSCallLikeExpression parent = (JSCallLikeExpression)psiElement;
        JSExpression methodExpression = JSUtils.unparenthesize(parent.getMethodExpression());
        if (methodExpression instanceof JSReferenceExpression || methodExpression instanceof JSIndexedPropertyAccessExpression) {
            return this.fillSignaturesForReferenceOrIndexAccessExpression(parent, methodExpression);
        }
        if (methodExpression instanceof JSSuperExpression || methodExpression instanceof JSThisExpression) {
            PsiReference reference = methodExpression.getReference();
            if (reference == null) {
                return null;
            }
            PsiElement clazz = reference.resolve();
            if (clazz instanceof JSFunction) {
                if (clazz instanceof TypeScriptFunction) {
                    Collection<? extends JSFunctionItem> overloadDeclarations = TypeScriptPsiUtil.getAllOverloadSignatures((JSFunctionItem)((TypeScriptFunction)clazz));
                    return overloadDeclarations.stream().map(c -> JSParameterInfoHandler.mapToFunction(c, JSTypeSubstitutor.EMPTY));
                }
                return Stream.of(new JSFunctionWithSubstitutor((JSFunctionItem)((JSFunction)clazz), JSTypeSubstitutor.EMPTY)).map(JSParameterInfoHandler::mapToFunction);
            }
        } else if (methodExpression instanceof JSFunctionExpression) {
            return Stream.of((JSFunctionExpression)methodExpression).map(el -> JSParameterInfoHandler.mapToFunction((JSFunctionItem)el, JSTypeSubstitutor.EMPTY));
        }
        if ((implicitFunction = JSParameterInfoHandler.getImplicitFunction(methodExpression)) != null) {
            return JSParameterInfoHandler.deduplicateSignatures(Collections.singletonList(implicitFunction), JSTypeSubstitutor.EMPTY);
        }
        return null;
    }

    private static Collection<PsiElement> getResolvedPsiElements(JSExpression methodExpression) {
        if (methodExpression instanceof JSReferenceExpression) {
            ResolveResult[] resolveResults = ((JSReferenceExpression)methodExpression).multiResolve(true);
            if (resolveResults.length <= 0) {
                return Collections.emptyList();
            }
            return JSResolveResult.toElements(resolveResults, false);
        }
        if (methodExpression instanceof JSIndexedPropertyAccessExpression) {
            String value;
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)methodExpression).getIndexExpression();
            Object propertyName = null;
            if (indexExpression instanceof JSLiteralExpression && (value = ((JSLiteralExpression)indexExpression).getStringValue()) != null) {
                propertyName = value;
            }
            if (JSPsiImplUtils.isSymbolRef(indexExpression)) {
                propertyName = "[" + indexExpression.getText() + "]";
            }
            if (propertyName != null) {
                JSRecordType recordType;
                JSRecordType.PropertySignature propertySignature;
                JSType qualifierType = JSResolveUtil.getExpressionJSType(((JSIndexedPropertyAccessExpression)methodExpression).getQualifier());
                if ((qualifierType = JSTypeUtils.getValuableType(qualifierType)) != null && (propertySignature = (recordType = qualifierType.asRecordType()).findPropertySignature((String)propertyName)) != null) {
                    JSRecordType.MemberSource source = propertySignature.getMemberSource();
                    if (!source.isUnion()) {
                        elements.addAll(source.getAllSourceElements());
                    } else if (propertySignature instanceof JSCompositeFunctionPropertySignatureImpl) {
                        for (JSRecordType.PropertySignature part : ((JSCompositeFunctionPropertySignatureImpl)propertySignature).getMembers()) {
                            source = part.getMemberSource();
                            if (source.isUnion()) continue;
                            elements.addAll(source.getAllSourceElements());
                        }
                    }
                }
            }
            return elements;
        }
        throw new UnsupportedOperationException("Expression " + methodExpression.getClass() + " is not supported");
    }

    @Nullable
    protected Stream<JSFunctionType> fillSignaturesForReferenceOrIndexAccessExpression(@NotNull JSCallLikeExpression parent, @NotNull JSExpression methodExpression) {
        Collection<PsiElement> elements;
        if (parent == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(8);
        }
        if (methodExpression == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(9);
        }
        if ((elements = JSParameterInfoHandler.getResolvedPsiElements(methodExpression)).size() == 0) {
            return null;
        }
        elements = JSParameterInfoHandler.getElementsWithConstructors(parent, elements);
        assert (methodExpression instanceof JSQualifiedExpression);
        JSExpression qualifier = ((JSQualifiedExpression)methodExpression).getQualifier();
        List<JSFunctionItem> items = JSParameterInfoHandler.getFunctionItems(methodExpression, elements);
        JSTypeSubstitutor typeSubstitutor = JSParameterInfoHandler.getTypeSubstitutor(methodExpression, qualifier, items);
        return JSParameterInfoHandler.deduplicateSignatures(items, typeSubstitutor);
    }

    @NotNull
    private static Stream<JSFunctionType> deduplicateSignatures(List<JSFunctionItem> items, JSTypeSubstitutor typeSubstitutor) {
        LinkedHashMap<String, JSFunctionType> typedSignatures = new LinkedHashMap<String, JSFunctionType>(items.size());
        for (JSFunctionItem functionItem : items) {
            JSFunctionType functionType = JSParameterInfoHandler.mapToFunction(functionItem, typeSubstitutor);
            JSParameterInfoHandler.doAddSignature(typedSignatures, functionType, typeSubstitutor);
        }
        Stream<JSFunctionType> stream = typedSignatures.values().stream();
        if (stream == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(10);
        }
        return stream;
    }

    @NotNull
    private static List<JSFunctionItem> getFunctionItems(@NotNull JSExpression methodExpression, @NotNull Collection<PsiElement> elements) {
        if (methodExpression == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(11);
        }
        if (elements == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(12);
        }
        List<JSFunctionItem> items = new LinkedList<JSFunctionItem>();
        for (PsiElement element : elements) {
            Collection<? extends JSFunctionItem> functionItems;
            if (element instanceof TypeScriptProxyImplicitElementWithBackingItem) {
                element = ((TypeScriptProxyImplicitElementWithBackingItem)element).getBackingElement();
            }
            if ((functionItems = JSParameterInfoHandler.getFunctionItems(methodExpression, element)).size() == 0) continue;
            items.addAll(functionItems);
        }
        if (items.size() == 0) {
            items = JSParameterInfoHandler.getImplicitFunctions(methodExpression);
        }
        LinkedList<JSFunctionItem> linkedList = items;
        if (linkedList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(13);
        }
        return linkedList;
    }

    @Nullable
    public static JSFunctionItem getImplicitFunction(@Nullable JSExpression methodExpression) {
        List<JSFunctionItem> functions = JSParameterInfoHandler.getImplicitFunctions(methodExpression);
        return functions.size() == 1 ? functions.get(0) : null;
    }

    @NotNull
    public static List<JSFunctionItem> getImplicitFunctions(@Nullable JSExpression methodExpression) {
        JSExpression innerExpression;
        if (methodExpression instanceof JSParenthesizedExpression && (innerExpression = ((JSParenthesizedExpression)methodExpression).getInnerExpression()) instanceof JSFunctionItem) {
            List<JSFunctionItem> list2 = Collections.singletonList((JSFunctionItem)innerExpression);
            if (list2 == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(14);
            }
            return list2;
        }
        SmartList implicitFunctions = new SmartList();
        JSType methodType = JSResolveUtil.getExpressionJSType(methodExpression);
        if (methodType != null) {
            JSRecordType recordType = methodType.asRecordType();
            List signatures = recordType.getCallSignatures();
            for (JSRecordType.CallSignature signature : signatures) {
                PsiElement element = (PsiElement)ObjectUtils.coalesce((Object)signature.getMemberSource().getSingleElement(), (Object)methodExpression);
                assert (element != null);
                implicitFunctions.add(new JSLocalImplicitFunctionImpl("func", null, element, (JSParameterItem[])JSParameterInfoHandler.getParameters(signature)));
            }
        }
        SmartList smartList = implicitFunctions;
        if (smartList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(15);
        }
        return smartList;
    }

    private static JSParameterTypeDecorator @NotNull [] getParameters(@NotNull JSRecordType.CallSignature signature) {
        JSParameterItem[] sourceParameters;
        if (signature == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(16);
        }
        PsiElement sourceElement = signature.getMemberSource().getSingleElement();
        List parameterTypes = signature.getParameterTypeDecorators();
        if (sourceElement instanceof JSImplicitFunctionImpl && DialectDetector.isJavaScript(sourceElement) && (sourceParameters = ((JSImplicitFunctionImpl)sourceElement).getParameters()).length == parameterTypes.size() && parameterTypes.stream().allMatch(p -> p.getName() == null)) {
            JSParameterTypeDecorator[] finalTypes = new JSParameterTypeDecorator[sourceParameters.length];
            for (int i = 0; i < sourceParameters.length; ++i) {
                finalTypes[i] = new JSParameterTypeDecoratorImpl(sourceParameters[i].getName(), ((JSParameterTypeDecorator)parameterTypes.get(i)).getSimpleType(), ((JSParameterTypeDecorator)parameterTypes.get(i)).isOptional(), ((JSParameterTypeDecorator)parameterTypes.get(i)).isRest(), ((JSParameterTypeDecorator)parameterTypes.get(i)).isExplicitlyDeclared());
            }
            if (finalTypes == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(17);
            }
            return finalTypes;
        }
        if (parameterTypes.size() > 0 && parameterTypes.stream().anyMatch(p -> p.getName() == null || p.isOptional() && TypeScriptTypeRelations.isUnionWithUndefinedType(p.getInferredType())) && sourceElement instanceof JSFunctionItem) {
            JSParameterTypeDecorator[] jSParameterTypeDecoratorArray = (JSParameterTypeDecorator[])ContainerUtil.toArray(JSParameterInfoHandler.fixParamNamesAndUndefinedStatus(parameterTypes, ((JSFunctionItem)sourceElement).getParameters()), JSParameterTypeDecorator[]::new);
            if (jSParameterTypeDecoratorArray == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(18);
            }
            return jSParameterTypeDecoratorArray;
        }
        JSParameterTypeDecorator[] jSParameterTypeDecoratorArray = (JSParameterTypeDecorator[])ContainerUtil.toArray((Collection)parameterTypes, JSParameterTypeDecorator[]::new);
        if (jSParameterTypeDecoratorArray == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(19);
        }
        return jSParameterTypeDecoratorArray;
    }

    @NotNull
    private static List<JSParameterTypeDecorator> fixParamNamesAndUndefinedStatus(@NotNull List<JSParameterTypeDecorator> parameterTypes, JSParameterItem @NotNull [] parameters) {
        if (parameterTypes == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(20);
        }
        if (parameters == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(21);
        }
        ArrayList<JSParameterTypeDecorator> newDecorators = new ArrayList<JSParameterTypeDecorator>(parameterTypes.size());
        for (int i = 0; i < parameterTypes.size(); ++i) {
            JSParameterTypeDecorator type = parameterTypes.get(i);
            if (type.getName() == null && i < parameters.length) {
                List<JSType> types2;
                List nonUndefined;
                boolean optional = type.isOptional();
                JSType inferredType = type.getInferredType();
                if (optional && inferredType instanceof JSUnionType && (nonUndefined = ContainerUtil.filter(types2 = ((JSUnionType)inferredType).getTypes(), t -> !(t instanceof JSUndefinedType))).size() < types2.size()) {
                    inferredType = JSCompositeTypeFactory.createUnionType(inferredType.getSource(), nonUndefined);
                }
                newDecorators.add(new JSParameterTypeDecoratorImpl(parameters[i].getName(), inferredType, optional, type.isRest(), type.isExplicitlyDeclared()));
                continue;
            }
            newDecorators.add(type);
        }
        ArrayList<JSParameterTypeDecorator> arrayList = newDecorators;
        if (arrayList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeSubstitutor(JSExpression methodExpression, @Nullable JSExpression qualifier, @NotNull List<JSFunctionItem> items) {
        JSNamespace namespace;
        JSType qualifierType;
        JSFunctionItem firstFunction;
        if (items == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(23);
        }
        if ((firstFunction = (JSFunctionItem)ContainerUtil.getFirstItem(items)) instanceof TypeScriptFunction) {
            JSTypeSubstitutor jSTypeSubstitutor = TypeScriptGenericTypesEvaluator.getInstance().getTypeSubstitutorForMember((JSElement)firstFunction, (PsiElement)methodExpression);
            if (jSTypeSubstitutor == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(24);
            }
            return jSTypeSubstitutor;
        }
        if (qualifier != null && (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) != null && (namespace = JSTypeUtils.getNamespaceMatchingType(qualifierType, false)) != null) {
            JSTypeSubstitutor jSTypeSubstitutor = (JSTypeSubstitutor)ObjectUtils.coalesce((Object)JSTypeWithOuterGenerics.getGenericArguments(namespace), (Object)JSTypeSubstitutor.EMPTY);
            if (jSTypeSubstitutor == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(25);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(26);
        }
        return jSTypeSubstitutor;
    }

    private static Collection<PsiElement> getElementsWithConstructors(JSCallLikeExpression parent, Collection<PsiElement> elements) {
        JSExpression methodExpression = parent.getMethodExpression();
        if (methodExpression == null) {
            return elements;
        }
        if (parent instanceof JSNewExpression) {
            ArrayList<PsiElement> newElements = new ArrayList<PsiElement>(elements.size());
            for (PsiElement element : elements) {
                if (element instanceof JSClass) {
                    ResolveResult[] constructorResults;
                    JSClass jsClass = (JSClass)element;
                    for (ResolveResult result2 : constructorResults = JSClassUtils.resolveES6Constructor(jsClass, methodExpression)) {
                        PsiElement resultConstructor = result2.getElement();
                        if (resultConstructor == null) continue;
                        newElements.add(resultConstructor);
                    }
                    continue;
                }
                newElements.add(element);
            }
            elements = newElements;
        }
        return elements;
    }

    @NotNull
    private static Collection<? extends JSFunctionItem> getFunctionItems(JSExpression methodExpression, PsiElement element) {
        JSFunctionItem functionItem = JSParameterInfoHandler.calculatePossibleFunctionCarefully(element, (PsiElement)methodExpression);
        if (functionItem instanceof TypeScriptFunction) {
            Collection<? extends JSFunctionItem> collection = TypeScriptPsiUtil.getAllOverloadSignatures(functionItem);
            if (collection == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(27);
            }
            return collection;
        }
        List list2 = ContainerUtil.createMaybeSingletonList((Object)functionItem);
        if (list2 == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(28);
        }
        return list2;
    }

    public void showParameterInfo(@NotNull JSArgumentsHolder element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(29);
        }
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(30);
        }
        context.showHint((PsiElement)element, element.getTextOffset(), (ParameterInfoHandler)this);
    }

    public JSArgumentsHolder findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(31);
        }
        return JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset());
    }

    public void updateParameterInfo(@NotNull JSArgumentsHolder parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(32);
        }
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(33);
        }
        int argumentIndex = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context.getOffset(), (IElementType)parameterOwner.getDelimiter());
        JSExpression[] arguments = parameterOwner.getArguments();
        for (int i = 0; i < argumentIndex; ++i) {
            if (!(arguments[i] instanceof JSSpreadExpression)) continue;
            JSType type = JSResolveUtil.getExpressionJSType(((JSSpreadExpression)arguments[i]).getExpression(), true);
            if (type instanceof JSTupleType && ((JSTupleType)type).getMinLength() == ((JSTupleType)type).getMaxLength()) {
                argumentIndex += ((JSTupleType)type).getMinLength() - 1;
                continue;
            }
            context.setCurrentParameter(-1);
            return;
        }
        context.setCurrentParameter(argumentIndex);
    }

    public void updateUI(JSFunctionType jsFunctionType, @NotNull ParameterInfoUIContext context) {
        int highlightStart;
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(34);
        }
        List params = jsFunctionType.getParameters();
        int currentParameterIndex = context.getCurrentParameterIndex() >= 0 ? context.getCurrentParameterIndex() : params.size();
        JSFunctionItem item = jsFunctionType.getSourceFunctionItem();
        ArrayList realParameters = item != null ? ContainerUtil.newArrayList((Object[])item.getParameters()) : Collections.emptyList();
        JSParameterItem parameter = JSParameterInfoHandler.getEffectiveParameter(JSParameterInfoHandler.getParameter(params, currentParameterIndex), JSParameterInfoHandler.getParameter(realParameters, currentParameterIndex));
        SignatureInfo signatureInfo = JSParameterInfoHandler.buildSignature(jsFunctionType, currentParameterIndex, JSTypeSubstitutor.EMPTY);
        String name = signatureInfo.text;
        String currentParameterSignature = parameter != null ? JSParameterInfoHandler.getSignatureForParameter(parameter, JSTypeSubstitutor.EMPTY, TYPE_DESCRIBER) : null;
        int n = highlightStart = signatureInfo.selectedParameterStart != -1 ? signatureInfo.selectedParameterStart : 0;
        int highlightEnd = signatureInfo.selectedParameterEnd != -1 ? signatureInfo.selectedParameterEnd : (parameter != null ? highlightStart + currentParameterSignature.length() : 0);
        context.setupUIComponentPresentation(name, highlightStart, highlightEnd, false, false, false, context.getDefaultParameterColor());
    }

    @Nullable
    private static JSParameterItem getParameter(@NotNull List<? extends JSParameterItem> params, int currentParameterIndex) {
        JSParameterItem lastParam;
        if (params == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(35);
        }
        if (currentParameterIndex < params.size()) {
            return params.get(currentParameterIndex);
        }
        if (params.size() > 0 && (lastParam = params.get(params.size() - 1)).isRest()) {
            return lastParam;
        }
        return null;
    }

    @Nullable
    public static JSFunctionItem calculatePossibleFunctionCarefully(@NotNull PsiElement resolveResult, @Nullable PsiElement methodExpression) {
        PsiElement module;
        if (resolveResult == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(36);
        }
        if (resolveResult instanceof JSParameter && (module = JSAmdPsiUtil.findReferencedModule((JSParameter)resolveResult)) != null) {
            resolveResult = module;
        }
        return JSPsiImplUtils.calculatePossibleFunction(resolveResult, methodExpression, false);
    }

    private static JSType widenIfLiteral(JSType t) {
        return t instanceof JSLiteralType && ((JSLiteralType)t).allowWidening() ? ((JSLiteralType)t).widen(true) : t;
    }

    @NotNull
    private static SignatureInfo buildSignature(@NotNull JSFunctionType function2, int selectedParameterIndex, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (function2 == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(37);
        }
        List parameters = function2.getParameters();
        JSFunctionItem item = function2.getSourceFunctionItem();
        boolean isReferencesArguments = item != null && item.isReferencesArguments();
        JSParameterItem[] realParameters = item != null ? item.getParameters() : JSParameterItem.EMPTY_ARRAY;
        SignatureInfo info = new SignatureInfo();
        if (parameters.size() > 0) {
            StringBuilder result2 = new StringBuilder();
            for (int i = 0; i < parameters.size(); ++i) {
                if (result2.length() > 0) {
                    result2.append(", ");
                }
                if (selectedParameterIndex >= i) {
                    info.selectedParameterStart = result2.toString().length();
                }
                JSParameterItem parameter = JSParameterInfoHandler.getEffectiveParameter((JSParameterItem)parameters.get(i), realParameters.length > i ? realParameters[i] : null);
                List<String> signatures = JSParameterInfoHandler.getSignaturesForParameter(parameter, typeSubstitutor, TYPE_DESCRIBER);
                int innerIndex = signatures.size() > 1 ? selectedParameterIndex - parameters.size() + 1 : -1;
                for (int j = 0; j < signatures.size(); ++j) {
                    if (j != 0) {
                        result2.append(", ");
                    }
                    if (innerIndex == j) {
                        info.selectedParameterStart = result2.toString().length();
                    }
                    result2.append(signatures.get(j));
                    if (innerIndex != j) continue;
                    info.selectedParameterEnd = result2.toString().length();
                }
            }
            if (isReferencesArguments) {
                result2.append(", ...");
            }
            info.text = result2.toString();
        } else {
            String signature = isReferencesArguments ? "..." : CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);
            info.text = signature;
        }
        SignatureInfo signatureInfo = info;
        if (signatureInfo == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(38);
        }
        return signatureInfo;
    }

    @Contract(value="!null,_->!null")
    private static JSParameterItem getEffectiveParameter(@Nullable JSParameterItem parameterFromDecorator, @Nullable JSParameterItem realParameter) {
        if (realParameter == null || parameterFromDecorator == null) {
            return parameterFromDecorator;
        }
        JSType own = parameterFromDecorator.getSimpleType();
        if (own == null) {
            return realParameter;
        }
        JSType type = realParameter.getSimpleType();
        return own.isEquivalentTo(type, null, true) ? realParameter : parameterFromDecorator;
    }

    @NotNull
    private static List<String> getSignaturesForParameter(@NotNull JSParameterItem p, @Nullable JSTypeSubstitutor typeSubstitutor, @NotNull Function<? super JSType, String> typeDescriber) {
        boolean skipType;
        JSParameter jsParameter;
        if (p == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(39);
        }
        if (typeDescriber == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(40);
        }
        JSParameterTypeDecorator decorator = p.getTypeDecorator();
        JSType type = (JSType)ObjectUtils.coalesce((Object)p.getSimpleType(), (Object)p.getInferredType());
        if (type != null) {
            type = JSTypeUtils.applyGenericArguments(type, typeSubstitutor);
        }
        String initializerText = (jsParameter = (JSParameter)ObjectUtils.tryCast((Object)p, JSParameter.class)) != null ? jsParameter.getLiteralOrReferenceInitializerText() : null;
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)jsParameter);
        boolean bl = skipType = p instanceof JSDestructuringParameter && ((JSDestructuringParameter)p).getTypeElement() == null;
        if (type == null && !skipType && initializerText == null && !p.isRest() && jsParameter != null) {
            type = JSParameterInfoHandler.getParameterTypeFromInitializedElement(jsParameter);
        }
        if (!skipType && type != null) {
            return JSParameterInfoHandler.getTypedSignatures(p, type, holder != null && holder.isECMA4, initializerText, typeDescriber);
        }
        Object res = TypeScriptJSFunctionTypeImpl.getParameterItemPresentableName(p);
        if (p.isRest()) {
            res = "... " + (String)res;
        }
        if (p.isOptional() && decorator.isExplicitlyDeclared()) {
            res = (String)res + "?";
        }
        if (initializerText != null) {
            res = (String)res + " = " + initializerText;
        }
        List<Object> list2 = Collections.singletonList(res);
        if (list2 == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(41);
        }
        return list2;
    }

    @Nullable
    private static JSType getParameterTypeFromInitializedElement(@NotNull JSParameter p) {
        JSQualifiedNamedElement initializedElement;
        JSFunction function2;
        if (p == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(42);
        }
        if ((function2 = p.getDeclaringFunction()) instanceof JSExpression && (initializedElement = JSPsiImplUtils.getInitializedElement((JSExpression)function2, false)) instanceof JSTypeOwner) {
            int index;
            JSType initializedElementType = ((JSTypeOwner)initializedElement).getJSType();
            if (initializedElementType != null) {
                initializedElementType = initializedElementType.substitute();
            }
            if (initializedElementType instanceof JSFunctionType && (index = JSContextTypeEvaluator.getParameterIndex((JSParameterListElement)p)) >= 0) {
                return JSContextTypeEvaluator.getTypeByFunctionParamIndex((JSFunctionType)initializedElementType, index);
            }
        }
        return null;
    }

    @NotNull
    private static List<String> getTypedSignatures(JSParameterItem p, JSType type, boolean isActionScript, String initializerText, Function<? super JSType, String> typeDescriber) {
        String typeSeparator;
        boolean needOptional = p.isOptional() && initializerText == null;
        String string = typeSeparator = isActionScript ? ":" : ": ";
        if (p.isRest()) {
            if (type instanceof JSRestTypeImpl) {
                JSType iterableType = ((JSRestTypeImpl)type).getIterableType();
                if (iterableType instanceof JSTupleType) {
                    int optionalStart = ((JSTupleType)iterableType).getOptionalStart();
                    List types2 = ((JSTupleType)iterableType).getTypes();
                    int index = 1;
                    LinkedList<String> allSignatures = new LinkedList<String>();
                    for (JSType jsType : types2) {
                        StringBuilder result2 = new StringBuilder();
                        String name = TypeScriptJSFunctionTypeImpl.getNameFromParentOrDefault(p, index, jsType, iterableType);
                        if (jsType instanceof JSSpreadType) {
                            result2.append("...");
                            jsType = ((JSSpreadType)jsType).getInnerType();
                        }
                        result2.append(name);
                        if (optionalStart != -1 && index > optionalStart) {
                            result2.append("?");
                        }
                        result2.append(typeSeparator).append(typeDescriber.apply((JSType)jsType));
                        allSignatures.add(result2.toString());
                        ++index;
                    }
                    LinkedList<String> linkedList = allSignatures;
                    if (linkedList == null) {
                        JSParameterInfoHandler.$$$reportNull$$$0(43);
                    }
                    return linkedList;
                }
                type = iterableType;
            }
            StringBuilder result3 = new StringBuilder();
            result3.append("...").append(TypeScriptJSFunctionTypeImpl.getParameterItemPresentableName(p)).append(typeSeparator).append(typeDescriber.apply((JSType)type));
            JSType simpleType = p.getSimpleType();
            if (!JSTypeUtils.isArrayLikeType(simpleType) && !(simpleType instanceof JSRestTypeImpl)) {
                result3.append("[]");
            }
            List<String> list2 = Collections.singletonList(result3.toString());
            if (list2 == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(44);
            }
            return list2;
        }
        StringBuilder result4 = new StringBuilder();
        result4.append(TypeScriptJSFunctionTypeImpl.getParameterItemPresentableName(p));
        if (needOptional) {
            result4.append('?');
        }
        result4.append(typeSeparator).append(typeDescriber.apply((JSType)type));
        if (initializerText != null) {
            result4.append(" = ");
            result4.append(initializerText);
        }
        List<String> list3 = Collections.singletonList(result4.toString());
        if (list3 == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(45);
        }
        return list3;
    }

    public static String getSignatureForParameter(JSParameterItem p, @Nullable JSTypeSubstitutor typeSubstitutor, @NotNull Function<? super JSType, String> typeDescriber) {
        if (typeDescriber == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(46);
        }
        return StringUtil.join(JSParameterInfoHandler.getSignaturesForParameter(p, typeSubstitutor, typeDescriber), (String)", ");
    }

    public JSExpression @NotNull [] getActualParameters(@NotNull JSArgumentsHolder arguments) {
        if (arguments == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(47);
        }
        JSExpression[] jSExpressionArray = arguments.getArguments();
        if (jSExpressionArray == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(48);
        }
        return jSExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = JSTokenTypes.COMMA;
        if (iElementType == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(49);
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = JSTokenTypes.RBRACE;
        if (iElementType == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(50);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        Set<Class<?>> set = ourArgumentListAllowedParentClassesSet;
        if (set == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(51);
        }
        return set;
    }

    @NotNull
    public static JSFunctionType mapToFunction(@NotNull JSFunctionItem item, @Nullable JSTypeSubstitutor typeSubstitutor) {
        JSFunctionType type;
        JSType result2;
        if (item == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(52);
        }
        JSFunctionType jSFunctionType = (result2 = JSTypeUtils.applyGenericArguments((JSType)(type = TypeScriptTypeParser.buildFunctionType(item)), typeSubstitutor)) instanceof JSFunctionType ? (JSFunctionType)result2 : type;
        if (jSFunctionType == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(53);
        }
        return jSFunctionType;
    }

    @NotNull
    private static JSFunctionType mapToFunction(@NotNull JSFunctionWithSubstitutor substitutor) {
        if (substitutor == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(54);
        }
        return JSParameterInfoHandler.mapToFunction(substitutor.myFunctionItem, substitutor.myTypeSubstitutor);
    }

    @NotNull
    public Class<JSArgumentsHolder> getArgumentListClass() {
        return JSArgumentsHolder.class;
    }

    protected boolean skipTypeScript() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 47: 
            case 52: 
            case 54: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 47: 
            case 52: 
            case 54: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/JSParameterInfoHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedSignatures";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSubstitutor";
                break;
            }
            case 4: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterOwner";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 40: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDescriber";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 47: 
            case 52: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/JSParameterInfoHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "extendParametersForTuple";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicateSignatures";
                break;
            }
            case 13: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionItems";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitFunctions";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "fixParamNamesAndUndefinedStatus";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutor";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSignature";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignaturesForParameter";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedSignatures";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToFunction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doAddSignature";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extendParametersForTuple";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillSignaturesForArgumentList";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillSignaturesForReferenceOrIndexAccessExpression";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionItems";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fixParamNamesAndUndefinedStatus";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleFunctionCarefully";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "buildSignature";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSignaturesForParameter";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypeFromInitializedElement";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureForParameter";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 52: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "mapToFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 46: 
            case 47: 
            case 52: 
            case 54: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SignatureInfo {
        String text;
        int selectedParameterStart = -1;
        int selectedParameterEnd = -1;

        private SignatureInfo() {
        }
    }
}

