/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.PresentableId;
import com.intellij.remote.SshConfigCredentialsHolder;
import com.intellij.remote.ui.RemoteSdkEditorForm;
import com.intellij.remote.ui.SdkScopeController;
import com.intellij.ssh.config.unified.ErrorMessageAndField;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.ssh.ui.unified.SshConfigComboBox;
import com.intellij.ssh.ui.unified.SshConfigConfigurable;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.ui.SshConfigProjectLevelSetupForm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkBySshConfigForm {
    @Nullable
    private final Project myProject;
    private final RemoteSdkEditorForm myParentForm;
    private JPanel myMainPanel;
    private JBLabel mySshConfigLabel;
    private SshConfigComboBox mySshConfigCombo;
    private JPanel mySshConfigProjectLevelSetupPanel;
    private final SshConfigProjectLevelSetupForm mySshProjectLevelSetupForm;

    public RemoteSdkBySshConfigForm(@Nullable Project project, RemoteSdkEditorForm parentForm) {
        this.myProject = project;
        this.myParentForm = parentForm;
        this.$$$setupUI$$$();
        this.mySshProjectLevelSetupForm = new SshConfigProjectLevelSetupForm(project, parentForm.getBundleAccessor(), new SshConfigProjectLevelSetupForm.Listener(){

            @Override
            public void onConfigMoved(@NotNull SshConfig movedConfig) {
                if (movedConfig == null) {
                    1.$$$reportNull$$$0(0);
                }
                RemoteSdkBySshConfigForm.this.setupSshCombo(movedConfig);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "movedConfig", "com/jetbrains/plugins/remotesdk/ui/RemoteSdkBySshConfigForm$1", "onConfigMoved"));
            }
        }, parentForm.getSdkScopeController());
        this.mySshConfigProjectLevelSetupPanel.setVisible(false);
        this.mySshConfigProjectLevelSetupPanel.setLayout(new BorderLayout());
        this.mySshConfigProjectLevelSetupPanel.add((Component)this.mySshProjectLevelSetupForm.getMainPanel(), "Center");
        this.mySshConfigCombo.setDataListener(() -> this.useSshSettings(this.mySshConfigCombo.getSelectedSshConfig()));
        this.mySshConfigCombo.reload();
        this.myParentForm.getSdkScopeController().addListener(() -> {
            this.useSshSettings(this.mySshConfigCombo.getSelectedSshConfig());
            @Nullable Pair dataAndPresentableId = this.mySshConfigCombo.getSelectedUiDataAndPresentableId();
            if (dataAndPresentableId != null && dataAndPresentableId.first == null) {
                this.mySshConfigCombo.reload((PresentableId)dataAndPresentableId.second, this.myParentForm.getSdkScopeController().isProjectLevel() ? SshConfigConfigurable.Visibility.Project : SshConfigConfigurable.Visibility.App);
            }
        });
    }

    private void setupSshCombo(@NotNull SshConfig config) {
        if (config == null) {
            RemoteSdkBySshConfigForm.$$$reportNull$$$0(0);
        }
        this.mySshConfigCombo.reload(config.createPresentableId(), config.getVisibility());
        this.mySshConfigProjectLevelSetupPanel.setVisible(config.isProjectLevel() ? !this.myParentForm.getSdkScopeController().isProjectLevelSupported() : this.myParentForm.getSdkScopeController().isProjectLevel());
    }

    private void useSshSettings(@Nullable SshConfig config) {
        if (config != null) {
            this.mySshProjectLevelSetupForm.setSshConfigName(config.getName());
            this.mySshConfigProjectLevelSetupPanel.setVisible(StringUtil.isNotEmpty((String)this.validateVisibility(config)));
        } else {
            this.mySshConfigProjectLevelSetupPanel.setVisible(false);
        }
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void onSelected() {
    }

    public void init(@NotNull SshConfigCredentialsHolder credentials) {
        if (credentials == null) {
            RemoteSdkBySshConfigForm.$$$reportNull$$$0(1);
        }
        this.mySshConfigCombo.reload(credentials.getSshId(), this.myParentForm.getSdkScopeController().isProjectLevel() ? SshConfigConfigurable.Visibility.Project : SshConfigConfigurable.Visibility.App);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public SshConfigCredentialsHolder getSshCredentials() {
        @Nullable @NotNull @Nullable Pair dataAndName = this.mySshConfigCombo.getSelectedUiDataAndName();
        if (dataAndName == null) {
            return null;
        }
        if (dataAndName.first == null) {
            return new SshConfigCredentialsHolder(PresentableId.createId(null, (String)((String)dataAndName.second)));
        }
        return new SshConfigCredentialsHolder(((SshUiData)dataAndName.first).getConfig().createPresentableId());
    }

    private void createUIComponents() {
        this.mySshConfigCombo = new SshConfigComboBox(this.myProject, this.myParentForm.getDisposable(), SshConfigConfigurable.Visibility.App);
    }

    public JBLabel getNavigatableLabel() {
        return this.mySshConfigLabel;
    }

    public ValidationInfo validate() {
        Pair dataAndName = this.mySshConfigCombo.getSelectedUiDataAndName();
        if (dataAndName == null) {
            return new ValidationInfo(RemoteSdkBundle.message("no.ssh.configuration.is.selected", new Object[0]), (JComponent)this.mySshConfigCombo.getComboBox());
        }
        SshUiData data = (SshUiData)dataAndName.first;
        if (data == null) {
            return new ValidationInfo(RemoteSdkBundle.message("no.ssh.configuration.named.0.found", dataAndName.second), (JComponent)this.mySshConfigCombo.getComboBox());
        }
        String visibilityError = this.validateVisibility(data.getConfig());
        if (visibilityError != null) {
            return new ValidationInfo(visibilityError, (JComponent)this.mySshConfigCombo.getComboBox());
        }
        ErrorMessageAndField errorMessageAndField = data.validate(SshCredentialsVerifier.ValidationMode.FULL);
        if (errorMessageAndField == null) {
            return null;
        }
        return new ValidationInfo(errorMessageAndField.getErrorMessage(), (JComponent)this.mySshConfigCombo.getComboBox());
    }

    @Nullable
    @NlsContexts.DialogMessage
    private String validateVisibility(@NotNull SshConfig config) {
        SdkScopeController sdkScopeController;
        if (config == null) {
            RemoteSdkBySshConfigForm.$$$reportNull$$$0(2);
        }
        if (!(sdkScopeController = this.myParentForm.getSdkScopeController()).isProjectLevel() && config.isProjectLevel()) {
            if (!sdkScopeController.isProjectLevelSupported()) {
                return RemoteSdkBundle.message("project.level.ssh.configs.with.application.level.interpreters", new Object[0]);
            }
            return RemoteSdkBundle.message("application.level.remote.interpreter.works.only.with.application.level.ssh.configs", new Object[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/remotesdk/ui/RemoteSdkBySshConfigForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupSshCombo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "validateVisibility";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBLabel jBLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.mySshConfigLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/RemoteSdkBundle", RemoteSdkBySshConfigForm.class).getString("ssh.configuration.label"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        SshConfigComboBox sshConfigComboBox = this.mySshConfigCombo;
        jPanel2.add((Component)sshConfigComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, new Dimension(400, -1), null, null));
        this.mySshConfigProjectLevelSetupPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

