/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.transport;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.AgentProxyConnectorFactory;
import com.intellij.ssh.SessionConfig;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.SshSessionKey;
import com.intellij.ssh.config.OpenSSHClientConfig;
import com.intellij.ssh.config.OpenSSHConfigService;
import com.intellij.ssh.interaction.PlatformSshPasswordProvider;
import com.intellij.ssh.interaction.SshPasswordProvider;
import com.intellij.util.EventDispatcher;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.SocketFactory;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionServiceUtil$WhenMappings;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.vfs2.provider.sftp.SftpClientFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a:\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0010\u001a\u00020\u0011*\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u001a\u0016\u0010\u0014\u001a\u00020\u0015*\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u00a8\u0006\u0016"}, d2={"remoteCredentialsToSessionConfig", "Lcom/intellij/ssh/SessionConfig;", "data", "Lcom/intellij/remote/RemoteCredentials;", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "project", "Lcom/intellij/openapi/project/Project;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "sshPasswordProvider", "Lcom/intellij/ssh/interaction/SshPasswordProvider;", "remoteCredentialsToSessionKey", "Lcom/intellij/ssh/SshSessionKey;", "computePort", "", "openSSHConfig", "Lcom/intellij/ssh/config/OpenSSHClientConfig;", "computeUserName", "", "intellij.remoteRun"})
@JvmName(name="SshConnectionServiceUtil")
public final class SshConnectionServiceUtil {
    @NotNull
    public static final SshSessionKey remoteCredentialsToSessionKey(@NotNull RemoteCredentials data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data.getUserName();
        if (string == null) {
            string = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data.userName ?: \"\"");
        String string2 = data.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"data.host");
        return new SshSessionKey(string, string2, data.getPort(), null, 8, null);
    }

    @JvmOverloads
    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit, @Nullable Project project, @Nullable ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig(data, timeout, timeUnit, (SshPasswordProvider)new PlatformSshPasswordProvider(data, false, 2, null), progressIndicator);
    }

    public static /* synthetic */ SessionConfig remoteCredentialsToSessionConfig$default(RemoteCredentials remoteCredentials, long l, TimeUnit timeUnit, Project project, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            timeUnit = TimeUnit.SECONDS;
        }
        if ((n & 0x10) != 0) {
            progressIndicator = null;
        }
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig(remoteCredentials, l, timeUnit, project, progressIndicator);
    }

    @JvmOverloads
    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit, @Nullable Project project) {
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig$default(data, timeout, timeUnit, project, null, 16, null);
    }

    @JvmOverloads
    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, long timeout, @Nullable Project project) {
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig$default(data, timeout, null, project, null, 20, null);
    }

    @JvmOverloads
    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, @Nullable Project project) {
        return SshConnectionServiceUtil.remoteCredentialsToSessionConfig$default(data, 0L, null, project, null, 22, null);
    }

    @NotNull
    public static final SessionConfig remoteCredentialsToSessionConfig(@NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit, @Nullable SshPasswordProvider sshPasswordProvider, @Nullable ProgressIndicator progressIndicator) {
        AgentProxyConnectorFactory agentProxyConnectorFactory;
        List list;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        int timeoutInMillis = SshConnectionUtil.toTimeoutInMillis((long)timeout, (TimeUnit)timeUnit);
        File knownHostsFile = null;
        File knownHostsFileCandidate = new File(SftpClientFactory.findSshDir(), "known_hosts");
        if (knownHostsFileCandidate.isFile() && knownHostsFileCandidate.canRead()) {
            knownHostsFile = knownHostsFileCandidate;
        }
        LinkedHashSet<Path> linkedHashSet = new LinkedHashSet<Path>();
        boolean bl = false;
        boolean bl2 = false;
        LinkedHashSet<Path> it = linkedHashSet;
        boolean bl3 = false;
        if (data.getAuthType() == AuthType.KEY_PAIR) {
            it.add(Paths.get(data.getPrivateKeyFile(), new String[0]));
        }
        LinkedHashSet<Path> privateKeys = linkedHashSet;
        switch (SshConnectionServiceUtil$WhenMappings.$EnumSwitchMapping$0[data.getAuthType().ordinal()]) {
            case 1: {
                list = CollectionsKt.listOf((Object[])new SessionConfig.AuthMethod[]{SessionConfig.AuthMethod.KEYBOARD_INTERACTIVE, SessionConfig.AuthMethod.PASSWORD});
                break;
            }
            case 2: {
                list = CollectionsKt.listOf((Object)SessionConfig.AuthMethod.PUBLIC_KEY);
                break;
            }
            case 3: {
                list = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List preferredAuthentications = list;
        OpenSSHClientConfig openSSHConfig = data.getAuthType() == AuthType.OPEN_SSH ? OpenSSHConfigService.Companion.getInstance().getConfig() : null;
        SshBackendLibrary sshBackendLibrary = SshBackendLibrary.Companion.get();
        Properties config = Ssh.createSessionConfig((SshBackendLibrary)sshBackendLibrary);
        String string = SshConnectionServiceUtil.computeUserName(data, openSSHConfig);
        String string2 = data.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"data.host");
        int n = SshConnectionServiceUtil.computePort(data, openSSHConfig);
        Integer n2 = timeoutInMillis;
        switch (SshConnectionServiceUtil$WhenMappings.$EnumSwitchMapping$1[data.getAuthType().ordinal()]) {
            case 1: {
                agentProxyConnectorFactory = SshConnectionService.Companion.getInstance().getAgentProxyConnectorFactory();
                break;
            }
            default: {
                agentProxyConnectorFactory = null;
            }
        }
        ProgressIndicator progressIndicator2 = progressIndicator;
        List list2 = preferredAuthentications;
        boolean bl4 = false;
        SshBackendLibrary sshBackendLibrary2 = sshBackendLibrary;
        OpenSSHClientConfig openSSHClientConfig = openSSHConfig;
        EventDispatcher eventDispatcher = null;
        File file = knownHostsFile;
        AgentProxyConnectorFactory agentProxyConnectorFactory2 = agentProxyConnectorFactory;
        SshHostKeyVerifier sshHostKeyVerifier = null;
        LinkedHashSet<Path> linkedHashSet2 = privateKeys;
        boolean bl5 = false;
        Integer n3 = null;
        Integer n4 = null;
        SocketFactory socketFactory = null;
        Proxy proxy = null;
        SshPasswordProvider sshPasswordProvider2 = sshPasswordProvider;
        Properties properties = config;
        Integer n5 = n2;
        return new SessionConfig(string, string2, n, properties, n5, sshPasswordProvider2, proxy, socketFactory, n4, n3, bl5, file, sshHostKeyVerifier, linkedHashSet2, agentProxyConnectorFactory2, eventDispatcher, sshBackendLibrary2, openSSHClientConfig, bl4, list2, progressIndicator2, 300992, null);
    }

    private static final String computeUserName(RemoteCredentials $this$computeUserName, OpenSSHClientConfig openSSHConfig) {
        String userName = $this$computeUserName.getUserName();
        if (userName == null) {
            if (openSSHConfig == null) {
                throw (Throwable)new IllegalStateException("User is not specified in connection settings");
            }
            userName = openSSHConfig.getConfig($this$computeUserName.getHost()).getUser();
            if (userName == null) {
                throw (Throwable)new IllegalStateException("User is neither specified in connection settings nor in OpenSSH client config");
            }
        }
        return userName;
    }

    private static final int computePort(RemoteCredentials $this$computePort, OpenSSHClientConfig openSSHConfig) {
        int port = $this$computePort.getPort();
        if (port == -1) {
            if (openSSHConfig == null) {
                throw (Throwable)new IllegalStateException("Port is not specified in connection settings");
            }
            port = openSSHConfig.getConfig($this$computePort.getHost()).getPort();
            if (port == -1) {
                throw (Throwable)new IllegalStateException("Port is neither specified in connection settings nor in OpenSSH client config");
            }
        }
        return port;
    }
}

