/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.ssh.target.wizard;

import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.ExecBuilder;
import com.intellij.ssh.process.SshExecProcess;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.target.ssh.target.wizard.SshTargetIntrospectable;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\f\u001a\u00020\b2\b\b\u0001\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002J,\u0010\u0012\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u000f0\u000f \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00110\u0011H\u0002J\u0018\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00112\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0018\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00112\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable;", "Lcom/intellij/execution/target/LanguageRuntimeType$Introspectable;", "connectionBuilder", "Lcom/intellij/ssh/ConnectionBuilder;", "textProvider", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable$TextProvider;", "(Lcom/intellij/ssh/ConnectionBuilder;Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable$TextProvider;)V", "pwd", "", "shell", "ensureShellInitialized", "", "executeCommand", "cmd", "wrapCommand", "", "getPwd", "Ljava/util/concurrent/CompletableFuture;", "isUnixPlatform", "kotlin.jvm.PlatformType", "promiseEnvironmentVariable", "varName", "promiseExecuteScript", "script", "Companion", "TextProvider", "intellij.remoteRun"})
public final class SshTargetIntrospectable
extends LanguageRuntimeType.Introspectable {
    private String pwd;
    private String shell;
    private final ConnectionBuilder connectionBuilder;
    private final TextProvider textProvider;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    private final CompletableFuture<String> getPwd() {
        if (this.pwd != null) {
            String string = this.pwd;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pwd");
            }
            CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(string);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(pwd)");
            return completableFuture;
        }
        try {
            String string = this.pwd = this.executeCommand("pwd", false);
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"pwd");
            }
            CompletableFuture<String> completableFuture = CompletableFuture.completedFuture(string);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.completedFuture(pwd)");
            return completableFuture;
        }
        catch (Throwable t) {
            CompletableFuture<String> completableFuture = CompletableFuture.failedFuture(t);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.failedFuture(t)");
            return completableFuture;
        }
    }

    private final CompletableFuture<Boolean> isUnixPlatform() {
        return this.getPwd().thenApply((Function)isUnixPlatform.1.INSTANCE);
    }

    private final String wrapCommand(String script) {
        this.ensureShellInitialized();
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.shell;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
        }
        return stringBuilder.append(string).append(" --login -c '").append(script).append('\'').toString();
    }

    private final void ensureShellInitialized() {
        if (this.shell == null) {
            String string = StringUtil.trim((String)this.executeCommand("echo ${SHELL}", false), (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.trim(executeC\u2026er.NOT_WHITESPACE_FILTER)");
            this.shell = string;
        }
    }

    @NotNull
    public CompletableFuture<String> promiseEnvironmentVariable(@NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        CompletionStage completionStage = this.isUnixPlatform().thenApply(new Function<Boolean, String>(this, varName){
            final /* synthetic */ SshTargetIntrospectable this$0;
            final /* synthetic */ String $varName;

            @Nullable
            public final String apply(boolean isUnix) {
                return SshTargetIntrospectable.access$executeCommand(this.this$0, "echo ${" + this.$varName + '}', isUnix);
            }
            {
                this.this$0 = sshTargetIntrospectable;
                this.$varName = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"isUnixPlatform().thenApp\u2026$varName}\", isUnix)\n    }");
        return completionStage;
    }

    private final String executeCommand(@NlsSafe String cmd, boolean wrapCommand) {
        String cmdToExecute = wrapCommand ? this.wrapCommand(cmd) : cmd;
        TextProvider textProvider2 = this.textProvider;
        if (textProvider2 != null) {
            textProvider2.printlnSystemText("> " + cmd);
        }
        try {
            SshExecProcess sshExecProcess = ExecBuilder.execute$default((ExecBuilder)this.connectionBuilder.execBuilder(cmdToExecute), (int)0, (boolean)true, (int)1, null);
            long timeoutMs = 10000L;
            boolean exited = sshExecProcess.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
            sshExecProcess.destroyForcibly();
            InputStream inputStream = sshExecProcess.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"sshExecProcess.inputStream");
            Object object = inputStream;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable = object;
            int n = 0;
            closeable = new InputStreamReader((InputStream)closeable, charset);
            n = 8192;
            boolean bl2 = false;
            String string = StringUtil.trimEnd((String)TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n))), (char)'\n');
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.trimEnd(sshEx\u2026eader().readText(), '\\n')");
            String output = string;
            object = output;
            boolean bl3 = false;
            if (object.length() > 0) {
                TextProvider textProvider3 = this.textProvider;
                if (textProvider3 != null) {
                    textProvider3.printlnText(output);
                }
            }
            LOG.debug("Command output: " + output);
            int exitValue = sshExecProcess.exitValue();
            TextProvider textProvider4 = this.textProvider;
            if (textProvider4 != null) {
                String string2 = RemoteSdkBundle.message("sst.target.introspectable.message.command.finished.with.exit.code.0", exitValue);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"RemoteSdkBundle.message(\u2026.exit.code.0\", exitValue)");
                textProvider4.printlnSystemText(string2);
            }
            if (exited) {
                LOG.info("Execution for '" + cmdToExecute + "' exited normally with code " + sshExecProcess.exitValue());
            } else {
                TextProvider textProvider5 = this.textProvider;
                if (textProvider5 != null) {
                    String string3 = RemoteSdkBundle.message("sst.target.introspectable.message.execution.was.killed.due.to.timeout", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"RemoteSdkBundle.message(\u2026s.killed.due.to.timeout\")");
                    textProvider5.printlnError(string3);
                }
                LOG.warn("Execution for '" + cmdToExecute + "' was killed due to timeout of " + timeoutMs + " ms");
            }
            if (exited && exitValue == 0) {
                return output;
            }
            throw (Throwable)new Exception(RemoteSdkBundle.message("sst.target.introspectable.message.getting.environment.failed.with.exit.value.0", exitValue));
        }
        catch (Exception e) {
            block10: {
                LOG.warn("Failed to execute '" + cmdToExecute + '\'', (Throwable)e);
                TextProvider textProvider6 = this.textProvider;
                if (textProvider6 == null) break block10;
                String string = RemoteSdkBundle.message("sst.target.introspectable.message.failed.to.execute.command", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RemoteSdkBundle.message(\u2026iled.to.execute.command\")");
                textProvider6.printlnError(string);
            }
            throw (Throwable)e;
        }
    }

    @NotNull
    public CompletableFuture<String> promiseExecuteScript(@NotNull String script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (Intrinsics.areEqual((Object)"pwd", (Object)script)) {
            CompletionStage completionStage = this.getPwd().thenApply((Function)promiseExecuteScript.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"getPwd().thenApply { it }");
            return completionStage;
        }
        CompletionStage completionStage = this.isUnixPlatform().thenApply(new Function<Boolean, String>(this, script){
            final /* synthetic */ SshTargetIntrospectable this$0;
            final /* synthetic */ String $script;

            @Nullable
            public final String apply(Boolean isUnix) {
                Boolean bl = isUnix;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"isUnix");
                return SshTargetIntrospectable.access$executeCommand(this.this$0, this.$script, bl);
            }
            {
                this.this$0 = sshTargetIntrospectable;
                this.$script = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"isUnixPlatform().thenApp\u2026and(script, isUnix)\n    }");
        return completionStage;
    }

    public SshTargetIntrospectable(@NotNull ConnectionBuilder connectionBuilder2, @Nullable TextProvider textProvider2) {
        Intrinsics.checkNotNullParameter((Object)connectionBuilder2, (String)"connectionBuilder");
        this.connectionBuilder = connectionBuilder2;
        this.textProvider = textProvider2;
    }

    public /* synthetic */ SshTargetIntrospectable(ConnectionBuilder connectionBuilder2, TextProvider textProvider2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            textProvider2 = null;
        }
        this(connectionBuilder2, textProvider2);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SshTargetIntrospectable.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ String access$getPwd$p(SshTargetIntrospectable $this) {
        String string = $this.pwd;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pwd");
        }
        return string;
    }

    public static final /* synthetic */ void access$setPwd$p(SshTargetIntrospectable $this, String string) {
        $this.pwd = string;
    }

    public static final /* synthetic */ String access$getShell$p(SshTargetIntrospectable $this) {
        String string = $this.shell;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"shell");
        }
        return string;
    }

    public static final /* synthetic */ void access$setShell$p(SshTargetIntrospectable $this, String string) {
        $this.shell = string;
    }

    public static final /* synthetic */ String access$executeCommand(SshTargetIntrospectable $this, String cmd, boolean wrapCommand) {
        return $this.executeCommand(cmd, wrapCommand);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H&J\u0012\u0010\u0007\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable$TextProvider;", "", "printlnError", "", "text", "", "printlnSystemText", "printlnText", "intellij.remoteRun"})
    public static interface TextProvider {
        public void printlnText(@Nls @NotNull String var1);

        public void printlnSystemText(@Nls @NotNull String var1);

        public void printlnError(@Nls @NotNull String var1);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/SshTargetIntrospectable$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.remoteRun"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

