/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.ssh.target;

import com.intellij.execution.Platform;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentAwareRunProfileState;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentFactory;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkBundle;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshEnvironment;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshRemoteEnvironmentRequest;
import com.jetbrains.plugins.remotesdk.target.ssh.target.SshTargetEnvironmentConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J'\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\u000b\u0010\u0010\u001a\u00070\b\u00a2\u0006\u0002\b\u000f2\u000b\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u000fH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshEnvironmentFactory;", "Lcom/intellij/execution/target/TargetEnvironmentFactory;", "project", "Lcom/intellij/openapi/project/Project;", "targetConfiguration", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetEnvironmentConfiguration;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/plugins/remotesdk/target/ssh/target/SshTargetEnvironmentConfiguration;)V", "createRequest", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "getTargetConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "getTargetPlatform", "Lcom/intellij/execution/target/TargetPlatform;", "prepareRemoteEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "Lorg/jetbrains/annotations/NotNull;", "request", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetEnvironmentAwareRunProfileState$TargetProgressIndicator;", "intellij.remoteRun"})
public final class SshEnvironmentFactory
implements TargetEnvironmentFactory {
    private final Project project;
    private final SshTargetEnvironmentConfiguration targetConfiguration;

    @NotNull
    public TargetPlatform getTargetPlatform() {
        return new TargetPlatform(Platform.UNIX);
    }

    @NotNull
    public TargetEnvironmentConfiguration getTargetConfiguration() {
        return this.targetConfiguration;
    }

    @NotNull
    public TargetEnvironmentRequest createRequest() {
        return new SshRemoteEnvironmentRequest(this.getTargetPlatform());
    }

    @NotNull
    public TargetEnvironment prepareRemoteEnvironment(@NotNull TargetEnvironmentRequest request, @NotNull TargetEnvironmentAwareRunProfileState.TargetProgressIndicator targetProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        RemoteCredentials remoteCredentials = this.targetConfiguration.findRemoteCredentials(this.project);
        if (remoteCredentials == null) {
            String string = RemoteSdkBundle.message("no.ssh.configuration.for.0", this.targetConfiguration.getDisplayName());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RemoteSdkBundle.message(\u2026onfiguration.displayName)");
            String string2 = string;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        RemoteCredentials remoteCredentials2 = remoteCredentials;
        return SshEnvironment.Companion.create(this.targetConfiguration, (SshRemoteEnvironmentRequest)request, RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)remoteCredentials2, (Project)this.project, null, (boolean)false, (int)6, null), remoteCredentials2, targetProgressIndicator, this.project);
    }

    public SshEnvironmentFactory(@Nullable Project project, @NotNull SshTargetEnvironmentConfiguration targetConfiguration) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetConfiguration), (String)"targetConfiguration");
        this.project = project;
        this.targetConfiguration = targetConfiguration;
    }
}

