/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.execution.CommandLineUtil;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.ShellChannelBuilder;
import com.intellij.ssh.SshSession;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.channels.ShellChannel;
import com.intellij.ssh.process.SshProcess;
import com.intellij.ssh.process.SshShellProcess;
import com.jediterm.terminal.TtyConnector;
import com.jetbrains.plugins.remotesdk.console.JschProcessTtyConnector;
import com.jetbrains.plugins.remotesdk.console.SshConsoleProcessHandler;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.TerminalUsageTriggerCollector;

public class SshTerminalDirectRunner
extends AbstractTerminalRunner<SshShellProcess> {
    private final RemoteCredentials myCredentials;
    private final Charset myDefaultCharset;

    public SshTerminalDirectRunner(Project project, RemoteCredentials credentials, Charset charset) {
        super(project);
        this.myCredentials = credentials;
        this.myDefaultCharset = charset;
    }

    public SshShellProcess createProcess(@Nullable String directory) throws ExecutionException {
        try {
            ShellChannel channel = this.getShellChannel();
            if (directory != null) {
                SshTerminalDirectRunner.issueCdCommand(channel, directory);
            }
            TerminalUsageTriggerCollector.triggerSshShellStarted((Project)this.myProject);
            return new SshShellProcess(channel);
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage(), e);
        }
    }

    @NotNull
    protected ShellChannel getShellChannel() throws RemoteSdkException {
        return this.createShellChannel();
    }

    @NotNull
    protected final ShellChannel createShellChannel() throws RemoteSdkException {
        ShellChannel shellChannel;
        try {
            shellChannel = ((ShellChannelBuilder)RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)this.myCredentials, (Project)this.myProject).shellBuilder().withAllocatePty(true)).openChannel();
        }
        catch (SshTransportException e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
        if (shellChannel == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(0);
        }
        return shellChannel;
    }

    protected static void issueCdCommand(@NotNull ShellChannel channel, @NotNull String directory) throws IOException {
        if (channel == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(1);
        }
        if (directory == null) {
            SshTerminalDirectRunner.$$$reportNull$$$0(2);
        }
        String cdCommand = "cd " + CommandLineUtil.posixQuote((String)directory) + "\n";
        channel.getOutputStream().write(cdCommand.getBytes(StandardCharsets.UTF_8));
        channel.getOutputStream().flush();
    }

    protected SshConsoleProcessHandler createProcessHandler(SshShellProcess process2) {
        return new SshConsoleProcessHandler((SshProcess<?>)process2);
    }

    @Nullable
    public String getCurrentWorkingDir(@Nullable TerminalTabState state) {
        return state == null ? null : state.myWorkingDirectory;
    }

    protected TtyConnector createTtyConnector(SshShellProcess process2) {
        return new JschProcessTtyConnector(process2, this.myDefaultCharset);
    }

    public String runningTargetName() {
        return this.myCredentials.getHost() + ":" + this.myCredentials.getLiteralPort();
    }

    protected String getTerminalConnectionName(SshShellProcess process2) {
        SshSession session = process2.getSession();
        return session.getUserName() + "@" + session.getHost() + ":" + session.getPort();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/console/SshTerminalDirectRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createShellChannel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/console/SshTerminalDirectRunner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "issueCdCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

