/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpstan.remote;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.xmlb.XmlSerializer;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.remote.tools.quality.QualityToolByInterpreterConfigurableForm;
import com.jetbrains.php.remote.tools.quality.QualityToolByInterpreterDialog;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolConfigurableForm;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.phpstan.PhpStanConfigurableForm;
import com.jetbrains.php.tools.quality.phpstan.PhpStanConfiguration;
import com.jetbrains.php.tools.quality.phpstan.PhpStanConfigurationManager;
import com.jetbrains.php.tools.quality.phpstan.PhpStanConfigurationProvider;
import com.jetbrains.php.tools.quality.phpstan.remote.PhpStanRemoteConfiguration;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpStanRemoteConfigurationProvider
extends PhpStanConfigurationProvider {
    @NonNls
    private static final String PHPSTAN_BY_INTERPRETER = "phpstan_by_interpreter";

    public boolean canLoad(@NotNull String tagName) {
        if (tagName == null) {
            PhpStanRemoteConfigurationProvider.$$$reportNull$$$0(0);
        }
        return StringUtil.equals((CharSequence)tagName, (CharSequence)PHPSTAN_BY_INTERPRETER);
    }

    @Nullable
    public PhpStanConfiguration load(@NotNull Element element) {
        if (element == null) {
            PhpStanRemoteConfigurationProvider.$$$reportNull$$$0(1);
        }
        return (PhpStanConfiguration)XmlSerializer.deserialize((Element)element, PhpStanRemoteConfiguration.class);
    }

    @Nullable
    public QualityToolConfigurableForm<PhpStanRemoteConfiguration> createConfigurationForm(@NotNull Project project, @NotNull PhpStanConfiguration settings) {
        if (project == null) {
            PhpStanRemoteConfigurationProvider.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            PhpStanRemoteConfigurationProvider.$$$reportNull$$$0(3);
        }
        if (settings instanceof PhpStanRemoteConfiguration) {
            PhpStanRemoteConfiguration remoteConfiguration = (PhpStanRemoteConfiguration)settings;
            PhpStanConfigurableForm<PhpStanRemoteConfiguration> delegate = new PhpStanConfigurableForm<PhpStanRemoteConfiguration>(project, remoteConfiguration);
            return new QualityToolByInterpreterConfigurableForm(project, (QualityToolConfiguration)remoteConfiguration, delegate);
        }
        return null;
    }

    public PhpStanConfiguration createNewInstance(@Nullable Project project, @NotNull List<PhpStanConfiguration> existingSettings) {
        String id;
        QualityToolByInterpreterDialog dialog;
        if (existingSettings == null) {
            PhpStanRemoteConfigurationProvider.$$$reportNull$$$0(4);
        }
        if ((dialog = new QualityToolByInterpreterDialog(project, existingSettings, "PHPStan", PhpStanRemoteConfiguration.class)).showAndGet() && StringUtil.isNotEmpty((String)(id = PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterId(dialog.getSelectedInterpreterName())))) {
            PhpStanRemoteConfiguration settings = new PhpStanRemoteConfiguration();
            settings.setInterpreterId(id);
            PhpSdkAdditionalData data = PhpInterpretersManagerImpl.getInstance((Project)project).findInterpreterDataById(id);
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            if (manager != null && data != null && project != null) {
                PathMappingSettings mappings = manager.createPathMappings(project, data);
                this.fillSettingsByDefaultValue(settings, (PhpStanConfiguration)PhpStanConfigurationManager.getInstance(project).getLocalSettings(), (NullableFunction<String, String>)((NullableFunction)localPath -> localPath == null ? null : mappings.convertToRemote(localPath)));
            }
            return settings;
        }
        return null;
    }

    public PhpStanConfiguration createConfigurationByInterpreter(@NotNull PhpInterpreter interpreter) {
        if (interpreter == null) {
            PhpStanRemoteConfigurationProvider.$$$reportNull$$$0(5);
        }
        PhpStanRemoteConfiguration settings = new PhpStanRemoteConfiguration();
        settings.setInterpreterId(interpreter.getId());
        return settings;
    }

    protected void fillSettingsByDefaultValue(@NotNull PhpStanConfiguration settings, @NotNull PhpStanConfiguration localConfiguration, @NotNull NullableFunction<String, String> preparePath) {
        if (settings == null) {
            PhpStanRemoteConfigurationProvider.$$$reportNull$$$0(6);
        }
        if (localConfiguration == null) {
            PhpStanRemoteConfigurationProvider.$$$reportNull$$$0(7);
        }
        if (preparePath == null) {
            PhpStanRemoteConfigurationProvider.$$$reportNull$$$0(8);
        }
        super.fillSettingsByDefaultValue((QualityToolConfiguration)settings, (QualityToolConfiguration)localConfiguration, preparePath);
        settings.setTimeout(60000);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localConfiguration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preparePath";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/tools/quality/phpstan/remote/PhpStanRemoteConfigurationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canLoad";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfigurationForm";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewInstance";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfigurationByInterpreter";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "fillSettingsByDefaultValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

