/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpstan;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolMessage;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.tools.quality.QualityToolXmlMessageProcessor;
import com.jetbrains.php.tools.quality.phpstan.PhpStanGlobalInspection;
import com.jetbrains.php.tools.quality.phpstan.PhpStanQualityToolType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PhpStanMessageProcessor
extends QualityToolXmlMessageProcessor {
    private static final String ERROR_TAG = "error";
    private static final String FILE_TAG = "file";
    @NonNls
    private static final String WARNING_MESSAGE_START = "<file";
    @NonNls
    private static final String WARNING_MESSAGE_END = "</file>";
    private static final String WARNING_TAG = "warning";
    @NonNls
    private static final String LINE_NUMBER_ATTR = "line";
    @NonNls
    private static final String COLUMN_NUMBER_ATTR = "column";
    private static final String MESSAGE_ATTR = "message";
    @NonNls
    private static final String SEVERITY_ATTR = "severity";
    private static final String FILE_NAME_ATTR = "name";
    private final Set<QualityToolXmlMessageProcessor.ProblemDescription> lineMessages = new HashSet<QualityToolXmlMessageProcessor.ProblemDescription>();
    private final HighlightDisplayLevel myWarningsHighlightLevel = HighlightDisplayLevel.WARNING;
    final String myFilePath;
    final PsiFile myPsiFile;
    final Project myProject;

    protected PhpStanMessageProcessor(QualityToolAnnotatorInfo info) {
        super(info);
        this.myFilePath = info.getTempFilePath();
        this.myPsiFile = info.getPsiFile();
        this.myProject = info.getProject();
    }

    protected void processMessage(InputSource source) throws SAXException, IOException {
        PhpStanXmlMessageHandler messageHandler = (PhpStanXmlMessageHandler)this.getXmlMessageHandler(this.myFilePath);
        this.mySAXParser.parse(source, (DefaultHandler)((Object)messageHandler));
        if (messageHandler.isStatusValid()) {
            if (this.myPsiFile != null) {
                for (QualityToolXmlMessageProcessor.ProblemDescription problem : messageHandler.getProblemList()) {
                    Document document = PsiDocumentManager.getInstance((Project)this.myPsiFile.getProject()).getDocument(this.myPsiFile);
                    QualityToolMessage qualityToolMessage = document != null && problem.getLineNumber() - 1 > 0 && problem.getLineNumber() - 1 < document.getLineCount() ? new QualityToolMessage((QualityToolMessageProcessor)this, TextRange.create((int)(document.getLineStartOffset(problem.getLineNumber() - 1) + problem.getColumn()), (int)document.getLineEndOffset(problem.getLineNumber() - 1)), problem.getSeverity(), problem.getMessage(), new IntentionAction[0]) : new QualityToolMessage((QualityToolMessageProcessor)this, problem.getLineNumber(), problem.getSeverity(), problem.getMessage(), new IntentionAction[0]);
                    if (!this.lineMessages.add(problem)) continue;
                    this.addMessage(qualityToolMessage);
                }
            } else {
                List data = (List)this.myProject.getUserData(PhpStanGlobalInspection.PHPSTAN_ANNOTATOR_INFO);
                if (data != null) {
                    data.addAll(messageHandler.getProblemList());
                    this.myProject.putUserData(PhpStanGlobalInspection.PHPSTAN_ANNOTATOR_INFO, (Object)data);
                } else {
                    this.myProject.putUserData(PhpStanGlobalInspection.PHPSTAN_ANNOTATOR_INFO, messageHandler.getProblemList());
                }
            }
        }
    }

    protected QualityToolXmlMessageProcessor.XMLMessageHandler getXmlMessageHandler() {
        return null;
    }

    protected QualityToolXmlMessageProcessor.XMLMessageHandler getXmlMessageHandler(@Nullable String filePath) {
        return new PhpStanXmlMessageHandler(filePath);
    }

    public int getMessageStart(@NotNull String line) {
        if (line == null) {
            PhpStanMessageProcessor.$$$reportNull$$$0(0);
        }
        return line.indexOf(WARNING_MESSAGE_START);
    }

    public int getMessageEnd(@NotNull String line) {
        if (line == null) {
            PhpStanMessageProcessor.$$$reportNull$$$0(1);
        }
        return line.indexOf(WARNING_MESSAGE_END);
    }

    @NonNls
    @Nullable
    protected String getMessagePrefix() {
        return "phpstan";
    }

    @Nullable
    protected HighlightDisplayLevel severityToDisplayLevel(@NotNull QualityToolMessage.Severity severity) {
        if (severity == null) {
            PhpStanMessageProcessor.$$$reportNull$$$0(2);
        }
        return QualityToolMessage.Severity.WARNING.equals((Object)severity) ? this.myWarningsHighlightLevel : null;
    }

    protected QualityToolType getQualityToolType() {
        return PhpStanQualityToolType.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = LINE_NUMBER_ATTR;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = SEVERITY_ATTR;
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/tools/quality/phpstan/PhpStanMessageProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMessageStart";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMessageEnd";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "severityToDisplayLevel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class PhpStanXmlMessageHandler
    extends QualityToolXmlMessageProcessor.XMLMessageHandler {
        private final String myFilePath;
        private String myFileAttr;
        private List<QualityToolXmlMessageProcessor.ProblemDescription> myProblemList;

        private PhpStanXmlMessageHandler(@Nullable String filePath) {
            this.myFilePath = filePath;
        }

        private List<QualityToolXmlMessageProcessor.ProblemDescription> getProblemList() {
            return this.myProblemList;
        }

        protected void parseTag(@NotNull String tagName, @NotNull Attributes attributes) {
            if (tagName == null) {
                PhpStanXmlMessageHandler.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                PhpStanXmlMessageHandler.$$$reportNull$$$0(1);
            }
            if (PhpStanMessageProcessor.FILE_TAG.equals(tagName)) {
                this.myFileAttr = PathUtil.toSystemIndependentName((String)attributes.getValue(PhpStanMessageProcessor.FILE_NAME_ATTR));
                this.myProblemList = this.myFilePath == null || this.myFilePath.equals(this.myFileAttr) ? new ArrayList<QualityToolXmlMessageProcessor.ProblemDescription>() : null;
            } else if (PhpStanMessageProcessor.ERROR_TAG.equals(tagName) | PhpStanMessageProcessor.WARNING_TAG.equals(tagName) && this.myProblemList != null) {
                this.mySeverity = attributes.getValue(PhpStanMessageProcessor.SEVERITY_ATTR).equals(PhpStanMessageProcessor.ERROR_TAG) ? QualityToolMessage.Severity.ERROR : QualityToolMessage.Severity.WARNING;
                this.myLineNumber = PhpStanXmlMessageHandler.parseLineNumber((String)attributes.getValue(PhpStanMessageProcessor.LINE_NUMBER_ATTR));
                int column = PhpStanXmlMessageHandler.parseLineNumber((String)attributes.getValue(PhpStanMessageProcessor.COLUMN_NUMBER_ATTR));
                this.myProblemList.add(new QualityToolXmlMessageProcessor.ProblemDescription(this.mySeverity, this.myLineNumber, Math.max(0, column - 1), attributes.getValue(PhpStanMessageProcessor.MESSAGE_ATTR), this.myFileAttr));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tagName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "attributes";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/tools/quality/phpstan/PhpStanMessageProcessor$PhpStanXmlMessageHandler";
            objectArray[2] = "parseTag";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

