/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpstan;

import com.google.gson.JsonElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.tools.quality.QualityToolConfigurationManager;
import com.jetbrains.php.tools.quality.QualityToolsComposerConfig;
import com.jetbrains.php.tools.quality.phpstan.PhpStanConfiguration;
import com.jetbrains.php.tools.quality.phpstan.PhpStanConfigurationManager;
import com.jetbrains.php.tools.quality.phpstan.PhpStanGlobalInspection;
import com.jetbrains.php.tools.quality.phpstan.PhpStanOpenSettingsProvider;
import com.jetbrains.php.tools.quality.phpstan.PhpStanQualityToolType;
import com.jetbrains.php.tools.quality.phpstan.PhpStanValidationInspection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpStanComposerConfig
extends QualityToolsComposerConfig<PhpStanConfiguration, PhpStanValidationInspection> {
    @NonNls
    private static final String PACKAGE = "phpstan/phpstan";
    @NonNls
    private static final String RELATIVE_PATH = "bin/phpstan" + (SystemInfo.isWindows ? ".bat" : "");
    @NonNls
    private static final String PHPSTAN_NEON = "phpstan.neon";

    public PhpStanComposerConfig() {
        super(PACKAGE, RELATIVE_PATH);
    }

    protected ComposerLogMessageBuilder.Settings getQualityToolsInspectionSettings() {
        return null;
    }

    public String getQualityInspectionShortName() {
        return PhpStanQualityToolType.INSTANCE.getInspectionId();
    }

    protected boolean applyRulesetFromComposer(@NotNull Project project, PhpStanConfiguration configuration) {
        if (project == null) {
            PhpStanComposerConfig.$$$reportNull$$$0(0);
        }
        String configPath = ComposerDataService.getInstance((Project)project).getConfigPath();
        VirtualFile config = LocalFileSystem.getInstance().refreshAndFindFileByPath(configPath);
        if (config == null) {
            return false;
        }
        String ruleset = this.getRuleset(config);
        if (ruleset == null) {
            return false;
        }
        VirtualFile customRulesetFile = this.detectCustomRulesetFile(config.getParent(), ruleset);
        if (customRulesetFile != null) {
            return this.modifyRulesetPhpStanInspectionSetting(project, (Consumer<PhpStanGlobalInspection>)((Consumer)tool -> PhpStanComposerConfig.applyRuleset(tool, customRulesetFile.getPath())));
        }
        return false;
    }

    protected boolean applyRulesetFromRoot(@NotNull Project project) {
        VirtualFile customRulesetFile;
        if (project == null) {
            PhpStanComposerConfig.$$$reportNull$$$0(1);
        }
        if ((customRulesetFile = this.detectCustomRulesetFile(project.getBaseDir(), PHPSTAN_NEON)) == null) {
            customRulesetFile = this.detectCustomRulesetFile(project.getBaseDir(), "phpstan.neon.dist");
        }
        if (customRulesetFile != null) {
            String path = customRulesetFile.getPath();
            return this.modifyRulesetPhpStanInspectionSetting(project, (Consumer<PhpStanGlobalInspection>)((Consumer)tool -> PhpStanComposerConfig.applyRuleset(tool, path)));
        }
        return false;
    }

    protected void checkComposerScriptsLeaves(JsonElement element, Ref<String> result) {
        String string = element.getAsString();
        if (string != null && string.contains("phpstan")) {
            List split = StringUtil.split((String)string, (String)" ");
            for (String arg : split) {
                String prefix = "--configuration=";
                if (StringUtil.startsWith((CharSequence)arg, (CharSequence)"--configuration=")) {
                    result.set((Object)StringUtil.trimStart((String)arg, (String)"--configuration="));
                    return;
                }
                int index = split.indexOf(arg);
                if (!StringUtil.equals((CharSequence)arg, (CharSequence)"-c") || index >= split.size() - 1) continue;
                result.set((Object)((String)split.get(index + 1)));
                return;
            }
        }
    }

    @Nullable
    public ComposerLogMessageBuilder.Settings getSettings() {
        return PhpStanOpenSettingsProvider.PHP_STAN_OPEN_SETTINGS_PROVIDER;
    }

    private static void applyRuleset(PhpStanGlobalInspection tool, @NlsSafe String customRuleset) {
        tool.config = customRuleset;
    }

    protected boolean modifyRulesetPhpStanInspectionSetting(@NotNull Project project, @NotNull Consumer<PhpStanGlobalInspection> consumer) {
        VirtualFile projectDir;
        if (project == null) {
            PhpStanComposerConfig.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            PhpStanComposerConfig.$$$reportNull$$$0(3);
        }
        if ((projectDir = project.getBaseDir()) == null) {
            return false;
        }
        PsiDirectory file = PsiManager.getInstance((Project)project).findDirectory(projectDir);
        if (file != null) {
            Key key = Key.create((String)PhpStanQualityToolType.INSTANCE.getInspectionId());
            InspectionProfileManager.getInstance((Project)project).getCurrentProfile().modifyToolSettings(key, (PsiElement)file, consumer);
            return true;
        }
        return false;
    }

    @NotNull
    public QualityToolConfigurationManager<PhpStanConfiguration> getConfigurationManager(@NotNull Project project) {
        if (project == null) {
            PhpStanComposerConfig.$$$reportNull$$$0(4);
        }
        PhpStanConfigurationManager phpStanConfigurationManager = PhpStanConfigurationManager.getInstance(project);
        if (phpStanConfigurationManager == null) {
            PhpStanComposerConfig.$$$reportNull$$$0(5);
        }
        return phpStanConfigurationManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpstan/PhpStanComposerConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpstan/PhpStanComposerConfig";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetFromComposer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetFromRoot";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "modifyRulesetPhpStanInspectionSetting";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationManager";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

