/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.beans;

import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupRemoteDescriptors;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.beans.EventDataField;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationSimpleRuleFactory;
import com.intellij.internal.statistic.eventLog.validator.storage.GlobalRulesHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventGroupRules {
    public static final EventGroupRules EMPTY = new EventGroupRules(Collections.emptySet(), Collections.emptyMap(), EventGroupContextData.EMPTY, new ValidationSimpleRuleFactory(ValidationSimpleRuleFactory.REJECTING_UTIL_URL_PRODUCER), Collections.emptyList());
    private final FUSRule[] eventIdRules;
    private final Map<String, FUSRule[]> eventDataRules = new ConcurrentHashMap<String, FUSRule[]>();
    private final List<String> VALIDATION_TYPES = Arrays.stream(ValidationResultType.values()).map(ValidationResultType::getDescription).collect(Collectors.toList());
    private final List<String> myExcludedFields;

    private EventGroupRules(@Nullable Set<String> eventIdRules, @Nullable Map<String, Set<String>> eventDataRules, @NotNull EventGroupContextData contextData, @NotNull ValidationSimpleRuleFactory factory, @NotNull List<String> excludedFields) {
        this.myExcludedFields = excludedFields;
        this.eventIdRules = factory.getRules(eventIdRules, contextData);
        if (eventDataRules != null) {
            for (Map.Entry<String, Set<String>> entry : eventDataRules.entrySet()) {
                if (this.myExcludedFields.contains(entry.getKey())) {
                    this.eventDataRules.put(entry.getKey(), new FUSRule[]{FUSRule.TRUE});
                    continue;
                }
                this.eventDataRules.put(entry.getKey(), factory.getRules(entry.getValue(), contextData));
            }
        }
    }

    public FUSRule[] getEventIdRules() {
        return this.eventIdRules;
    }

    public Map<String, FUSRule[]> getEventDataRules() {
        return this.eventDataRules;
    }

    public boolean areEventIdRulesDefined() {
        return this.eventIdRules.length > 0;
    }

    public boolean areEventDataRulesDefined() {
        return this.eventDataRules.size() > 0;
    }

    public ValidationResultType validateEventId(@NotNull EventContext context) {
        ValidationResultType prevResult = null;
        if (this.VALIDATION_TYPES.contains(context.eventId)) {
            return ValidationResultType.ACCEPTED;
        }
        for (FUSRule rule : this.eventIdRules) {
            ValidationResultType resultType = rule.validate(context.eventId, context);
            if (resultType.isFinal()) {
                return resultType;
            }
            prevResult = resultType;
        }
        return prevResult != null ? prevResult : ValidationResultType.REJECTED;
    }

    public EventDataField validateEventData(@NotNull String key, @Nullable Object data, @NotNull EventContext context) {
        return this.validateEventData(key, data, context, key);
    }

    private EventDataField validateEventData(@NotNull String key, @Nullable Object data, @NotNull EventContext context, @NotNull String fieldName) {
        if (data == null) {
            return new EventDataField(fieldName, ValidationResultType.REJECTED.getDescription());
        }
        if (data instanceof String && this.VALIDATION_TYPES.contains(data)) {
            return new EventDataField(fieldName, data);
        }
        if (this.myExcludedFields.contains(key)) {
            return new EventDataField(fieldName, data);
        }
        if (data instanceof Map) {
            HashMap<String, Object> validatedData = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)data).entrySet()) {
                Object entryKey = entry.getKey();
                if (entryKey instanceof String) {
                    EventDataField field = this.validateEventData(key + "." + entryKey, entry.getValue(), context, (String)entryKey);
                    validatedData.put(field.getName(), field.getValue());
                    continue;
                }
                validatedData.put((String)entryKey, ValidationResultType.REJECTED.getDescription());
            }
            String validatedFieldName = fieldName;
            if (!validatedData.isEmpty() && validatedData.keySet().stream().allMatch(value -> value instanceof String && ValidationResultType.UNDEFINED_RULE.getDescription().equals(value))) {
                validatedFieldName = ValidationResultType.UNDEFINED_RULE.getDescription();
            }
            return new EventDataField(validatedFieldName, validatedData);
        }
        if (data instanceof List) {
            ArrayList<Object> validatedData = new ArrayList<Object>();
            ArrayList<String> fieldNames = new ArrayList<String>();
            for (Object value2 : (List)data) {
                EventDataField validatedField = this.validateEventData(key, value2, context, fieldName);
                validatedData.add(validatedField.getValue());
                fieldNames.add(validatedField.getName());
            }
            String validatedFieldName = fieldName;
            if (!validatedData.isEmpty() && fieldNames.stream().allMatch(value -> ValidationResultType.UNDEFINED_RULE.getDescription().equals(value))) {
                validatedFieldName = ValidationResultType.UNDEFINED_RULE.getDescription();
            }
            return new EventDataField(validatedFieldName, validatedData);
        }
        FUSRule[] rules = this.eventDataRules.get(key);
        if (rules == null || rules.length == 0) {
            return new EventDataField(ValidationResultType.UNDEFINED_RULE.getDescription(), ValidationResultType.UNDEFINED_RULE.getDescription());
        }
        return new EventDataField(fieldName, EventGroupRules.validateValue(data, context, rules));
    }

    private static Object validateValue(@NotNull Object data, @NotNull EventContext context, FUSRule @NotNull [] rules) {
        ValidationResultType resultType = EventGroupRules.acceptRule(data.toString(), context, rules);
        return resultType == ValidationResultType.ACCEPTED ? data : resultType.getDescription();
    }

    private static ValidationResultType acceptRule(@NotNull String ruleData, @NotNull EventContext context, FUSRule ... rules) {
        if (rules == null) {
            return ValidationResultType.UNDEFINED_RULE;
        }
        ValidationResultType prevResult = null;
        for (FUSRule rule : rules) {
            ValidationResultType resultType = rule.validate(ruleData, context);
            if (resultType.isFinal()) {
                return resultType;
            }
            prevResult = resultType;
        }
        return prevResult != null ? prevResult : ValidationResultType.REJECTED;
    }

    @NotNull
    public static EventGroupRules create(@NotNull EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group, @NotNull GlobalRulesHolder globalRulesHolder, @NotNull ValidationSimpleRuleFactory factory, @NotNull List<String> excludedFields) {
        EventGroupRemoteDescriptors.GroupRemoteRule rules = group.rules;
        return rules == null ? EMPTY : new EventGroupRules(rules.event_id, rules.event_data, new EventGroupContextData(rules.enums, rules.regexps, globalRulesHolder), factory, excludedFields);
    }
}

