/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules;

import com.intellij.internal.statistic.eventLog.validator.rules.PayloadKey;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class EventContext {
    public final String eventId;
    public final Map<String, Object> eventData;
    public final Map<String, Object> myPayload = new HashMap<String, Object>();

    private EventContext(@NotNull String eventId, @NotNull Map<String, Object> eventData) {
        this.eventId = eventId;
        this.eventData = EventContext.unmodifiableOrEmptyMap(eventData);
    }

    @Contract(pure=true)
    @NotNull
    public static Map<String, Object> unmodifiableOrEmptyMap(@NotNull Map<String, Object> original) {
        int size = original.size();
        if (size == 0) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(original);
    }

    public static EventContext create(@NotNull String eventId, @NotNull Map<String, Object> eventData) {
        return new EventContext(eventId, eventData);
    }

    public <T> T getPayload(PayloadKey<T> key) {
        return (T)this.myPayload.get(key.getKey());
    }

    public <T> void setPayload(PayloadKey<T> key, T value) {
        this.myPayload.put(key.getKey(), value);
    }
}

