/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator;

import com.intellij.internal.statistic.eventLog.EventLogSystemEvents;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventAction;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupsFilterRules;
import com.intellij.internal.statistic.eventLog.validator.GroupValidators;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.ValidationRuleStorage;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupRules;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.beans.EventDataField;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 (*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003:\u0001(B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\u001a\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014Jn\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u0004\u0018\u00010\u00122\u0006\u0010#\u001a\u00020\u0012J*\u0010$\u001a\u00020%2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u0003H\u0002R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006)"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/SensitiveDataValidator;", "S", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationRuleStorage;", "", "validationRulesStorage", "(Lcom/intellij/internal/statistic/eventLog/validator/ValidationRuleStorage;)V", "getValidationRulesStorage", "()Lcom/intellij/internal/statistic/eventLog/validator/ValidationRuleStorage;", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationRuleStorage;", "guaranteeCorrectEventData", "", "", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "groupRules", "Lcom/intellij/internal/statistic/eventLog/validator/rules/beans/EventGroupRules;", "guaranteeCorrectEventId", "validate", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "groupId", "groupVersion", "build", "sessionId", "bucket", "eventTime", "", "recorderVersion", "eventId", "data", "", "isState", "", "count", "", "validateEvent", "event", "validateEventData", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/beans/EventDataField;", "key", "entryValue", "Companion", "ap-validation"})
public class SensitiveDataValidator<S extends ValidationRuleStorage<?>> {
    @NotNull
    private final S validationRulesStorage;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final LogEvent validateEvent(@NotNull LogEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LogEventAction logEventAction = event.getEvent();
        return this.validate(event.getGroup().getId(), event.getGroup().getVersion(), event.getBuild(), event.getSession(), event.getBucket(), event.getTime(), event.getRecorderVersion(), logEventAction.getId(), logEventAction.getData(), logEventAction.getState(), logEventAction.getCount());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final LogEvent validate(@NotNull String groupId, @NotNull String groupVersion, @NotNull String build, @NotNull String sessionId, @NotNull String bucket, long eventTime, @NotNull String recorderVersion, @NotNull String eventId, @NotNull Map<String, ? extends Object> data, boolean isState, int count) {
        void groupRules;
        EventContext context;
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)groupVersion, (String)"groupVersion");
        Intrinsics.checkNotNullParameter((Object)build, (String)"build");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)bucket, (String)"bucket");
        Intrinsics.checkNotNullParameter((Object)recorderVersion, (String)"recorderVersion");
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        GroupValidators groupValidators = this.validationRulesStorage.getGroupValidators(groupId);
        EventGroupRules eventGroupRules = groupValidators.component1();
        EventGroupsFilterRules versionFilter = groupValidators.component2();
        if (versionFilter != null && !versionFilter.accepts(groupId, groupVersion, build)) {
            return null;
        }
        EventContext eventContext = context = EventContext.create(eventId, data);
        Intrinsics.checkNotNullExpressionValue((Object)eventContext, (String)"context");
        String validatedEventId = this.guaranteeCorrectEventId(eventContext, (EventGroupRules)groupRules);
        Map<String, Object> validatedEventData = this.guaranteeCorrectEventData(context, (EventGroupRules)groupRules);
        LogEventAction validatedEvent = new LogEventAction(validatedEventId, isState, count);
        Map<String, Object> map = validatedEventData;
        boolean bl = false;
        for (Map.Entry<String, Object> datum : map.entrySet()) {
            validatedEvent.addData(datum.getKey(), datum.getValue());
        }
        return new LogEvent(sessionId, build, bucket, eventTime, groupId, groupVersion, recorderVersion, validatedEvent);
    }

    public static /* synthetic */ LogEvent validate$default(SensitiveDataValidator sensitiveDataValidator, String string, String string2, String string3, String string4, String string5, long l, String string6, String string7, Map map, boolean bl, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: validate");
        }
        if ((n2 & 0x400) != 0) {
            n = 1;
        }
        return sensitiveDataValidator.validate(string, string2, string3, string4, string5, l, string6, string7, map, bl, n);
    }

    @NotNull
    protected String guaranteeCorrectEventId(@NotNull EventContext context, @Nullable EventGroupRules groupRules) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.validationRulesStorage.isUnreachable()) {
            String string2 = ValidationResultType.UNREACHABLE_METADATA.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ValidationResultType.UNR\u2026ABLE_METADATA.description");
            return string2;
        }
        if (EventLogSystemEvents.SYSTEM_EVENTS.contains(context.eventId)) {
            String string3 = context.eventId;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.eventId");
            return string3;
        }
        ValidationResultType validationResultType = Companion.validateEvent(context, groupRules);
        if (validationResultType == ValidationResultType.ACCEPTED) {
            String string4 = context.eventId;
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.eventId");
        } else {
            String string5 = validationResultType.getDescription();
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"validationResultType.description");
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Map<String, Object> guaranteeCorrectEventData(@NotNull EventContext context, @Nullable EventGroupRules groupRules) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map validatedData = new HashMap();
        Map<String, Object> map = context.eventData;
        Intrinsics.checkNotNullExpressionValue(map, (String)"context.eventData");
        Object object = map;
        boolean bl = false;
        for (Map.Entry<String, Object> entry : object.entrySet()) {
            void validatedFieldName;
            void key;
            Object object2 = entry;
            boolean bl2 = false;
            object = object2.getKey();
            object2 = entry;
            bl2 = false;
            Object entryValue = object2.getValue();
            void v1 = key;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"key");
            Object object3 = entryValue;
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"entryValue");
            EventDataField eventDataField = this.validateEventData(context, groupRules, (String)v1, object3);
            object2 = eventDataField.component1();
            Object validateEventData = eventDataField.component2();
            validatedData.put(validatedFieldName, validateEventData);
        }
        return validatedData;
    }

    private final EventDataField validateEventData(EventContext context, EventGroupRules groupRules, String key, Object entryValue) {
        if (this.validationRulesStorage.isUnreachable()) {
            String string = ValidationResultType.UNREACHABLE_METADATA.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ValidationResultType.UNR\u2026ABLE_METADATA.description");
            String string2 = ValidationResultType.UNREACHABLE_METADATA.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ValidationResultType.UNR\u2026ABLE_METADATA.description");
            return new EventDataField(string, string2);
        }
        if (groupRules == null) {
            String string = ValidationResultType.UNDEFINED_RULE.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ValidationResultType.UNDEFINED_RULE.description");
            String string3 = ValidationResultType.UNDEFINED_RULE.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ValidationResultType.UNDEFINED_RULE.description");
            return new EventDataField(string, string3);
        }
        EventDataField eventDataField = groupRules.validateEventData(key, entryValue, context);
        Intrinsics.checkNotNullExpressionValue((Object)eventDataField, (String)"groupRules.validateEvent\u2026key, entryValue, context)");
        return eventDataField;
    }

    @NotNull
    public final S getValidationRulesStorage() {
        return this.validationRulesStorage;
    }

    public SensitiveDataValidator(@NotNull S validationRulesStorage) {
        Intrinsics.checkNotNullParameter(validationRulesStorage, (String)"validationRulesStorage");
        this.validationRulesStorage = validationRulesStorage;
    }

    @JvmStatic
    @NotNull
    public static final ValidationResultType validateEvent(@NotNull EventContext context, @Nullable EventGroupRules groupRules) {
        return Companion.validateEvent(context, groupRules);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/SensitiveDataValidator$Companion;", "", "()V", "validateEvent", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "groupRules", "Lcom/intellij/internal/statistic/eventLog/validator/rules/beans/EventGroupRules;", "ap-validation"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ValidationResultType validateEvent(@NotNull EventContext context, @Nullable EventGroupRules groupRules) {
            ValidationResultType validationResultType;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (groupRules == null || !groupRules.areEventIdRulesDefined()) {
                validationResultType = ValidationResultType.UNDEFINED_RULE;
            } else {
                ValidationResultType validationResultType2 = groupRules.validateEventId(context);
                validationResultType = validationResultType2;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)validationResultType2), (String)"groupRules.validateEventId(context)");
            }
            return validationResultType;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

