/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection.metadata;

import com.intellij.internal.statistic.eventLog.connection.metadata.EventGroupRemoteDescriptors;
import com.intellij.internal.statistic.eventLog.connection.metadata.EventLogBuildParser;
import com.intellij.internal.statistic.eventLog.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventGroupFilterRules<T extends Comparable<T>> {
    private final List<BuildRange<T>> builds;
    private final List<VersionRange> versions;

    public EventGroupFilterRules(@NotNull List<BuildRange<T>> builds, @NotNull List<VersionRange> versions) {
        this.builds = builds;
        this.versions = versions;
    }

    @NotNull
    public static <P extends Comparable<P>> EventGroupFilterRules<P> create(@NotNull EventGroupRemoteDescriptors.EventGroupRemoteDescriptor group, @NotNull EventLogBuildParser<P> buildProducer) {
        return EventGroupFilterRules.create(group.builds, group.versions, buildProducer);
    }

    @NotNull
    private static <P extends Comparable<P>> EventGroupFilterRules<P> create(@Nullable List<EventGroupRemoteDescriptors.GroupBuildRange> builds, @Nullable List<EventGroupRemoteDescriptors.GroupVersionRange> versions, @NotNull EventLogBuildParser<P> buildProducer) {
        List buildRanges = builds != null && !builds.isEmpty() ? EventGroupFilterRules.toBuildRanges(builds, buildProducer) : Collections.emptyList();
        List<VersionRange> versionRanges = versions != null && !versions.isEmpty() ? EventGroupFilterRules.toVersionRanges(versions) : Collections.emptyList();
        return new EventGroupFilterRules(buildRanges, versionRanges);
    }

    @NotNull
    private static <P extends Comparable<P>> List<BuildRange<P>> toBuildRanges(@NotNull List<EventGroupRemoteDescriptors.GroupBuildRange> builds, @NotNull EventLogBuildParser<P> buildProducer) {
        ArrayList<BuildRange<P>> result = new ArrayList<BuildRange<P>>();
        for (EventGroupRemoteDescriptors.GroupBuildRange build : builds) {
            result.add(BuildRange.create(build.from, build.to, buildProducer));
        }
        return result;
    }

    @NotNull
    private static List<VersionRange> toVersionRanges(@NotNull List<EventGroupRemoteDescriptors.GroupVersionRange> versions) {
        ArrayList<VersionRange> result = new ArrayList<VersionRange>();
        for (EventGroupRemoteDescriptors.GroupVersionRange version : versions) {
            result.add(VersionRange.create(version.from, version.to));
        }
        return result;
    }

    public boolean accepts(@Nullable T build, int version) {
        return this.accepts(build) && this.acceptsVersion(version);
    }

    public boolean accepts(@Nullable T build) {
        if (!this.isValid()) {
            return false;
        }
        return this.acceptsBuild(build);
    }

    private boolean acceptsBuild(@Nullable T build) {
        if (this.builds.isEmpty()) {
            return true;
        }
        return build != null && this.builds.stream().anyMatch(b -> b.contains(build));
    }

    private boolean acceptsVersion(int version) {
        if (this.versions.isEmpty()) {
            return true;
        }
        return version > 0 && this.versions.stream().anyMatch(v -> v.contains(version));
    }

    private boolean isValid() {
        return !this.builds.isEmpty() || !this.versions.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventGroupFilterRules condition = (EventGroupFilterRules)o;
        return Objects.equals(this.builds, condition.builds) && Objects.equals(this.versions, condition.versions);
    }

    public int hashCode() {
        return Objects.hash(this.builds, this.versions);
    }

    public static class VersionRange {
        private final int myFrom;
        private final int myTo;

        public VersionRange(int from, int to) {
            this.myFrom = from;
            this.myTo = to;
        }

        @NotNull
        public static VersionRange create(@Nullable String from, @Nullable String to) {
            return new VersionRange(from == null ? 0 : VersionRange.tryToParse(from, Integer.MAX_VALUE), to == null ? Integer.MAX_VALUE : VersionRange.tryToParse(to, 0));
        }

        private static int tryToParse(@Nullable String value, int defaultValue) {
            try {
                if (value != null) {
                    return Integer.parseInt(value.trim());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return defaultValue;
        }

        public boolean contains(int current) {
            return current >= this.myFrom && current < this.myTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionRange range = (VersionRange)o;
            return this.myFrom == range.myFrom && this.myTo == range.myTo;
        }

        public int hashCode() {
            return Objects.hash(this.myFrom, this.myTo);
        }
    }

    public static class BuildRange<T extends Comparable<T>> {
        private final T myFrom;
        private final T myTo;

        public BuildRange(@Nullable T from, @Nullable T to) {
            this.myFrom = from;
            this.myTo = to;
        }

        @NotNull
        public static <P extends Comparable<P>> BuildRange<P> create(@Nullable String from, @Nullable String to, EventLogBuildParser<P> buildProducer) {
            return new BuildRange<Object>((!StringUtil.isEmpty(from) ? (Object)buildProducer.parse(from) : null), (!StringUtil.isEmpty(to) ? (Object)buildProducer.parse(to) : null));
        }

        public boolean contains(@NotNull T build) {
            if (this.myTo == null && this.myFrom == null) {
                return false;
            }
            return !(this.myTo != null && this.myTo.compareTo(build) <= 0 || this.myFrom != null && this.myFrom.compareTo(build) > 0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuildRange range = (BuildRange)o;
            return Objects.equals(this.myFrom, range.myFrom) && Objects.equals(this.myTo, range.myTo);
        }

        public int hashCode() {
            return Objects.hash(this.myFrom, this.myTo);
        }
    }
}

