/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class StatisticsEventEscaper {
    private static final String SYMBOLS_TO_REPLACE = ":;, ";
    private static final String SYMBOLS_TO_REPLACE_FIELD_NAME = ".:;, ";

    @NotNull
    public static String escapeEventIdOrFieldValue(@NotNull String str) {
        return StatisticsEventEscaper.escapeInternal(str, null, true);
    }

    @NotNull
    public static String escape(@NotNull String str) {
        return StatisticsEventEscaper.escapeInternal(str, SYMBOLS_TO_REPLACE, false);
    }

    @NotNull
    public static String escapeFieldName(@NotNull String str) {
        if (Arrays.stream(ValidationResultType.values()).anyMatch(value -> str.equals(value.getDescription()))) {
            return str;
        }
        return StatisticsEventEscaper.escapeInternal(str, SYMBOLS_TO_REPLACE_FIELD_NAME, false);
    }

    @Nullable
    public static String cleanupForLegacyRulesIfNeeded(@NotNull String str) {
        if (StatisticsEventEscaper.containsSystemSymbols(str, SYMBOLS_TO_REPLACE)) {
            return StatisticsEventEscaper.replace(str, SYMBOLS_TO_REPLACE, false);
        }
        return null;
    }

    @NotNull
    private static String escapeInternal(@NotNull String str, @Nullable String toReplace, boolean allowSpaces) {
        if (StatisticsEventEscaper.containsSystemSymbols(str, toReplace)) {
            return StatisticsEventEscaper.replace(str, toReplace, allowSpaces);
        }
        return str;
    }

    @NotNull
    private static String replace(@NotNull String value, @Nullable String toReplace, boolean allowSpaces) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!StatisticsEventEscaper.isAscii(c)) {
                out.append("?");
                continue;
            }
            if (StatisticsEventEscaper.isWhiteSpaceToReplace(c)) {
                out.append(allowSpaces ? " " : "_");
                continue;
            }
            if (StatisticsEventEscaper.isSymbolToReplace(c, toReplace)) {
                out.append("_");
                continue;
            }
            if (StatisticsEventEscaper.isProhibitedSymbol(c)) continue;
            out.append(c);
        }
        return out.toString();
    }

    private static boolean containsSystemSymbols(@NotNull String value, @Nullable String toReplace) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!StatisticsEventEscaper.isAscii(c)) {
                return true;
            }
            if (StatisticsEventEscaper.isWhiteSpaceToReplace(c)) {
                return true;
            }
            if (StatisticsEventEscaper.isSymbolToReplace(c, toReplace)) {
                return true;
            }
            if (!StatisticsEventEscaper.isProhibitedSymbol(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAscii(char c) {
        return c <= '\u007f';
    }

    private static boolean isSymbolToReplace(char c, @Nullable String toReplace) {
        if (toReplace != null && StatisticsEventEscaper.containsChar(toReplace, c)) {
            return true;
        }
        return StatisticsEventEscaper.isAsciiControl(c);
    }

    public static boolean isWhiteSpaceToReplace(char c) {
        return c == '\n' || c == '\r' || c == '\t';
    }

    private static boolean isAsciiControl(char c) {
        return c < ' ' || c == '\u007f';
    }

    private static boolean isProhibitedSymbol(char c) {
        return c == '\'' || c == '\"';
    }

    private static boolean containsChar(@NotNull String str, char c) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            return true;
        }
        return false;
    }
}

