/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.ui;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.SpecificationType;
import com.intellij.swagger.SwDownloadableFileType;
import com.intellij.swagger.SwaggerUtilsKt;
import com.intellij.swagger.model.api.SwDefinition;
import com.intellij.swagger.model.specification.SwSpecificationFile;
import com.intellij.swagger.model.specification.SwaggerFileHelper;
import com.intellij.swagger.npm.SwNpmDownloadManager;
import com.intellij.swagger.ui.SpecificationReferencesInlineHelper;
import com.intellij.swagger.ui.SwaggerUIPage;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.StartupUiUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0002J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0017J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\n\u0010\u001e\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/swagger/ui/SwaggerUIManager;", "", "()V", "BUNDLED_SWAGGER_UI", "", "SWAGGER_CALL_GROUP_INDEX", "", "SWAGGER_CALL_REGION_REGEX", "Lkotlin/text/Regex;", "addCssStyles", "htmlContent", "addJsonSpecificationPathParameter", "indexHtml", "Lcom/intellij/openapi/vfs/VirtualFile;", "jsonToInline", "assembleHtmlPage", "finalSpecificationText", "computeEffectiveHtmlUrl", "effectiveHtmlText", "downloadLatestSourcesOrUseBundled", "prepareRawSwaggerUIHtml", "prepareSpecificationText", "psiFile", "Lcom/intellij/psi/PsiFile;", "prepareSpecificationText$intellij_swagger", "prepareUIWebPageSources", "Lcom/intellij/swagger/ui/SwaggerUIPage;", "specification", "readDataFromSpecification", "Lcom/intellij/swagger/ui/SwaggerUIManager$SpecificationData;", "unpackBundledResourcesIfNeeded", "writeFileToTheDisk", "", "content", "file", "Ljava/io/File;", "SpecificationData", "intellij.swagger"})
public final class SwaggerUIManager {
    private static final String BUNDLED_SWAGGER_UI = "META-INF/resources/webjars/swagger-ui";
    private static final int SWAGGER_CALL_GROUP_INDEX = 1;
    private static final Regex SWAGGER_CALL_REGION_REGEX;
    @NotNull
    public static final SwaggerUIManager INSTANCE;

    @Nullable
    public final SwaggerUIPage prepareUIWebPageSources(@NotNull PsiFile specification) {
        Intrinsics.checkNotNullParameter((Object)specification, (String)"specification");
        String string = this.prepareSpecificationText$intellij_swagger(specification);
        if (string == null) {
            return null;
        }
        String finalSpecificationText = string;
        VirtualFile virtualFile2 = this.prepareRawSwaggerUIHtml();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile indexHtml = virtualFile2;
        String string2 = this.assembleHtmlPage(indexHtml, finalSpecificationText);
        if (string2 == null) {
            return null;
        }
        String effectiveHtmlText = string2;
        String string3 = this.computeEffectiveHtmlUrl(indexHtml, effectiveHtmlText);
        if (string3 == null) {
            return null;
        }
        String effectiveHtmlUrl = string3;
        return new SwaggerUIPage(effectiveHtmlText, effectiveHtmlUrl);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String prepareSpecificationText$intellij_swagger(@NotNull PsiFile psiFile2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        ProgressManager.checkCanceled();
        SpecificationData specificationData = (SpecificationData)ReadAction.nonBlocking((Callable)new Callable<SpecificationData>(psiFile2){
            final /* synthetic */ PsiFile $psiFile;

            @Nullable
            public final SpecificationData call() {
                return SwaggerUIManager.access$readDataFromSpecification(SwaggerUIManager.INSTANCE, this.$psiFile);
            }
            {
                this.$psiFile = psiFile2;
            }
        }).withDocumentsCommitted(psiFile2.getProject()).executeSynchronously();
        if (specificationData == null) {
            return null;
        }
        SpecificationData specificationData2 = specificationData;
        SpecificationType specificationType = specificationData2.component1();
        Collection<String> collection = specificationData2.component2();
        String specificationText = specificationData2.component3();
        SpecificationReferencesInlineHelper jsonHelper = new SpecificationReferencesInlineHelper(0, 1, null);
        VirtualFile virtualFile2 = psiFile2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"psiFile.virtualFile");
        String specificationTextJson = jsonHelper.convertToJsonIfNeeded$intellij_swagger(specificationText, virtualFile2);
        if (specificationTextJson == null) {
            Logger.getInstance(SwaggerUIManager.class).warn("Unable to convert specification to json format");
            return null;
        }
        try {
            void ownDefinitionNames;
            void specificationType2;
            VirtualFile virtualFile3 = psiFile2.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"psiFile.virtualFile");
            string = jsonHelper.inlineExternalDefinitions$intellij_swagger(specificationTextJson, (SpecificationType)specificationType2, virtualFile3, (Collection<String>)ownDefinitionNames);
        }
        catch (IOException exception) {
            Logger.getInstance(SwaggerUIManager.class).warn("Unable to inline external object definitions. Using raw specification.", (Throwable)exception);
            string = specificationTextJson;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final SpecificationData readDataFromSpecification(PsiFile psiFile2) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SwSpecificationFile specificationModel = SwaggerFileHelper.INSTANCE.getSpecificationFileFor(psiFile2.getVirtualFile(), psiFile2.getProject(), false, false);
        if (specificationModel == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(SwaggerUIManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn("Unable to build specification model for file " + psiFile2.getName());
            return null;
        }
        Iterable $i$f$logger = specificationModel.getAllLocalObjectDefinitions();
        SpecificationType specificationType = specificationModel.getSpecificationType();
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwDefinition swDefinition = (SwDefinition)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName().getValue();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        Collection collection2 = collection;
        String string = psiFile2.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"psiFile.text");
        String string2 = string;
        Collection collection3 = collection2;
        SpecificationType specificationType2 = specificationType;
        return new SpecificationData(specificationType2, collection3, string2);
    }

    private final VirtualFile prepareRawSwaggerUIHtml() {
        VirtualFile virtualFile2;
        VirtualFile indexHtml;
        VirtualFile virtualFile3;
        ProgressManager.checkCanceled();
        VirtualFile virtualFile4 = this.downloadLatestSourcesOrUseBundled();
        if (virtualFile4 != null && (virtualFile4 = virtualFile4.findChild("index.html")) != null) {
            VirtualFile virtualFile5 = virtualFile4;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile5;
            boolean bl3 = false;
            it.refresh(false, false);
            virtualFile3 = virtualFile5;
        } else {
            virtualFile3 = indexHtml = null;
        }
        if (indexHtml == null) {
            Logger.getInstance(SwaggerUIManager.class).warn("Unable to find index.html page");
            virtualFile2 = null;
        } else {
            virtualFile2 = indexHtml;
        }
        return virtualFile2;
    }

    private final String assembleHtmlPage(VirtualFile indexHtml, String finalSpecificationText) {
        ProgressManager.checkCanceled();
        String specificationSwaggerUi = this.addJsonSpecificationPathParameter(indexHtml, finalSpecificationText);
        if (specificationSwaggerUi == null) {
            Logger.getInstance(SwaggerUIManager.class).warn("Unable to inline specification text into html page");
            return null;
        }
        return this.addCssStyles(specificationSwaggerUi);
    }

    private final String computeEffectiveHtmlUrl(VirtualFile indexHtml, String effectiveHtmlText) {
        Object object;
        ProgressManager.checkCanceled();
        if (SystemInfo.isWindows) {
            Object object2;
            try {
                object2 = indexHtml.getParent().toNioPath().resolve(effectiveHtmlText.hashCode() + "_index.html");
                boolean bl = false;
                boolean bl2 = false;
                Path path = object2;
                boolean bl3 = false;
                Path path2 = path;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                if (!PathKt.exists((Path)path2)) {
                    Files.createFile(path, new FileAttribute[0]);
                }
                File file = path.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
                INSTANCE.writeFileToTheDisk(effectiveHtmlText, file);
                VirtualFile virtualFile2 = VfsUtil.findFile((Path)path, (boolean)true);
                object2 = virtualFile2 != null ? virtualFile2.getUrl() : null;
            }
            catch (IOException ex) {
                Logger.getInstance(SwaggerUIManager.class).info("Unable to write effective main html page of Swagger UI", (Throwable)ex);
                return null;
            }
            object = object2;
        } else {
            object = indexHtml.getUrl();
        }
        String effectiveHtmlUrl = object;
        Logger.getInstance(SwaggerUIManager.class).info("Swagger UI Path is: " + effectiveHtmlUrl);
        return effectiveHtmlUrl;
    }

    private final void writeFileToTheDisk(String content, File file) {
        FileUtil.writeToFile((File)file, (String)content, (boolean)false);
    }

    private final VirtualFile downloadLatestSourcesOrUseBundled() {
        VirtualFile virtualFile2 = SwNpmDownloadManager.INSTANCE.downloadOrGetCachedLibrary("swagger-ui-dist");
        if (virtualFile2 == null || (virtualFile2 = virtualFile2.findChild("package")) == null) {
            virtualFile2 = this.unpackBundledResourcesIfNeeded();
        }
        return virtualFile2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final VirtualFile unpackBundledResourcesIfNeeded() {
        VirtualFile[] virtualFileArray;
        try {
            boolean bl;
            Path npmLibrariesPath = SwNpmDownloadManager.INSTANCE.getLibraryPath(SwDownloadableFileType.NPM_LIBRARY.name());
            Path targetDirectory = Files.createDirectories(npmLibrariesPath, new FileAttribute[0]).resolve("swagger-ui-dist").resolve("package");
            VirtualFile[] virtualFileArray2 = SwaggerUtilsKt.getBundledResource(BUNDLED_SWAGGER_UI);
            if (virtualFileArray2 != null && (virtualFileArray2 = virtualFileArray2.getChildren()) != null && (virtualFileArray2 = (VirtualFile[])ArraysKt.firstOrNull((Object[])virtualFileArray2)) != null && (virtualFileArray2 = virtualFileArray2.getChildren()) != null) {
                VirtualFile[] $this$forEach$iv = virtualFileArray2;
                boolean $i$f$forEach = false;
                VirtualFile[] virtualFileArray3 = $this$forEach$iv;
                int n = virtualFileArray3.length;
                for (int i = 0; i < n; ++i) {
                    Path path;
                    VirtualFile element$iv;
                    VirtualFile virtualFile2 = element$iv = virtualFileArray3[i];
                    boolean bl2 = false;
                    VirtualFile virtualFile3 = virtualFile2;
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"virtualFile");
                    Path path2 = path = targetDirectory.resolve(virtualFile3.getName());
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path");
                    if (PathKt.exists((Path)path2)) continue;
                    PathKt.createFile((Path)path);
                    Closeable closeable = virtualFile2.getInputStream();
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Throwable throwable = null;
                    try {
                        InputStream inputStream = (InputStream)closeable;
                        boolean bl5 = false;
                        long l = Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
            }
            VirtualFile[] virtualFileArray4 = VfsUtil.findFile((Path)targetDirectory, (boolean)true);
            boolean bl6 = false;
            boolean bl7 = false;
            VirtualFile[] it = virtualFileArray4;
            boolean bl8 = false;
            VirtualFile[] virtualFileArray5 = it;
            if (it != null && (virtualFileArray5 = virtualFileArray5.getChildren()) != null) {
                VirtualFile[] virtualFileArray6 = virtualFileArray5;
                boolean bl9 = false;
                VirtualFile[] virtualFileArray7 = virtualFileArray6;
                boolean bl10 = false;
                bl = !(virtualFileArray7.length == 0);
            } else {
                bl = false;
            }
            virtualFileArray = bl ? virtualFileArray4 : null;
        }
        catch (IOException ex) {
            Logger.getInstance(SwaggerUIManager.class).warn("Unable to load bundled Swagger UI page sources", (Throwable)ex);
            virtualFileArray = null;
        }
        return virtualFileArray;
    }

    private final String addJsonSpecificationPathParameter(VirtualFile indexHtml, String jsonToInline) {
        String rawHtml = ((Object)LoadTextUtil.loadText((VirtualFile)indexHtml)).toString();
        String swaggerUiCall = StringsKt.trimIndent((String)("\n      \n      const ui = SwaggerUIBundle({\n        spec: " + jsonToInline + ",\n        dom_id: '#swagger-ui',\n        deepLinking: true,\n        presets: [\n          SwaggerUIBundle.presets.apis,\n          SwaggerUIStandalonePreset\n        ],\n        layout: \"StandaloneLayout\"\n      })\n      \n    "));
        MatchResult matchResult = Regex.find$default((Regex)SWAGGER_CALL_REGION_REGEX, (CharSequence)rawHtml, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null || (matchResult = matchResult.get(1)) == null || (matchResult = matchResult.getRange()) == null) {
            return null;
        }
        MatchResult range = matchResult;
        String string = rawHtml;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.replaceRange((CharSequence)string2, (IntRange)range, (CharSequence)swaggerUiCall)).toString();
    }

    private final String addCssStyles(String htmlContent) {
        String css = ".topbar {display: none;}\n.information-container .info {margin: 25px 0;}\n.swagger-ui .download-contents {display: none;}\n.swagger-ui input[type=file] {pointer-events: none;}\ninput[type=text] {outline: 0;}\n/* scrollbar styles */\n::-webkit-scrollbar {width: 6px; height: 6px;}\n::-webkit-scrollbar-thumb {-webkit-border-radius: 10px;}\n::-webkit-scrollbar-track:vertical {-webkit-box-shadow: -1px 0 0 #ededed;}\n::-webkit-scrollbar-track {background-color: transparent;}\n::-webkit-scrollbar {width: 6px;}\n::-webkit-scrollbar-thumb {background-color: rgba(115, 115, 115, 0.2);}";
        if (StartupUiUtil.isUnderDarcula()) {
            css = css + "\n" + "::-webkit-scrollbar-thumb { background-color: rgba(166, 166, 166, 0.27); }";
            StringBuilder stringBuilder = new StringBuilder().append(css).append("\n");
            URL uRL = this.getClass().getResource("/css/swagger-ui-dark.css");
            Intrinsics.checkNotNull((Object)uRL);
            URL uRL2 = uRL;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
            boolean bl2 = false;
            boolean bl3 = false;
            css = stringBuilder.append(new String(byArray, charset)).toString();
        }
        return htmlContent + StringsKt.trimIndent((String)("\n      <style type=\"text/css\">\n      " + css + "\n      </style>\n    "));
    }

    private SwaggerUIManager() {
    }

    static {
        SwaggerUIManager swaggerUIManager;
        INSTANCE = swaggerUIManager = new SwaggerUIManager();
        String string = "// Begin Swagger UI call region([\\w\\W]*)// End Swagger UI call region";
        boolean bl = false;
        SWAGGER_CALL_REGION_REGEX = new Regex(string);
    }

    public static final /* synthetic */ SpecificationData access$readDataFromSpecification(SwaggerUIManager $this, PsiFile psiFile2) {
        return $this.readDataFromSpecification(psiFile2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/intellij/swagger/ui/SwaggerUIManager$SpecificationData;", "", "specificationType", "Lcom/intellij/swagger/SpecificationType;", "ownDefinitionNames", "", "", "specificationText", "(Lcom/intellij/swagger/SpecificationType;Ljava/util/Collection;Ljava/lang/String;)V", "getOwnDefinitionNames", "()Ljava/util/Collection;", "getSpecificationText", "()Ljava/lang/String;", "getSpecificationType", "()Lcom/intellij/swagger/SpecificationType;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.swagger"})
    private static final class SpecificationData {
        @NotNull
        private final SpecificationType specificationType;
        @NotNull
        private final Collection<String> ownDefinitionNames;
        @NotNull
        private final String specificationText;

        @NotNull
        public final SpecificationType getSpecificationType() {
            return this.specificationType;
        }

        @NotNull
        public final Collection<String> getOwnDefinitionNames() {
            return this.ownDefinitionNames;
        }

        @NotNull
        public final String getSpecificationText() {
            return this.specificationText;
        }

        public SpecificationData(@NotNull SpecificationType specificationType, @NotNull Collection<String> ownDefinitionNames, @NotNull String specificationText) {
            Intrinsics.checkNotNullParameter((Object)((Object)specificationType), (String)"specificationType");
            Intrinsics.checkNotNullParameter(ownDefinitionNames, (String)"ownDefinitionNames");
            Intrinsics.checkNotNullParameter((Object)specificationText, (String)"specificationText");
            this.specificationType = specificationType;
            this.ownDefinitionNames = ownDefinitionNames;
            this.specificationText = specificationText;
        }

        @NotNull
        public final SpecificationType component1() {
            return this.specificationType;
        }

        @NotNull
        public final Collection<String> component2() {
            return this.ownDefinitionNames;
        }

        @NotNull
        public final String component3() {
            return this.specificationText;
        }

        @NotNull
        public final SpecificationData copy(@NotNull SpecificationType specificationType, @NotNull Collection<String> ownDefinitionNames, @NotNull String specificationText) {
            Intrinsics.checkNotNullParameter((Object)((Object)specificationType), (String)"specificationType");
            Intrinsics.checkNotNullParameter(ownDefinitionNames, (String)"ownDefinitionNames");
            Intrinsics.checkNotNullParameter((Object)specificationText, (String)"specificationText");
            return new SpecificationData(specificationType, ownDefinitionNames, specificationText);
        }

        public static /* synthetic */ SpecificationData copy$default(SpecificationData specificationData, SpecificationType specificationType, Collection collection, String string, int n, Object object) {
            if ((n & 1) != 0) {
                specificationType = specificationData.specificationType;
            }
            if ((n & 2) != 0) {
                collection = specificationData.ownDefinitionNames;
            }
            if ((n & 4) != 0) {
                string = specificationData.specificationText;
            }
            return specificationData.copy(specificationType, collection, string);
        }

        @NotNull
        public String toString() {
            return "SpecificationData(specificationType=" + (Object)((Object)this.specificationType) + ", ownDefinitionNames=" + this.ownDefinitionNames + ", specificationText=" + this.specificationText + ")";
        }

        public int hashCode() {
            SpecificationType specificationType = this.specificationType;
            Collection<String> collection = this.ownDefinitionNames;
            String string = this.specificationText;
            return ((specificationType != null ? ((Object)((Object)specificationType)).hashCode() : 0) * 31 + (collection != null ? ((Object)collection).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SpecificationData)) break block3;
                    SpecificationData specificationData = (SpecificationData)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.specificationType), (Object)((Object)specificationData.specificationType)) || !Intrinsics.areEqual(this.ownDefinitionNames, specificationData.ownDefinitionNames) || !Intrinsics.areEqual((Object)this.specificationText, (Object)specificationData.specificationText)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

