/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.traverser.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.swagger.model.api.SwLeafElement;
import com.intellij.swagger.model.specification.SwStringLeafElementKt;
import com.intellij.swagger.traverser.SpecificationTraverser;
import com.intellij.swagger.traverser.impl.YamlSpecificationTraverser;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016J\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016J\u0019\u0010\r\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016J\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/swagger/traverser/impl/YamlSpecificationTraverser;", "Lcom/intellij/swagger/traverser/SpecificationTraverser;", "()V", "getChildValueByKeyName", "Lcom/intellij/psi/PsiElement;", "node", "name", "", "getFullElementPath", "getNameOr", "Lcom/intellij/swagger/model/api/SwLeafElement;", "value", "getParent", "getTopLevelValueOf", "Lorg/jetbrains/yaml/psi/YAMLValue;", "Lorg/jetbrains/annotations/Nullable;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getValueIfKeyValue", "getValuesAsSequenceFrom", "Lkotlin/sequences/Sequence;", "intellij.swagger"})
public final class YamlSpecificationTraverser
extends SpecificationTraverser {
    @Override
    @Nullable
    public PsiElement getValueIfKeyValue(@Nullable PsiElement node) {
        YAMLKeyValue yAMLKeyValue;
        PsiElement psiElement = node;
        if (!(psiElement instanceof YAMLKeyValue)) {
            psiElement = null;
        }
        return (yAMLKeyValue = (YAMLKeyValue)psiElement) != null && (yAMLKeyValue = yAMLKeyValue.getValue()) != null ? (PsiElement)yAMLKeyValue : node;
    }

    @Override
    @Nullable
    public PsiElement getChildValueByKeyName(@Nullable PsiElement node, @NotNull String name2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        PsiElement psiElement2 = node;
        if (psiElement2 instanceof YAMLMapping) {
            Object v2;
            block3: {
                Collection collection = ((YAMLMapping)node).getKeyValues();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"node.keyValues");
                Iterable $this$firstOrNull$iv = collection;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    YAMLKeyValue it = (YAMLKeyValue)element$iv;
                    boolean bl = false;
                    YAMLKeyValue yAMLKeyValue = it;
                    Intrinsics.checkNotNullExpressionValue((Object)yAMLKeyValue, (String)"it");
                    if (!Intrinsics.areEqual((Object)yAMLKeyValue.getName(), (Object)name2)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            psiElement = v2;
        } else {
            psiElement = null;
        }
        return psiElement;
    }

    @Override
    @NotNull
    public Sequence<PsiElement> getValuesAsSequenceFrom(@Nullable PsiElement node) {
        Object object;
        PsiElement psiElement = node;
        if (psiElement instanceof YAMLMapping) {
            Collection collection = ((YAMLMapping)node).getKeyValues();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"node.keyValues");
            object = CollectionsKt.asSequence((Iterable)collection);
        } else if (psiElement instanceof YAMLSequence) {
            List list = ((YAMLSequence)node).getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"node.items");
            object = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)getValuesAsSequenceFrom.1.INSTANCE);
        } else {
            object = psiElement instanceof YAMLScalar ? SequencesKt.sequenceOf((Object[])new YAMLScalar[]{(YAMLScalar)node}) : (psiElement instanceof YAMLKeyValue ? this.getValuesAsSequenceFrom((PsiElement)((YAMLKeyValue)node).getValue()) : SequencesKt.emptySequence());
        }
        return object;
    }

    @Nullable
    public YAMLValue getTopLevelValueOf(@Nullable PsiFile psiFile2) {
        Object object;
        PsiFile psiFile3 = psiFile2;
        if (!(psiFile3 instanceof YAMLFile)) {
            psiFile3 = null;
        }
        return (object = (YAMLFile)psiFile3) != null && (object = object.getDocuments()) != null && (object = (YAMLDocument)CollectionsKt.firstOrNull((List)object)) != null ? object.getTopLevelValue() : null;
    }

    @Override
    @NotNull
    public SwLeafElement<String> getNameOr(@Nullable PsiElement node, @Nullable String value) {
        SwLeafElement swLeafElement;
        PsiElement psiElement = node;
        if (psiElement instanceof YAMLScalar) {
            String string = ((YAMLScalar)node).getTextValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.textValue");
            swLeafElement = SwStringLeafElementKt.wrapToLeafElement(string, node);
        } else {
            swLeafElement = super.getNameOr(node, value);
        }
        return swLeafElement;
    }

    @Override
    @Nullable
    public String getFullElementPath(@Nullable PsiElement node) {
        if (!(node instanceof YAMLPsiElement)) {
            return null;
        }
        String string = YAMLUtil.getConfigFullName((YAMLPsiElement)((YAMLPsiElement)node));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"YAMLUtil.getConfigFullName(node)");
        CharSequence charSequence = string;
        String string2 = "\\[.*]";
        boolean bl = false;
        string2 = new Regex(string2);
        String string3 = "";
        boolean bl2 = false;
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)string2.replace(charSequence, string3), (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @Nullable
    public PsiElement getParent(@Nullable PsiElement node) {
        PsiElement psiElement = node;
        return psiElement != null && (psiElement = PsiTreeUtilKt.parents((PsiElement)psiElement, (boolean)false)) != null && (psiElement = SequencesKt.filterNot((Sequence)psiElement, (Function1)getParent.1.INSTANCE)) != null ? (PsiElement)SequencesKt.firstOrNull((Sequence)psiElement) : null;
    }
}

