/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.synthetic;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.intellij.microservices.oas.OasEndpointPath;
import com.intellij.microservices.oas.OasOperation;
import com.intellij.microservices.oas.OasParameter;
import com.intellij.microservices.oas.OasResponse;
import com.intellij.microservices.oas.OasSchema;
import com.intellij.microservices.oas.OasSchemaFormat;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0007\u001a\u0016\u0010\u000f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0007\u00a8\u0006\u0011"}, d2={"appendOperationToJson", "", "pathNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "operation", "Lcom/intellij/microservices/oas/OasOperation;", "appendPathToJson", "root", "model", "Lcom/intellij/microservices/oas/OasEndpointPath;", "generateOasDraft", "", "projectName", "models", "", "generateOasPreview", "", "intellij.swagger"})
public final class OasSerializationUtilsKt {
    /*
     * WARNING - void declaration
     */
    @ApiStatus.Experimental
    @NlsSafe
    @NotNull
    public static final String generateOasPreview(@NotNull List<OasEndpointPath> models2) {
        Intrinsics.checkNotNullParameter(models2, (String)"models");
        YAMLFactory factory = new YAMLFactory().configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
        StringWriter writer = new StringWriter();
        ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
        Iterable $this$forEachIndexed$iv = models2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void model;
            ObjectNode root;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OasEndpointPath oasEndpointPath = (OasEndpointPath)item$iv;
            int index = n;
            boolean bl2 = false;
            if (index != 0) {
                writer.getBuffer().append("\n---\n");
            }
            YAMLGenerator generator = factory.createGenerator((Writer)writer);
            ObjectNode objectNode = root = mapper.createObjectNode();
            Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"root");
            OasSerializationUtilsKt.appendPathToJson(objectNode, (OasEndpointPath)model);
            mapper.writeTree((JsonGenerator)generator, (JsonNode)root);
        }
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
        String document = string;
        StringBuilder paddingBuilder = new StringBuilder();
        for (String s : StringsKt.split$default((CharSequence)document, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null)) {
            if (Intrinsics.areEqual((Object)s, (Object)"---")) {
                paddingBuilder.append(s);
            } else {
                paddingBuilder.append("  ").append(s);
            }
            paddingBuilder.append("\n");
        }
        String string2 = paddingBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"paddingBuilder.toString()");
        String string3 = string2;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trimEnd((CharSequence)string4)).toString();
    }

    @ApiStatus.Experimental
    @NlsSafe
    @NotNull
    public static final String generateOasDraft(@NotNull String projectName, @NotNull Collection<OasEndpointPath> models2) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter(models2, (String)"models");
        YAMLFactory factory = new YAMLFactory().configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
        ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
        ObjectNode root = mapper.createObjectNode();
        root.put("openapi", "3.0.3");
        ObjectNode objectNode = root.putObject("info");
        boolean bl = false;
        boolean bl2 = false;
        ObjectNode $this$apply = objectNode;
        boolean bl3 = false;
        $this$apply.put("title", projectName + " API");
        $this$apply.put("description", projectName + " API");
        $this$apply.put("version", "1.0.0");
        objectNode = root.putArray("servers");
        bl = false;
        bl2 = false;
        $this$apply = objectNode;
        boolean bl4 = false;
        $this$apply.addObject().put("url", "https://" + FileUtil.sanitizeFileName((String)projectName));
        ObjectNode pathsNode = root.putObject("paths");
        for (OasEndpointPath model : models2) {
            ObjectNode objectNode2 = pathsNode;
            Intrinsics.checkNotNullExpressionValue((Object)objectNode2, (String)"pathsNode");
            OasSerializationUtilsKt.appendPathToJson(objectNode2, model);
        }
        StringWriter writer = new StringWriter();
        YAMLGenerator generator = factory.createGenerator((Writer)writer);
        mapper.writeTree((JsonGenerator)generator, (JsonNode)root);
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writer.toString()");
        return string;
    }

    private static final void appendPathToJson(ObjectNode root, OasEndpointPath model) {
        String path = StringsKt.startsWith$default((String)model.getPath(), (String)"/", (boolean)false, (int)2, null) ? model.getPath() : '/' + model.getPath();
        ObjectNode pathNode = root.putObject(path);
        if (model.getSummary() != null) {
            pathNode.put("summary", model.getSummary());
        }
        for (OasOperation operation : model.getOperations()) {
            ObjectNode objectNode = pathNode;
            Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"pathNode");
            OasSerializationUtilsKt.appendOperationToJson(objectNode, operation);
        }
    }

    private static final void appendOperationToJson(ObjectNode pathNode, OasOperation operation) {
        Collection parametersNode;
        ObjectNode methodNode = pathNode.putObject(operation.getMethod().getMethodName());
        if (operation.getSummary() != null) {
            methodNode.put("summary", operation.getSummary());
        }
        if (operation.getDescription() != null) {
            methodNode.put("description", operation.getDescription());
        }
        if (operation.isDeprecated()) {
            methodNode.put("deprecated", true);
        }
        if (operation.getOperationId() != null) {
            methodNode.put("operationId", operation.getOperationId());
        }
        Collection collection = operation.getParameters();
        boolean bl = false;
        if (!collection.isEmpty()) {
            parametersNode = methodNode.putArray("parameters");
            for (OasParameter parameter : operation.getParameters()) {
                OasSchema schema2;
                ObjectNode parameterNode = parametersNode.addObject();
                parameterNode.put("name", parameter.getName());
                parameterNode.put("in", parameter.getInPlace().getPlaceName());
                if (parameter.isDeprecated()) {
                    parameterNode.put("deprecated", true);
                }
                if (parameter.isRequired()) {
                    parameterNode.put("required", true);
                }
                if ((schema2 = parameter.getSchema()) == null) continue;
                ObjectNode schemaObject = parameterNode.putObject("schema");
                schemaObject.put("type", schema2.getType().getTypeName());
                if (schema2.getFormat() != null) {
                    OasSchemaFormat oasSchemaFormat;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    OasSchemaFormat it = oasSchemaFormat;
                    boolean bl4 = false;
                    schemaObject.put("format", it.getFormatName());
                }
            }
        }
        parametersNode = operation.getResponses();
        boolean parameter = false;
        if (!parametersNode.isEmpty()) {
            ObjectNode responsesNode = methodNode.putObject("responses");
            for (OasResponse response : operation.getResponses()) {
                ObjectNode objectNode = responsesNode.putObject(response.getCode());
                String string = response.getDescription();
                if (string == null) {
                    string = "";
                }
                objectNode.put("description", string);
            }
        }
    }
}

