/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.remote;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.SwaggerUtilsKt;
import com.intellij.swagger.model.api.SwAuthority;
import com.intellij.swagger.model.api.SwModelElement;
import com.intellij.swagger.model.api.SwSchema;
import com.intellij.swagger.model.remote.RemoteSpecificationFile;
import com.intellij.swagger.model.remote.openapi.v3.Openapi3RemoteServer;
import com.intellij.swagger.model.remote.openapi.v3.Openapi3RemoteSpecificationFile;
import com.intellij.swagger.model.remote.swagger.v2.Swagger2RemoteSpecificationFile;
import com.intellij.util.Url;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\u000b\u001a\u00020\f*\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\u000f\u001a\u00020\f*\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\u0010\u001a\u00020\f*\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/swagger/remote/RemoteSpecificationEnricher;", "", "()V", "enrichSchemaAndHost", "", "specification", "Lcom/intellij/swagger/model/remote/swagger/v2/Swagger2RemoteSpecificationFile;", "url", "Lcom/intellij/util/Url;", "enrichServerObjects", "Lcom/intellij/swagger/model/remote/openapi/v3/Openapi3RemoteSpecificationFile;", "reformatAndWriteToTheDisk", "Lcom/intellij/swagger/model/remote/RemoteSpecificationFile;", "factory", "Lcom/fasterxml/jackson/core/JsonFactory;", "withExternalUrl", "withVirtualFile", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.swagger"})
public final class RemoteSpecificationEnricher {
    @NotNull
    public static final RemoteSpecificationEnricher INSTANCE;

    @NotNull
    public final RemoteSpecificationFile withExternalUrl(@NotNull RemoteSpecificationFile $this$withExternalUrl, @NotNull Url url2) {
        Intrinsics.checkNotNullParameter((Object)$this$withExternalUrl, (String)"$this$withExternalUrl");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        RemoteSpecificationFile remoteSpecificationFile = $this$withExternalUrl;
        boolean bl = false;
        boolean bl2 = false;
        RemoteSpecificationFile it = remoteSpecificationFile;
        boolean bl3 = false;
        RemoteSpecificationFile remoteSpecificationFile2 = $this$withExternalUrl;
        if (remoteSpecificationFile2 instanceof Openapi3RemoteSpecificationFile) {
            INSTANCE.enrichServerObjects((Openapi3RemoteSpecificationFile)$this$withExternalUrl, url2);
        } else if (remoteSpecificationFile2 instanceof Swagger2RemoteSpecificationFile) {
            INSTANCE.enrichSchemaAndHost((Swagger2RemoteSpecificationFile)$this$withExternalUrl, url2);
        } else {
            Logger.getInstance(RemoteSpecificationEnricher.class).warn("Unknown specification type received, nothing to enrich: " + $this$withExternalUrl.getClass());
        }
        return remoteSpecificationFile;
    }

    @NotNull
    public final RemoteSpecificationFile withVirtualFile(@NotNull RemoteSpecificationFile $this$withVirtualFile, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)$this$withVirtualFile, (String)"$this$withVirtualFile");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        RemoteSpecificationFile remoteSpecificationFile = $this$withVirtualFile;
        boolean bl = false;
        boolean bl2 = false;
        RemoteSpecificationFile it = remoteSpecificationFile;
        boolean bl3 = false;
        $this$withVirtualFile.setVirtualFile(virtualFile2);
        return remoteSpecificationFile;
    }

    @NotNull
    public final RemoteSpecificationFile reformatAndWriteToTheDisk(@NotNull RemoteSpecificationFile $this$reformatAndWriteToTheDisk, @Nullable JsonFactory factory) {
        Intrinsics.checkNotNullParameter((Object)$this$reformatAndWriteToTheDisk, (String)"$this$reformatAndWriteToTheDisk");
        RemoteSpecificationFile remoteSpecificationFile = $this$reformatAndWriteToTheDisk;
        boolean bl = false;
        boolean bl2 = false;
        RemoteSpecificationFile it = remoteSpecificationFile;
        boolean bl3 = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) {
            File specificationFile;
            Object object = it.getVirtualFile();
            File file = object != null && (object = object.toNioPath()) != null ? object.toFile() : (specificationFile = null);
            if (factory != null && specificationFile != null) {
                try {
                    ObjectMapper objectMapper = new ObjectMapper(factory);
                    JsonNode rootSpecificationNode = objectMapper.readTree(specificationFile);
                    String reformattedSpecification = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootSpecificationNode);
                    FileUtil.writeToFile((File)specificationFile, (String)reformattedSpecification);
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (File[])new File[]{specificationFile});
                }
                catch (JsonProcessingException ex) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(RemoteSpecificationEnricher.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.warn("Unable to reformat downloaded specification. Raw specification text will be used", (Throwable)ex);
                }
                catch (IOException ex) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(RemoteSpecificationEnricher.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.warn("Unable to write reformatted specification text to the disk. Raw specification text will be used", (Throwable)ex);
                }
            }
        }
        return remoteSpecificationFile;
    }

    private final void enrichServerObjects(Openapi3RemoteSpecificationFile specification, Url url2) {
        String schemeAndAuthority = url2.getScheme() + "://" + url2.getAuthority() + '/';
        List list = specification.get_servers();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List existingServers = list;
        Collection collection = existingServers;
        boolean bl = false;
        if (!collection.isEmpty()) {
            Iterable $this$forEach$iv = existingServers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Openapi3RemoteServer it = (Openapi3RemoteServer)element$iv;
                boolean bl2 = false;
                if (it.getSchema() != null || it.getAuthority() != null) continue;
                String[] stringArray = new String[2];
                stringArray[0] = schemeAndAuthority;
                String string = it.get_url();
                boolean bl3 = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                stringArray[1] = string2;
                it.set_url(SwaggerUtilsKt.buildUrlFromSegments(stringArray));
            }
        } else {
            specification.set_servers(CollectionsKt.listOf((Object)new Openapi3RemoteServer(schemeAndAuthority)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void enrichSchemaAndHost(Swagger2RemoteSpecificationFile specification, Url url2) {
        boolean hasSchemaFromRemoteUrl;
        boolean bl;
        List<SwSchema> existingSchemes;
        block12: {
            block11: {
                if (specification.get_host() == null) break block11;
                SwModelElement swModelElement = specification.get_host();
                CharSequence charSequence = swModelElement != null && (swModelElement = ((SwAuthority)swModelElement).getAuthorityValue()) != null ? (String)swModelElement.getValue() : null;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!(charSequence == null || charSequence.length() == 0)) break block12;
            }
            specification.set_host(new SwAuthority(url2.getAuthority()));
        }
        List<SwSchema> list = existingSchemes = specification.get_schemes();
        if (list != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SwSchema swSchema = (SwSchema)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                String string = it.getSchemaValue().getValue();
                collection.add(string);
            }
            bl = CollectionsKt.contains((Iterable)((List)destination$iv$iv), (Object)url2.getScheme());
        } else {
            bl = hasSchemaFromRemoteUrl = false;
        }
        if (!hasSchemaFromRemoteUrl) {
            void $this$orEmpty$iv;
            SwSchema[] swSchemaArray;
            Collection $this$toTypedArray$iv;
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)new SwSchema(url2.getScheme()));
            List<SwSchema> list2 = existingSchemes;
            if (list2 != null) {
                $this$toTypedArray$iv = list2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                SwSchema[] swSchemaArray2 = thisCollection$iv.toArray(new SwSchema[0]);
                if (swSchemaArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                swSchemaArray = swSchemaArray2;
            } else {
                swSchemaArray = null;
            }
            $this$toTypedArray$iv = swSchemaArray;
            boolean $i$f$orEmpty = false;
            SwSchema[] swSchemaArray3 = $this$orEmpty$iv;
            if (swSchemaArray3 == null) {
                swSchemaArray3 = new SwSchema[]{};
            }
            spreadBuilder.addSpread((Object)swSchemaArray3);
            specification.set_schemes(CollectionsKt.listOfNotNull((Object[])((SwSchema[])spreadBuilder.toArray((Object[])new SwSchema[spreadBuilder.size()]))));
        }
    }

    private RemoteSpecificationEnricher() {
    }

    static {
        RemoteSpecificationEnricher remoteSpecificationEnricher;
        INSTANCE = remoteSpecificationEnricher = new RemoteSpecificationEnricher();
    }
}

