/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.reference.definitions.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.swagger.SwaggerBundle;
import com.intellij.swagger.model.SwaggerMergedModel;
import com.intellij.swagger.model.api.SwDefinition;
import com.intellij.swagger.model.api.SwModelBase;
import com.intellij.swagger.model.api.SwParameter;
import com.intellij.swagger.model.api.SwResponse;
import com.intellij.swagger.model.specification.SpecificationObjectDefinition;
import com.intellij.swagger.model.specification.SwSpecificationFile;
import com.intellij.swagger.model.specification.light.SwFakeMetaHolderKt;
import com.intellij.swagger.model.specification.openapi.v3.Openapi3Definition;
import com.intellij.swagger.reference.definitions.SwDefinitionCoordinatesParser;
import com.intellij.swagger.reference.definitions.SwObjectCoordinates;
import com.intellij.swagger.reference.definitions.SwObjectDefinitionReference;
import com.intellij.swagger.reference.definitions.SwObjectDefinitionReferenceKt;
import com.intellij.swagger.reference.definitions.completion.LocalFileCompletionProvider;
import com.intellij.swagger.reference.definitions.completion.LocalFileCompletionProvider$completeFileSystemItems$;
import com.intellij.util.ProcessingContext;
import icons.SwaggerIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J(\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u0012\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0007\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J \u0010#\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u001fH\u0002\u00a8\u0006&"}, d2={"Lcom/intellij/swagger/reference/definitions/completion/LocalFileCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "completeDefinitions", "element", "Lcom/intellij/psi/PsiElement;", "coordinates", "Lcom/intellij/swagger/reference/definitions/SwObjectCoordinates;", "caretOffsetInElement", "", "completeFileSystemItems", "computeReferenceRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/codeInsight/completion/InsertionContext;", "createDefinitionLookup", "Lcom/intellij/codeInsight/lookup/LookupElement;", "objectDefinition", "Lcom/intellij/swagger/model/api/SwDefinition;", "definitionCoordinates", "createFileSystemItemLookup", "fileSystemItem", "Lcom/intellij/psi/PsiFileSystemItem;", "completedPathSegment", "", "getDefinitionHint", "definition", "getFileSystemItemHint", "moveCaretToInsertedFragmentEnd", "referenceRange", "replacement", "intellij.swagger"})
final class LocalFileCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters2, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        PsiElement psiElement = parameters2.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"parameters.position");
        PsiFile psiFile2 = psiElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"parameters.position\n    \u2026          .containingFile");
        PsiElement psiElement2 = psiFile2.getOriginalFile().findElementAt(parameters2.getOffset());
        if (psiElement2 == null || (psiElement2 = psiElement2.getParent()) == null) {
            return;
        }
        PsiElement element = psiElement2;
        int caretOffsetInElement = parameters2.getOffset() - UtilsKt.getStartOffset((PsiElement)element);
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"ElementManipulators.getValueTextRange(element)");
        TextRange rangeInElement = textRange;
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        SwObjectCoordinates coordinates = SwDefinitionCoordinatesParser.INSTANCE.parseObjectCoordinates(string, rangeInElement);
        if (coordinates.isWebCoordinates()) {
            return;
        }
        if (coordinates.isEmpty()) {
            this.completeDefinitions(element, coordinates, caretOffsetInElement, result);
            this.completeFileSystemItems(element, coordinates, caretOffsetInElement, result);
        } else if (coordinates.isStorageEdited(caretOffsetInElement)) {
            this.completeFileSystemItems(element, coordinates, caretOffsetInElement, result);
        } else {
            this.completeDefinitions(element, coordinates, caretOffsetInElement, result);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void completeFileSystemItems(PsiElement element, SwObjectCoordinates coordinates, int caretOffsetInElement, CompletionResultSet result) {
        void $this$forEach$iv;
        Sequence $this$filterIsInstance$iv;
        Sequence $this$orEmpty$iv;
        void completeSegment;
        Pair<String, String> pair = coordinates.computeCompletedStorageUriSegment(caretOffsetInElement);
        if (pair == null) {
            return;
        }
        Pair<String, String> pair2 = pair;
        String string = (String)pair2.component1();
        String incompleteSegment = (String)pair2.component2();
        PsiFile psiFile2 = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"element.containingFile");
        PsiFile psiFile3 = psiFile2.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"element.containingFile.originalFile");
        VirtualFile virtualFile2 = SwObjectDefinitionReferenceKt.findByRelativePath(psiFile3, (String)completeSegment);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile directory = virtualFile2;
        PsiDirectory psiDirectory = PsiManager.getInstance((Project)element.getProject()).findDirectory(directory);
        PsiElement[] psiElementArray = psiDirectory != null ? psiDirectory.getChildren() : null;
        boolean $i$f$orEmpty = false;
        Sequence sequence = $this$orEmpty$iv;
        if (sequence == null) {
            sequence = new PsiElement[]{};
        }
        $this$orEmpty$iv = ArraysKt.asSequence((Object[])sequence);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)completeFileSystemItems$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        $this$filterIsInstance$iv = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)sequence2, (Function1)completeFileSystemItems.1.INSTANCE), (Function1)((Function1)new Function1<PsiFileSystemItem, LookupElement>(this, (String)completeSegment){
            final /* synthetic */ LocalFileCompletionProvider this$0;
            final /* synthetic */ String $completeSegment;

            @NotNull
            public final LookupElement invoke(@NotNull PsiFileSystemItem it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return LocalFileCompletionProvider.access$createFileSystemItemLookup(this.this$0, it, this.$completeSegment);
            }
            {
                this.this$0 = localFileCompletionProvider;
                this.$completeSegment = string;
                super(1);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LookupElement it = (LookupElement)element$iv;
            boolean bl = false;
            result.withPrefixMatcher(incompleteSegment).consume(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void completeDefinitions(PsiElement element, SwObjectCoordinates coordinates, int caretOffsetInElement, CompletionResultSet result) {
        Object object;
        String prefix;
        SwModelBase swModelBase;
        SwModelBase swModelBase2;
        PsiFile psiFile2 = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"element.containingFile");
        PsiFile psiFile3 = psiFile2.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"element.containingFile.originalFile");
        PsiFile originalFile = psiFile3;
        PsiFile externalFile = SwObjectDefinitionReferenceKt.findStorageFile(originalFile, coordinates.getUriValue());
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        SwaggerMergedModel swaggerMergedModel = SwaggerMergedModel.Companion.getInstance(project);
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)originalFile);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.fileScope(originalFile)");
        SwModelBase swModelBase3 = (SwModelBase)CollectionsKt.firstOrNull(swaggerMergedModel.getBaseModelElements(globalSearchScope));
        if (swModelBase3 != null) {
            Project project2 = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"element.project");
            swModelBase2 = swModelBase3.substitute(project2);
        } else {
            swModelBase2 = swModelBase = null;
        }
        if (!(swModelBase2 instanceof SwSpecificationFile)) {
            swModelBase = null;
        }
        SwSpecificationFile swSpecificationFile = (SwSpecificationFile)swModelBase;
        if (swSpecificationFile == null) {
            return;
        }
        SwSpecificationFile currentSpecification = swSpecificationFile;
        SwSpecificationFile specificationFile = externalFile == null ? currentSpecification : SwFakeMetaHolderKt.createFakeSecondarySpecification(currentSpecification, externalFile);
        Object object2 = coordinates.computeCompletedDefinitionSegment(caretOffsetInElement);
        boolean bl = false;
        Object object3 = object2;
        if (object3 == null) {
            object3 = prefix = "";
        }
        if ((object = specificationFile) != null && (object = ((SwSpecificationFile)object).getAllLocalObjectDefinitions()) != null) {
            Iterable $this$sortedBy$iv;
            object2 = (Iterable)object;
            boolean $i$f$sortedBy = false;
            boolean bl2 = false;
            object = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                public final int compare(T a, T b) {
                    boolean bl = false;
                    SwDefinition it = (SwDefinition)a;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)((Object)it.getName().getValue());
                    it = (SwDefinition)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    String string = it.getName().getValue();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                }
            });
            if (object != null) {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                $this$sortedBy$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SwDefinition swDefinition = (SwDefinition)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    LookupElement lookupElement = this.createDefinitionLookup((SwDefinition)it, coordinates);
                    collection.add(lookupElement);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LookupElement it = (LookupElement)element$iv;
                    boolean bl4 = false;
                    result.withPrefixMatcher(prefix).consume(it);
                }
            }
        }
    }

    private final LookupElement createDefinitionLookup(SwDefinition objectDefinition, SwObjectCoordinates definitionCoordinates) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)objectDefinition.getElementPath()).withPresentableText(objectDefinition.getName().getValue()).withTypeText(this.getDefinitionHint(objectDefinition)).withIcon(SwaggerIcons.Entity).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(this, definitionCoordinates){
            final /* synthetic */ LocalFileCompletionProvider this$0;
            final /* synthetic */ SwObjectCoordinates $definitionCoordinates;

            public final void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                TextRange textRange = LocalFileCompletionProvider.access$computeReferenceRange(this.this$0, context);
                if (textRange == null) {
                    return;
                }
                TextRange referenceRange = textRange;
                StringBuilder stringBuilder = new StringBuilder();
                String string = this.$definitionCoordinates.getUriValue();
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    string2 = "";
                }
                String replacement = stringBuilder.append(string2).append("#/").append(item.getLookupString()).toString();
                context.getDocument().replaceString(referenceRange.getStartOffset(), referenceRange.getEndOffset(), (CharSequence)replacement);
                LocalFileCompletionProvider.access$moveCaretToInsertedFragmentEnd(this.this$0, context, referenceRange, replacement);
            }
            {
                this.this$0 = localFileCompletionProvider;
                this.$definitionCoordinates = swObjectCoordinates;
            }
        });
        boolean bl = false;
        boolean bl2 = false;
        LookupElementBuilder it = lookupElementBuilder;
        boolean bl3 = false;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)it), (double)10.0);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"LookupElementBuilder.cre\u2026.withPriority(it, 10.0) }");
        return lookupElement;
    }

    private final String getDefinitionHint(SwDefinition definition) {
        SwDefinition swDefinition = definition;
        return swDefinition instanceof SpecificationObjectDefinition || swDefinition instanceof Openapi3Definition ? SwaggerBundle.message("object.definitions.swagger.v2.definition.hint", new Object[0]) : (swDefinition instanceof SwResponse ? SwaggerBundle.message("object.definitions.response.hint", new Object[0]) : (swDefinition instanceof SwParameter ? SwaggerBundle.message("object.definitions.parameter.hint", new Object[0]) : "Unknown"));
    }

    private final LookupElement createFileSystemItemLookup(PsiFileSystemItem fileSystemItem, String completedPathSegment) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)fileSystemItem.getName()).withIcon(fileSystemItem.getIcon(0)).withTypeText(this.getFileSystemItemHint(fileSystemItem)).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(this, completedPathSegment, fileSystemItem){
            final /* synthetic */ LocalFileCompletionProvider this$0;
            final /* synthetic */ String $completedPathSegment;
            final /* synthetic */ PsiFileSystemItem $fileSystemItem;

            public final void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                TextRange textRange = LocalFileCompletionProvider.access$computeReferenceRange(this.this$0, context);
                if (textRange == null) {
                    return;
                }
                TextRange referenceRange = textRange;
                String string = "/";
                boolean bl = false;
                boolean bl2 = false;
                String string2 = string;
                StringBuilder stringBuilder = new StringBuilder().append(this.$completedPathSegment).append('/').append(item.getLookupString());
                boolean bl3 = false;
                boolean bl4 = this.$fileSystemItem.isDirectory();
                string = bl4 ? string : null;
                bl = false;
                String string3 = string;
                if (string3 == null) {
                    string3 = "";
                }
                String replacement = stringBuilder.append(string3).toString();
                context.getDocument().replaceString(referenceRange.getStartOffset(), referenceRange.getEndOffset(), (CharSequence)replacement);
                LocalFileCompletionProvider.access$moveCaretToInsertedFragmentEnd(this.this$0, context, referenceRange, replacement);
            }
            {
                this.this$0 = localFileCompletionProvider;
                this.$completedPathSegment = string;
                this.$fileSystemItem = psiFileSystemItem;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"LookupElementBuilder.cre\u2026cement)\n        }\n      )");
        return (LookupElement)lookupElementBuilder;
    }

    private final String getFileSystemItemHint(PsiFileSystemItem fileSystemItem) {
        PsiFileSystemItem psiFileSystemItem = fileSystemItem;
        return psiFileSystemItem instanceof PsiFile ? SwaggerBundle.message("completion.file.hint", new Object[0]) : (psiFileSystemItem instanceof PsiDirectory ? SwaggerBundle.message("completion.directory.hint", new Object[0]) : "");
    }

    private final TextRange computeReferenceRange(InsertionContext context) {
        PsiReference $this$castSafelyTo$iv = context.getFile().findReferenceAt(context.getStartOffset());
        boolean $i$f$castSafelyTo = false;
        PsiReference psiReference = $this$castSafelyTo$iv;
        if (!(psiReference instanceof SwObjectDefinitionReference)) {
            psiReference = null;
        }
        SwObjectDefinitionReference swObjectDefinitionReference = (SwObjectDefinitionReference)psiReference;
        if (swObjectDefinitionReference == null) {
            return null;
        }
        SwObjectDefinitionReference definitionReference = swObjectDefinitionReference;
        TextRange textRange = definitionReference.getRangeInElement();
        PsiElement psiElement = definitionReference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"definitionReference.element");
        return textRange.shiftRight(UtilsKt.getStartOffset((PsiElement)psiElement));
    }

    private final void moveCaretToInsertedFragmentEnd(InsertionContext context, TextRange referenceRange, String replacement) {
        Editor editor = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"context.editor");
        editor.getCaretModel().moveToOffset(referenceRange.getStartOffset() + replacement.length());
    }

    public static final /* synthetic */ LookupElement access$createFileSystemItemLookup(LocalFileCompletionProvider $this, PsiFileSystemItem fileSystemItem, String completedPathSegment) {
        return $this.createFileSystemItemLookup(fileSystemItem, completedPathSegment);
    }

    public static final /* synthetic */ TextRange access$computeReferenceRange(LocalFileCompletionProvider $this, InsertionContext context) {
        return $this.computeReferenceRange(context);
    }

    public static final /* synthetic */ void access$moveCaretToInsertedFragmentEnd(LocalFileCompletionProvider $this, InsertionContext context, TextRange referenceRange, String replacement) {
        $this.moveCaretToInsertedFragmentEnd(context, referenceRange, replacement);
    }
}

