/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.reference.definitions;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.SyntheticElement;
import com.intellij.swagger.meta.SwElementProvider;
import com.intellij.swagger.model.SwObjectDefinitionUtilsKt;
import com.intellij.swagger.model.api.SwModelElement;
import com.intellij.swagger.model.specification.SwSpecificationFile;
import com.intellij.swagger.model.specification.light.SwFakeMetaHolderKt;
import com.intellij.swagger.providers.resolve.SpecificationResolveHelperKt;
import com.intellij.swagger.reference.definitions.SwDefinitionCoordinatesParser;
import com.intellij.swagger.reference.definitions.SwObjectCoordinates;
import com.intellij.swagger.reference.definitions.SwObjectDefinitionReferenceKt;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.Arrays;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016R!\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/swagger/reference/definitions/SwObjectDefinitionReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "element", "(Lcom/intellij/psi/PsiElement;)V", "objectName", "", "", "getObjectName", "()[Ljava/lang/String;", "objectName$delegate", "Lkotlin/Lazy;", "getRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "getText", "handleElementRename", "newElementName", "resolve", "intellij.swagger"})
public final class SwObjectDefinitionReference
extends PsiReferenceBase<PsiElement> {
    private final Lazy objectName$delegate;

    private final String[] getObjectName() {
        Lazy lazy = this.objectName$delegate;
        SwObjectDefinitionReference swObjectDefinitionReference = this;
        Object var3_3 = null;
        boolean bl = false;
        return (String[])lazy.getValue();
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)this.getElement());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"ElementManipulators.getValueTextRange(element)");
        return textRange;
    }

    private final String getText() {
        TextRange textRange = this.getRangeInElement();
        PsiElement psiElement = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
        String string = textRange.substring(psiElement.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rangeInElement.substring(element.text)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PsiElement resolve() {
        Object object;
        block12: {
            block16: {
                void this_$iv;
                String[] definitionCoordinates;
                boolean bl;
                String[] stringArray;
                PsiFile targetPsiFile;
                block18: {
                    block17: {
                        SwObjectCoordinates coordinates;
                        block13: {
                            block15: {
                                block14: {
                                    block11: {
                                        PsiElement psiElement = this.getElement();
                                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
                                        String string = psiElement.getText();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
                                        coordinates = SwDefinitionCoordinatesParser.INSTANCE.parseObjectCoordinates(string, this.getRangeInElement());
                                        if (!coordinates.isEmpty()) break block11;
                                        object = null;
                                        break block12;
                                    }
                                    if (!coordinates.isWebCoordinates()) break block13;
                                    CharSequence charSequence = coordinates.getUriValue();
                                    boolean bl2 = false;
                                    String string = charSequence;
                                    if (string == null) {
                                        string = "";
                                    }
                                    Url url2 = Urls.parse((String)string, (boolean)false);
                                    if (url2 == null) {
                                        return null;
                                    }
                                    Url url3 = url2;
                                    charSequence = url3.getAuthority();
                                    bl2 = false;
                                    boolean bl3 = false;
                                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) break block14;
                                    String string2 = url3.getPath();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url.path");
                                    if (!StringsKt.isBlank((CharSequence)string2)) break block15;
                                }
                                return null;
                            }
                            object = (PsiElement)new SyntheticElement(this, coordinates){
                                final /* synthetic */ SwObjectDefinitionReference this$0;
                                final /* synthetic */ SwObjectCoordinates $coordinates;

                                @NotNull
                                public PsiElement getParent() {
                                    PsiElement psiElement = SwObjectDefinitionReference.access$getMyElement$p(this.this$0);
                                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"myElement");
                                    return psiElement;
                                }

                                public void navigate(boolean requestFocus) {
                                    if (requestFocus) {
                                        String string = this.$coordinates.getUriValue();
                                        boolean bl = false;
                                        String string2 = string;
                                        if (string2 == null) {
                                            string2 = "";
                                        }
                                        BrowserUtil.browse((String)string2);
                                    }
                                }
                                {
                                    this.this$0 = this$0;
                                    this.$coordinates = $captured_local_variable$1;
                                }
                            };
                            break block12;
                        }
                        CharSequence url3 = coordinates.getUriValue();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        if (url3 == null || StringsKt.isBlank((CharSequence)url3)) break block16;
                        PsiElement psiElement = this.getElement();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
                        PsiFile psiFile2 = psiElement.getContainingFile();
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"element.containingFile");
                        PsiFile psiFile3 = psiFile2.getOriginalFile();
                        Intrinsics.checkNotNullExpressionValue((Object)psiFile3, (String)"element.containingFile.originalFile");
                        targetPsiFile = SwObjectDefinitionReferenceKt.findStorageFile(psiFile3, coordinates.getUriValue());
                        stringArray = coordinates.getDefinitionCoordinates();
                        if (stringArray == null) break block17;
                        String[] stringArray2 = stringArray;
                        bl = false;
                        boolean bl6 = false;
                        String[] it = stringArray2;
                        boolean bl7 = false;
                        stringArray = SwObjectDefinitionUtilsKt.getDefinitionCoordinates((String)it);
                        if (stringArray != null) break block18;
                    }
                    stringArray = new String[]{};
                }
                String[] stringArray3 = definitionCoordinates = stringArray;
                bl = false;
                if (stringArray3.length == 0) {
                    return (PsiElement)targetPsiFile;
                }
                SwElementProvider swElementProvider = SwElementProvider.INSTANCE;
                PsiElement psiElement = this.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
                PsiElement psiElement$iv = (PsiElement)psiElement.getContainingFile();
                boolean $i$f$getTypedModelElement = false;
                SwModelElement swModelElement = this_$iv.getModelElement(psiElement$iv);
                if (!(swModelElement instanceof SwSpecificationFile)) {
                    swModelElement = null;
                }
                SwSpecificationFile swSpecificationFile = (SwSpecificationFile)((SwModelElement)((SwSpecificationFile)swModelElement));
                if (swSpecificationFile == null) {
                    return null;
                }
                SwSpecificationFile specification = swSpecificationFile;
                SwSpecificationFile swSpecificationFile2 = SwFakeMetaHolderKt.createFakeSecondarySpecification(specification, targetPsiFile);
                object = swSpecificationFile2 != null ? swSpecificationFile2.find(Arrays.copyOf(definitionCoordinates, definitionCoordinates.length)) : null;
                break block12;
            }
            PsiElement psiElement = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
            PsiFile psiFile4 = psiElement.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile4, (String)"element.containingFile");
            String[] stringArray = this.getObjectName();
            object = SpecificationResolveHelperKt.resolveLocalObject(psiFile4, Arrays.copyOf(stringArray, stringArray.length));
        }
        return object;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        String string = StringUtil.unquoteString((String)this.getText());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.unquoteString(getText())");
        String unquotedValue = string;
        int locationEndIndex = StringsKt.lastIndexOf$default((CharSequence)unquotedValue, (String)"/", (int)0, (boolean)false, (int)6, null) + 1;
        String string2 = unquotedValue;
        int n = 0;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, locationEndIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String prefix = string4;
        PsiElement psiElement = super.handleElementRename(prefix + newElementName);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"super.handleElementRenam\u2026\"$prefix$newElementName\")");
        return psiElement;
    }

    public SwObjectDefinitionReference(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
        this.objectName$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String[]>(this){
            final /* synthetic */ SwObjectDefinitionReference this$0;

            @NotNull
            public final String[] invoke() {
                return SwObjectDefinitionUtilsKt.getDefinitionCoordinates(SwObjectDefinitionReference.access$getText(this.this$0));
            }
            {
                this.this$0 = swObjectDefinitionReference;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ PsiElement access$getMyElement$p(SwObjectDefinitionReference $this) {
        return $this.myElement;
    }

    public static final /* synthetic */ String access$getText(SwObjectDefinitionReference $this) {
        return $this.getText();
    }
}

