/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.codegen;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.FileCoordinates;
import com.intellij.swagger.SpecificationType;
import com.intellij.swagger.SwDownloadManager;
import com.intellij.swagger.SwDownloadableFileType;
import com.intellij.swagger.SwSpecificationDetectionKt;
import com.intellij.swagger.SwaggerBundle;
import com.intellij.swagger.codegen.CodeGeneratorType;
import com.intellij.swagger.codegen.CodegenConfiguration;
import com.intellij.swagger.codegen.SwJdkUtilsKt;
import com.intellij.swagger.codegen.SwaggerCodegenConfigurationType;
import com.intellij.swagger.codegen.SwaggerCodegenRunConfiguration;
import com.intellij.swagger.codegen.SwaggerRunConfigurationUtilsKt;
import com.intellij.swagger.codegen.completion.SwaggerCodegenMetaProvider;
import com.intellij.util.PathUtil;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/swagger/codegen/SwaggerCodegenRunConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lcom/intellij/swagger/codegen/SwaggerCodegenRunConfiguration;", "()V", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "getSpecificationFilePathOrNull", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "intellij.swagger"})
public final class SwaggerCodegenRunConfigurationProducer
extends LazyRunConfigurationProducer<SwaggerCodegenRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return (ConfigurationFactory)SwaggerCodegenConfigurationType.Companion.getInstance();
    }

    protected boolean setupConfigurationFromContext(@NotNull SwaggerCodegenRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        boolean hasLoadedDefaultGenerator;
        Object object;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        String string = this.getSpecificationFilePathOrNull((PsiElement)sourceElement.get());
        if (string == null) {
            return false;
        }
        String path = string;
        String string2 = configuration.suggestedName();
        if (string2 == null) {
            String string3 = PathUtil.getFileName((String)path);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"PathUtil.getFileName(path)");
        }
        configuration.setName(string2);
        configuration.setSpecificationPath(path);
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project");
        String string4 = project.getBasePath();
        if (string4 == null) {
            string4 = "";
        }
        File generatedFolder = new File(string4, "gen/");
        try {
            object = generatedFolder;
            boolean bl = false;
            boolean bl2 = false;
            File it = object;
            boolean bl3 = false;
            Path path2 = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"it.toPath()");
            PathKt.createDirectories((Path)path2);
            object = ((File)object).getAbsolutePath();
        }
        catch (IOException ex) {
            Project project2 = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"context.project");
            object = project2.getBasePath();
        }
        Object generateTo = object;
        configuration.setGenerateToPath((String)generateTo);
        String defaultGenerator = CodeGeneratorType.OPENAPI_GENERATOR_V5.getUrl();
        configuration.setGeneratorPath(defaultGenerator);
        configuration.setLanguage("java");
        Object object2 = SwDownloadManager.calculateLocalUrlFromRemote$default(SwDownloadManager.INSTANCE, defaultGenerator, SwDownloadableFileType.SWAGGER_CODEGEN_JAR, false, 4, null);
        boolean bl = object2 != null && (object2 = ((FileCoordinates)object2).getPath()) != null ? PathKt.exists((Path)object2) : (hasLoadedDefaultGenerator = false);
        if (!hasLoadedDefaultGenerator) {
            new Task.Backgroundable(defaultGenerator, context, context.getProject(), SwaggerBundle.message("task.background.download.codegen.jar.title", new Object[0]), true){
                final /* synthetic */ String $defaultGenerator;
                final /* synthetic */ ConfigurationContext $context;

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    VirtualFile downloadedFile = SwDownloadManager.INSTANCE.downloadFile(this.$defaultGenerator, SwDownloadableFileType.SWAGGER_CODEGEN_JAR, indicator, false);
                    if (downloadedFile != null) {
                        Project project = this.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                        SwaggerCodegenMetaProvider.Companion.getInstance(project).getCodegenMetadata(new CodegenConfiguration(SwJdkUtilsKt.getDefaultJavaDistribution().getExecutablePath(), SwaggerRunConfigurationUtilsKt.toSystemDependentPath(downloadedFile.getPath()), null, 4, null));
                    }
                }
                {
                    this.$defaultGenerator = $captured_local_variable$0;
                    this.$context = $captured_local_variable$1;
                    super($super_call_param$2, $super_call_param$3, $super_call_param$4);
                }
            }.queue();
        }
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull SwaggerCodegenRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = this.getSpecificationFilePathOrNull(context.getPsiLocation());
        if (string == null) {
            return false;
        }
        String pathOrNull = string;
        return Intrinsics.areEqual((Object)configuration.getSpecificationPath(), (Object)pathOrNull);
    }

    private final String getSpecificationFilePathOrNull(PsiElement psiElement) {
        PsiElement psiElement2 = psiElement;
        if (psiElement2 == null || (psiElement2 = psiElement2.getContainingFile()) == null) {
            return null;
        }
        PsiElement containingFile = psiElement2;
        VirtualFile virtualFile2 = containingFile.getVirtualFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        SpecificationType specificationType = SwSpecificationDetectionKt.detectSpecificationType(virtualFile3, (PsiFile)containingFile);
        return specificationType == SpecificationType.NONE ? null : SwaggerRunConfigurationUtilsKt.toSystemDependentPath(virtualFile3.getPath());
    }
}

