/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.swagger.FileCoordinates;
import com.intellij.swagger.SwDownloadManager;
import com.intellij.swagger.SwDownloadManager$deleteOutdatedDownloads$;
import com.intellij.swagger.SwDownloadableFileType;
import com.intellij.swagger.SwUrlTuner;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00042\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0004H\u0002J$\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u000eJ,\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u000eJ\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0015\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\fH\u0000\u00a2\u0006\u0002\b!J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J+\u0010#\u001a\u0004\u0018\u0001H$\"\u0004\b\u0000\u0010$2\u0006\u0010%\u001a\u00020\u00052\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H$0'H\u0002\u00a2\u0006\u0002\u0010(R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/swagger/SwDownloadManager;", "", "()V", "allowedSchemes", "", "", "myDownloadDirectory", "Ljava/nio/file/Path;", "calculateLocalUrlFromRemote", "Lcom/intellij/swagger/FileCoordinates;", "urlString", "fileType", "Lcom/intellij/swagger/SwDownloadableFileType;", "asLocalIfNoScheme", "", "deleteOutdatedDownloads", "", "filesToIgnore", "Ljava/io/File;", "deleteSpecificationDir", "startDir", "downloadFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileCoordinates", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "force", "ensureAppropriateSubDirectoryExists", "getFilePathByUrl", "url", "Lcom/intellij/util/Url;", "getFullPath", "downloadableFileType", "getFullPath$intellij_swagger", "isAcceptableUrl", "performIoOperationSafely", "T", "customDescription", "operation", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.swagger"})
public final class SwDownloadManager {
    private static final Path myDownloadDirectory;
    private static final Set<String> allowedSchemes;
    @NotNull
    public static final SwDownloadManager INSTANCE;

    @Nullable
    public final FileCoordinates calculateLocalUrlFromRemote(@NotNull String urlString, @NotNull SwDownloadableFileType fileType, boolean asLocalIfNoScheme) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
        Path path = this.ensureAppropriateSubDirectoryExists(fileType);
        if (path == null) {
            return null;
        }
        Path downloadDirectory = path;
        String tunedUrl = SwUrlTuner.INSTANCE.tuneUrl(urlString);
        Url url2 = Urls.parse((String)tunedUrl, (boolean)asLocalIfNoScheme);
        if (url2 == null) {
            return null;
        }
        Url url3 = url2;
        if (!this.isAcceptableUrl(url3)) {
            return null;
        }
        Path path2 = downloadDirectory.resolve(this.getFilePathByUrl(url3));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"downloadDirectory.resolve(getFilePathByUrl(url))");
        return new FileCoordinates(path2, url3);
    }

    public static /* synthetic */ FileCoordinates calculateLocalUrlFromRemote$default(SwDownloadManager swDownloadManager, String string, SwDownloadableFileType swDownloadableFileType, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return swDownloadManager.calculateLocalUrlFromRemote(string, swDownloadableFileType, bl);
    }

    @Nullable
    public final VirtualFile downloadFile(@NotNull String urlString, @NotNull SwDownloadableFileType fileType, @Nullable ProgressIndicator progressIndicator, boolean force) {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
        FileCoordinates fileCoordinates = SwDownloadManager.calculateLocalUrlFromRemote$default(this, urlString, fileType, false, 4, null);
        if (fileCoordinates == null) {
            return null;
        }
        FileCoordinates fileInfo = fileCoordinates;
        return this.downloadFile(fileInfo, progressIndicator, force);
    }

    public static /* synthetic */ VirtualFile downloadFile$default(SwDownloadManager swDownloadManager, String string, SwDownloadableFileType swDownloadableFileType, ProgressIndicator progressIndicator, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return swDownloadManager.downloadFile(string, swDownloadableFileType, progressIndicator, bl);
    }

    @Nullable
    public final VirtualFile downloadFile(@NotNull FileCoordinates fileCoordinates, @Nullable ProgressIndicator progressIndicator, boolean force) {
        Intrinsics.checkNotNullParameter((Object)fileCoordinates, (String)"fileCoordinates");
        ProgressIndicator progressIndicator2 = progressIndicator;
        if (progressIndicator2 != null) {
            if (progressIndicator2.isCanceled()) {
                return null;
            }
        }
        if (PathKt.exists((Path)fileCoordinates.getPath())) {
            if (!force) {
                return VfsUtil.findFile((Path)fileCoordinates.getPath(), (boolean)true);
            }
            this.performIoOperationSafely("Unable to clear directory before download: '" + fileCoordinates.getPath() + '\'', (Function0)new Function0<Unit>(fileCoordinates){
                final /* synthetic */ FileCoordinates $fileCoordinates;

                public final void invoke() {
                    Files.delete(this.$fileCoordinates.getPath());
                }
                {
                    this.$fileCoordinates = fileCoordinates;
                    super(0);
                }
            });
        }
        this.performIoOperationSafely("Unable to download file from url: " + fileCoordinates.getRemoteUrl(), (Function0)new Function0<File>(fileCoordinates, progressIndicator){
            final /* synthetic */ FileCoordinates $fileCoordinates;
            final /* synthetic */ ProgressIndicator $progressIndicator;

            @NotNull
            public final File invoke() {
                return (File)HttpRequests.request((Url)this.$fileCoordinates.getRemoteUrl()).tuner((HttpRequests.ConnectionTuner)downloadFile.1.INSTANCE).connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<File>(this){
                    final /* synthetic */ downloadFile.2 this$0;

                    @NotNull
                    public final File process(@NotNull HttpRequests.Request it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it.saveToFile(this.this$0.$fileCoordinates.getPath().toFile(), this.this$0.$progressIndicator);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$fileCoordinates = fileCoordinates;
                this.$progressIndicator = progressIndicator;
                super(0);
            }
        });
        return PathKt.exists((Path)fileCoordinates.getPath()) ? VfsUtil.findFile((Path)fileCoordinates.getPath(), (boolean)true) : null;
    }

    public static /* synthetic */ VirtualFile downloadFile$default(SwDownloadManager swDownloadManager, FileCoordinates fileCoordinates, ProgressIndicator progressIndicator, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return swDownloadManager.downloadFile(fileCoordinates, progressIndicator, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteOutdatedDownloads(@NotNull Set<? extends File> filesToIgnore, @NotNull SwDownloadableFileType fileType) {
        Intrinsics.checkNotNullParameter(filesToIgnore, (String)"filesToIgnore");
        Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
        Path downloadDirectory = this.getFullPath$intellij_swagger(fileType);
        if (!PathKt.exists((Path)downloadDirectory) || !PathKt.isDirectory((Path)downloadDirectory)) {
            return;
        }
        AutoCloseable autoCloseable = Files.list(downloadDirectory);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Stream filesStream = (Stream)autoCloseable;
            boolean bl3 = false;
            filesStream.filter((Predicate)new Predicate<Path>(filesToIgnore){
                final /* synthetic */ Set $filesToIgnore$inlined;
                {
                    this.$filesToIgnore$inlined = set;
                }

                public final boolean test(Path it) {
                    return !this.$filesToIgnore$inlined.contains(it.toFile());
                }
            }).forEach(new Consumer<Path>(filesToIgnore){
                final /* synthetic */ Set $filesToIgnore$inlined;
                {
                    this.$filesToIgnore$inlined = set;
                }

                public final void accept(Path it) {
                    StringBuilder stringBuilder = new StringBuilder().append("Can not delete outdated file \"");
                    Path path = it;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                    SwDownloadManager.access$performIoOperationSafely(SwDownloadManager.INSTANCE, stringBuilder.append(path.getFileName()).append('\"').toString(), (Function0)new Function0<Object>(this, it){
                        final /* synthetic */ deleteOutdatedDownloads$$inlined$use$lambda$2 this$0;
                        final /* synthetic */ Path $it;
                        {
                            this.this$0 = var1_1;
                            this.$it = path;
                            super(0);
                        }

                        @NotNull
                        public final Object invoke() {
                            Boolean bl;
                            Path path = this.$it;
                            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"it");
                            if (PathKt.isDirectory((Path)path)) {
                                Path path2 = this.$it;
                                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"it");
                                SwDownloadManager.access$deleteSpecificationDir(SwDownloadManager.INSTANCE, path2, this.this$0.$filesToIgnore$inlined);
                                bl = Unit.INSTANCE;
                            } else {
                                bl = Files.deleteIfExists(this.$it);
                            }
                            return bl;
                        }
                    });
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void deleteSpecificationDir(Path startDir, Set<? extends File> filesToIgnore) {
        Files.walkFileTree(startDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(filesToIgnore){
            final /* synthetic */ Set $filesToIgnore;

            @NotNull
            public FileVisitResult visitFile(@NotNull Path path, @NotNull BasicFileAttributes attrs) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
                if (!this.$filesToIgnore.contains(path.toFile())) {
                    Files.deleteIfExists(path);
                }
                return FileVisitResult.CONTINUE;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public FileVisitResult postVisitDirectory(@NotNull Path dir, @Nullable IOException exception) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
                if (exception != null) {
                    throw (Throwable)exception;
                }
                AutoCloseable autoCloseable = Files.list(dir);
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    Stream it = (Stream)autoCloseable;
                    boolean bl4 = false;
                    Optional<T> optional = it.findAny();
                    Intrinsics.checkNotNullExpressionValue(optional, (String)"it.findAny()");
                    bl = optional.isEmpty();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                if (bl) {
                    Files.deleteIfExists(dir);
                }
                return FileVisitResult.CONTINUE;
            }
            {
                this.$filesToIgnore = $captured_local_variable$0;
            }
        });
    }

    @NotNull
    public final Path getFullPath$intellij_swagger(@NotNull SwDownloadableFileType downloadableFileType) {
        Intrinsics.checkNotNullParameter((Object)((Object)downloadableFileType), (String)"downloadableFileType");
        Path path = myDownloadDirectory.resolve(downloadableFileType.getRelativePath());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"myDownloadDirectory.reso\u2026bleFileType.relativePath)");
        return path;
    }

    private final boolean isAcceptableUrl(Url url2) {
        boolean bl;
        if (!CollectionsKt.contains((Iterable)allowedSchemes, (Object)url2.getScheme())) {
            bl = false;
        } else {
            String string = url2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
            CharSequence charSequence = string;
            boolean bl2 = false;
            bl = !(charSequence.length() == 0);
        }
        return bl;
    }

    private final Path ensureAppropriateSubDirectoryExists(SwDownloadableFileType fileType) {
        return (Path)this.performIoOperationSafely("Unable to create directory for downloadable file of type \"" + (Object)((Object)fileType) + '\"', (Function0)new Function0<Path>(fileType){
            final /* synthetic */ SwDownloadableFileType $fileType;

            public final Path invoke() {
                return Files.createDirectories(SwDownloadManager.INSTANCE.getFullPath$intellij_swagger(this.$fileType), new FileAttribute[0]);
            }
            {
                this.$fileType = swDownloadableFileType;
                super(0);
            }
        });
    }

    private final String getFilePathByUrl(Url url2) {
        String string = url2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
        String fileName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null));
        MessageDigest digest = DigestUtil.md5();
        String string2 = url2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url.path");
        String string3 = string2;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string4 = string3;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string4.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        digest.update(byArray);
        String dirName = DigestUtil.digestToHash((MessageDigest)digest);
        return dirName + '/' + fileName;
    }

    private final <T> T performIoOperationSafely(String customDescription, Function0<? extends T> operation) {
        try {
            return (T)operation.invoke();
        }
        catch (IOException ex) {
            Logger.getInstance(SwDownloadManager.class).warn("Unable to process file. " + customDescription, (Throwable)ex);
        }
        catch (SecurityException ex) {
            Logger.getInstance(SwDownloadManager.class).warn("Unable to access file. " + customDescription, (Throwable)ex);
        }
        return null;
    }

    private SwDownloadManager() {
    }

    static {
        SwDownloadManager swDownloadManager;
        INSTANCE = swDownloadManager = new SwDownloadManager();
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("openapi");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(PathManager.ge\u2026Constants.OPENAPI_FOLDER)");
        myDownloadDirectory = path;
        Files.createDirectories(myDownloadDirectory, new FileAttribute[0]);
        allowedSchemes = SetsKt.setOf((Object[])new String[]{"http", "https", "file"});
    }

    public static final /* synthetic */ Object access$performIoOperationSafely(SwDownloadManager $this, String customDescription, Function0 operation) {
        return $this.performIoOperationSafely(customDescription, operation);
    }

    public static final /* synthetic */ void access$deleteSpecificationDir(SwDownloadManager $this, Path startDir, Set filesToIgnore) {
        $this.deleteSpecificationDir(startDir, filesToIgnore);
    }
}

