/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.quickfixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.actions.RenameElementAction;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.spellchecker.quickfixes.DictionarySuggestionProvider;
import com.intellij.spellchecker.quickfixes.LazySuggestions;
import com.intellij.spellchecker.quickfixes.SpellCheckerQuickFix;
import com.intellij.spellchecker.util.SpellCheckerBundle;
import icons.SpellcheckerIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameTo
extends LazySuggestions
implements SpellCheckerQuickFix {
    public RenameTo(String wordWithTypo) {
        super(wordWithTypo);
    }

    @NotNull
    public String getFamilyName() {
        String string = RenameTo.getFixName();
        if (string == null) {
            RenameTo.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    private static DictionarySuggestionProvider findProvider() {
        for (Object extension : NameSuggestionProvider.EP_NAME.getExtensionList()) {
            if (!(extension instanceof DictionarySuggestionProvider)) continue;
            return (DictionarySuggestionProvider)((Object)extension);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement psiElement;
        DictionarySuggestionProvider provider;
        if (project == null) {
            RenameTo.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            RenameTo.$$$reportNull$$$0(2);
        }
        if ((provider = RenameTo.findProvider()) != null) {
            provider.setActive(true);
        }
        if ((psiElement = descriptor.getPsiElement()) == null) {
            return;
        }
        Editor editor = this.getEditor(psiElement, project);
        if (editor == null) {
            return;
        }
        SimpleDataContext.Builder builder = SimpleDataContext.builder();
        if (editor instanceof EditorWindow) {
            builder.add(CommonDataKeys.EDITOR, (Object)editor);
            builder.add(CommonDataKeys.PSI_ELEMENT, (Object)psiElement);
        } else if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiElement data = (PsiElement)new TextEditorPsiDataProvider().getData(CommonDataKeys.PSI_ELEMENT.getName(), editor, editor.getCaretModel().getCurrentCaret());
            builder.add(CommonDataKeys.PSI_ELEMENT, (Object)data);
        }
        Boolean selectAll = (Boolean)editor.getUserData(RenameHandlerRegistry.SELECT_ALL);
        try {
            editor.putUserData(RenameHandlerRegistry.SELECT_ALL, (Object)true);
            DataContext dataContext = builder.setParent(((EditorEx)editor).getDataContext()).build();
            RenameElementAction action = new RenameElementAction();
            AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)action, null, (String)"", (DataContext)dataContext);
            action.actionPerformed(event);
            if (provider != null) {
                provider.setActive(false);
            }
        }
        finally {
            editor.putUserData(RenameHandlerRegistry.SELECT_ALL, (Object)selectAll);
        }
    }

    @Nls
    public static String getFixName() {
        return SpellCheckerBundle.message("rename.to", new Object[0]);
    }

    public Icon getIcon(int flags) {
        return SpellcheckerIcons.Spellcheck;
    }

    @Nullable
    protected Editor getEditor(PsiElement element, @NotNull Project project) {
        if (project == null) {
            RenameTo.$$$reportNull$$$0(3);
        }
        return InjectedLanguageUtil.findInjectionHost((PsiElement)element) != null ? InjectedLanguageUtil.openEditorFor((PsiFile)element.getContainingFile(), (Project)project) : FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spellchecker/quickfixes/RenameTo";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spellchecker/quickfixes/RenameTo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

