/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.blade.BladeBundle;
import com.jetbrains.php.blade.injection.BladeInjectionMappingService;
import com.jetbrains.php.blade.lexer.BladeCustomizedLexer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeTextBlocksSettingsForm {
    @NonNls
    private static final String TEXT_FIELD_NAME_KEY = "BladeTextFieldSettingsNameKey";
    private JPanel myMainPanel;
    private JTextField myRawStartField;
    private JTextField myRawEndField;
    private JTextField myContentStartField;
    private JTextField myContentEndField;
    private JTextField myEscapedStartField;
    private JTextField myEscapedEndField;
    private JBLabel myErrorLabel;

    public BladeTextBlocksSettingsForm() {
        this.$$$setupUI$$$();
        DocumentAdapter validationListener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                BladeTextBlocksSettingsForm.this.validateAndInform();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/blade/ui/BladeTextBlocksSettingsForm$1", "textChanged"));
            }
        };
        this.myRawStartField.getDocument().addDocumentListener((DocumentListener)validationListener);
        this.myRawEndField.getDocument().addDocumentListener((DocumentListener)validationListener);
        this.myContentStartField.getDocument().addDocumentListener((DocumentListener)validationListener);
        this.myContentEndField.getDocument().addDocumentListener((DocumentListener)validationListener);
        this.myEscapedStartField.getDocument().addDocumentListener((DocumentListener)validationListener);
        this.myEscapedEndField.getDocument().addDocumentListener((DocumentListener)validationListener);
        BladeTextBlocksSettingsForm.putPresentableName(this.myRawStartField, BladeBundle.message("blade.raw.start.tag", new Object[0]));
        BladeTextBlocksSettingsForm.putPresentableName(this.myRawEndField, BladeBundle.message("blade.raw.end.tag", new Object[0]));
        BladeTextBlocksSettingsForm.putPresentableName(this.myContentStartField, BladeBundle.message("blade.content.start.tag", new Object[0]));
        BladeTextBlocksSettingsForm.putPresentableName(this.myContentEndField, BladeBundle.message("blade.content.end.tag", new Object[0]));
        BladeTextBlocksSettingsForm.putPresentableName(this.myEscapedStartField, BladeBundle.message("blade.escaped.start.tag", new Object[0]));
        BladeTextBlocksSettingsForm.putPresentableName(this.myEscapedEndField, BladeBundle.message("blade.escaped.end.tag", new Object[0]));
        this.myErrorLabel.setIcon(UIUtil.getBalloonWarningIcon());
    }

    private static void putPresentableName(JTextField field, @Nls String name) {
        field.putClientProperty(TEXT_FIELD_NAME_KEY, name);
    }

    private static String getPresentableName(JTextField field) {
        return (String)field.getClientProperty(TEXT_FIELD_NAME_KEY);
    }

    private void validateAndInform() {
        String message = this.getValidationMessage();
        if (message == null) {
            this.myErrorLabel.setVisible(false);
        } else {
            this.myErrorLabel.setVisible(true);
            this.myErrorLabel.setText(message);
        }
    }

    @Nullable
    @NlsContexts.Label
    private String getValidationMessage() {
        String message = BladeTextBlocksSettingsForm.getValidationMessage(this.myRawStartField);
        if (message != null) {
            return message;
        }
        message = BladeTextBlocksSettingsForm.getValidationMessage(this.myRawEndField);
        if (message != null) {
            return message;
        }
        message = BladeTextBlocksSettingsForm.getValidationMessage(this.myContentStartField);
        if (message != null) {
            return message;
        }
        message = BladeTextBlocksSettingsForm.getValidationMessage(this.myContentEndField);
        if (message != null) {
            return message;
        }
        message = BladeTextBlocksSettingsForm.getValidationMessage(this.myEscapedStartField);
        if (message != null) {
            return message;
        }
        message = BladeTextBlocksSettingsForm.getValidationMessage(this.myEscapedEndField);
        if (message != null) {
            return message;
        }
        message = BladeTextBlocksSettingsForm.checkEquality(this.myRawStartField, this.myContentStartField);
        if (message != null) {
            return message;
        }
        message = BladeTextBlocksSettingsForm.checkEquality(this.myContentStartField, this.myEscapedStartField);
        if (message != null) {
            return message;
        }
        message = BladeTextBlocksSettingsForm.checkEquality(this.myRawStartField, this.myEscapedStartField);
        if (message != null) {
            return message;
        }
        return null;
    }

    @Nullable
    @NlsContexts.Label
    private static String getValidationMessage(JTextField field) {
        if (!BladeCustomizedLexer.isDelimiterReasonable(field.getText())) {
            String name = BladeTextBlocksSettingsForm.getPresentableName(field);
            return BladeBundle.message("blade.text.block.settings.unnamed.validation.0", name);
        }
        return null;
    }

    @Nullable
    @NlsContexts.Label
    private static String checkEquality(JTextField field, JTextField otherField) {
        String text = field.getText();
        String otherText = otherField.getText();
        if (text != null && text.equals(otherText)) {
            return BladeBundle.message("settings.blocks.please.check.settings.0.and.1.are.equal", BladeTextBlocksSettingsForm.getPresentableName(field), BladeTextBlocksSettingsForm.getPresentableName(otherField));
        }
        return null;
    }

    public Component createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified(BladeInjectionMappingService.BladeState state) {
        return this.determineIsModified(state);
    }

    private boolean determineIsModified(BladeInjectionMappingService.BladeState state) {
        if (!BladeTextBlocksSettingsForm.equalIgnoringNullity(this.myRawStartField.getText(), state.getRawTextBlockStart())) {
            return true;
        }
        if (!BladeTextBlocksSettingsForm.equalIgnoringNullity(this.myRawEndField.getText(), state.getRawTextBlockEnd())) {
            return true;
        }
        if (!BladeTextBlocksSettingsForm.equalIgnoringNullity(this.myContentStartField.getText(), state.getTextBlockStart())) {
            return true;
        }
        if (!BladeTextBlocksSettingsForm.equalIgnoringNullity(this.myContentEndField.getText(), state.getTextBlockEnd())) {
            return true;
        }
        if (!BladeTextBlocksSettingsForm.equalIgnoringNullity(this.myEscapedStartField.getText(), state.getEscapedTextBlockStart())) {
            return true;
        }
        return !BladeTextBlocksSettingsForm.equalIgnoringNullity(this.myEscapedEndField.getText(), state.getEscapedTextBlockEnd());
    }

    private static boolean equalIgnoringNullity(@Nullable String s1, @Nullable String s2) {
        if (s1 == null) {
            return s2 == null || s2.isEmpty();
        }
        if (s2 == null) {
            return s1.isEmpty();
        }
        return s1.equals(s2);
    }

    public void apply(BladeInjectionMappingService.BladeState state) {
        state.setTextBlockStart(BladeTextBlocksSettingsForm.getText(this.myContentStartField));
        state.setTextBlockEnd(BladeTextBlocksSettingsForm.getText(this.myContentEndField));
        state.setRawTextBlockStart(BladeTextBlocksSettingsForm.getText(this.myRawStartField));
        state.setRawTextBlockEnd(BladeTextBlocksSettingsForm.getText(this.myRawEndField));
        state.setEscapedTextBlockStart(BladeTextBlocksSettingsForm.getText(this.myEscapedStartField));
        state.setEscapedTextBlockEnd(BladeTextBlocksSettingsForm.getText(this.myEscapedEndField));
    }

    private static String getText(JTextField field) {
        return StringUtil.notNullize((String)field.getText());
    }

    public void reset(BladeInjectionMappingService.BladeState state) {
        this.myContentStartField.setText(state.getTextBlockStart());
        this.myContentEndField.setText(state.getTextBlockEnd());
        this.myRawStartField.setText(state.getRawTextBlockStart());
        this.myRawEndField.setText(state.getRawTextBlockEnd());
        this.myEscapedStartField.setText(state.getEscapedTextBlockStart());
        this.myEscapedEndField.setText(state.getEscapedTextBlockEnd());
        this.validateAndInform();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JTextField jTextField6;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndentWithoutInsets");
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndentWithoutInsets.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/BladeBundle", BladeTextBlocksSettingsForm.class).getString("settings.panel.text.blocks"), (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 7, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeTextBlocksSettingsForm.class).getString("label.raw.tags"));
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myRawStartField = jTextField6 = new JTextField();
        jPanel.add((Component)jTextField6, new GridConstraints(0, 3, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeTextBlocksSettingsForm.class).getString("label.start"));
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myRawEndField = jTextField5 = new JTextField();
        jPanel.add((Component)jTextField5, new GridConstraints(0, 5, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeTextBlocksSettingsForm.class).getString("label.end"));
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 4, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeTextBlocksSettingsForm.class).getString("label.content.tags"));
        jPanel.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myContentStartField = jTextField4 = new JTextField();
        jPanel.add((Component)jTextField4, new GridConstraints(1, 3, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.myContentEndField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(1, 5, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeTextBlocksSettingsForm.class).getString("label.start"));
        jPanel.add((Component)jBLabel6, new GridConstraints(1, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel7, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeTextBlocksSettingsForm.class).getString("label.end"));
        jPanel.add((Component)jBLabel7, new GridConstraints(1, 4, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel8 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel8, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeTextBlocksSettingsForm.class).getString("label.escaped.tags"));
        jPanel.add((Component)jBLabel8, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myEscapedStartField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(2, 3, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.myEscapedEndField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 5, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel9 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel9, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeTextBlocksSettingsForm.class).getString("label.start"));
        jPanel.add((Component)jBLabel9, new GridConstraints(2, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel10 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel10, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeTextBlocksSettingsForm.class).getString("label.end"));
        jPanel.add((Component)jBLabel10, new GridConstraints(2, 4, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel.add((Component)spacer3, new GridConstraints(0, 6, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myErrorLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(4, 0, 1, 7, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

