/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.ui;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.blade.BladeBundle;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.injection.BladeInjectionMappingService;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeDirectivesSettingsForm {
    private JPanel myMainPanel;
    private JPanel myTablePanel;
    private JPanel myDirectiveSettingsCardContainer;
    private JTextField myDirectiveNameTextField;
    private JBCheckBox myParametrisedCheckBox;
    private JPanel myInjectionPanel;
    private JTextField myPrefixTextField;
    private JTextField mySuffixTextField;
    private JBLabel myCurrentDirectiveErrorLabel;
    private JBLabel myErrorLabel;
    private final TableView<InjectionDataEx> myDirectivesTable;
    private final DirectivesTableModel myDirectivesTableModel;
    private InjectionDataEx mySelectedDirective;
    private final SortedSet<Integer> myInvalidModelIndices;
    private static final ColumnInfo<BladeInjectionMappingService.InjectionData, String> MY_DIRECTIVE_COLUMN = new ColumnInfo<BladeInjectionMappingService.InjectionData, String>(null){

        @NotNull
        public String valueOf(BladeInjectionMappingService.InjectionData data) {
            String string = data.getDirective();
            if (string == null) {
                4.$$$reportNull$$$0(0);
            }
            return string;
        }

        public Class getColumnClass() {
            return String.class;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/blade/ui/BladeDirectivesSettingsForm$4", "valueOf"));
        }
    };
    private static final ColumnInfo<InjectionDataEx, String> MY_INJECTION_COLUMN = new ColumnInfo<InjectionDataEx, String>(null){

        public boolean isCellEditable(InjectionDataEx data) {
            return false;
        }

        public TableCellRenderer getCustomizedRenderer(final InjectionDataEx o, TableCellRenderer renderer) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (value instanceof String) {
                        this.append((String)value, SimpleTextAttributes.GRAYED_ATTRIBUTES, o);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/blade/ui/BladeDirectivesSettingsForm$5$1", "customizeCellRenderer"));
                }
            };
        }

        @Nullable
        public String valueOf(InjectionDataEx data) {
            return data.getDescription();
        }

        public Class getColumnClass() {
            return String.class;
        }
    };

    public BladeDirectivesSettingsForm() {
        this.$$$setupUI$$$();
        this.myInvalidModelIndices = new TreeSet<Integer>();
        this.myDirectivesTable = new TableView();
        this.myDirectivesTable.setShowGrid(false);
        this.myDirectivesTableModel = new DirectivesTableModel();
        this.myDirectivesTable.setModelAndUpdateColumns((ListTableModel)this.myDirectivesTableModel);
        this.myErrorLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myErrorLabel.setVisible(false);
        this.myCurrentDirectiveErrorLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myCurrentDirectiveErrorLabel.setVisible(false);
        new TableSpeedSearch(this.myDirectivesTable);
        this.resetFromSelectedDirective(null);
        this.myDirectivesTable.getSelectionModel().addListSelectionListener(e -> {
            InjectionDataEx oldSelectedDirective = this.mySelectedDirective;
            InjectionDataEx newSelectedDirective = (InjectionDataEx)this.myDirectivesTable.getSelectedObject();
            if (oldSelectedDirective == null && newSelectedDirective == null) {
                return;
            }
            if (oldSelectedDirective == newSelectedDirective) {
                return;
            }
            this.applyDirectiveChanges();
            this.resetFromSelectedDirective(newSelectedDirective);
        });
        this.myParametrisedCheckBox.addActionListener(e -> UIUtil.setEnabled((Component)this.myInjectionPanel, (boolean)this.myParametrisedCheckBox.isSelected(), (boolean)true));
        this.setUpCustomRendererWithWarningIcon();
        this.registerDirectiveChangesApplier();
        this.createTableActions();
    }

    private void setUpCustomRendererWithWarningIcon() {
        TableColumn displayTypeColumn = this.myDirectivesTable.getColumnModel().getColumn(0);
        displayTypeColumn.setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

            protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(value instanceof String)) {
                    return;
                }
                String text = (String)value;
                if (BladeDirectivesSettingsForm.this.myInvalidModelIndices.contains(row)) {
                    this.append(text, SimpleTextAttributes.ERROR_ATTRIBUTES);
                } else {
                    this.append(text);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/php/blade/ui/BladeDirectivesSettingsForm$1", "customizeCellRenderer"));
            }
        });
    }

    private void createTableActions() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myDirectivesTable).disableUpAction().disableDownAction();
        decorator.setAddActionName(BladeBundle.message("settings.action.add.directive", new Object[0])).setAddAction(button -> {
            this.myDirectivesTable.stopEditing();
            this.myDirectivesTableModel.addRow();
        });
        decorator.setRemoveActionName(BladeBundle.message("settings.action.remove.directive.s", new Object[0])).setRemoveAction(button -> {
            this.myDirectivesTable.stopEditing();
            if (this.myDirectivesTableModel != null) {
                int[] rows = this.myDirectivesTable.getSelectedRows();
                Collection selectedRows = this.myDirectivesTable.getSelection();
                this.myDirectivesTableModel.removeAll(selectedRows);
                int index = Math.min(rows[0], this.myDirectivesTableModel.getRowCount() - 1);
                if (index != -1) {
                    this.myDirectivesTable.setRowSelectionInterval(index, index);
                }
            }
        }).setRemoveActionUpdater(e -> this.myDirectivesTable.getSelectedRows().length > 0);
        decorator.addExtraAction(new AnActionButton(BladeBundle.message("settings.action.reset.to.defaults", new Object[0]), BladeBundle.message("settings.action.settings.action.reset.to.defaults", new Object[0]), AllIcons.General.Reset){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                BladeDirectivesSettingsForm.this.myDirectivesTable.stopEditing();
                if (BladeDirectivesSettingsForm.this.myDirectivesTableModel != null) {
                    BladeDirectivesSettingsForm.this.myDirectivesTableModel.resetToDefaults();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/blade/ui/BladeDirectivesSettingsForm$2", "actionPerformed"));
            }
        });
        this.myTablePanel.add((Component)decorator.createPanel(), "Center");
    }

    private void registerDirectiveChangesApplier() {
        DocumentAdapter listener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                BladeDirectivesSettingsForm.this.applyDirectiveChanges();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/blade/ui/BladeDirectivesSettingsForm$3", "textChanged"));
            }
        };
        this.myDirectiveNameTextField.getDocument().addDocumentListener((DocumentListener)listener);
        this.myPrefixTextField.getDocument().addDocumentListener((DocumentListener)listener);
        this.mySuffixTextField.getDocument().addDocumentListener((DocumentListener)listener);
        this.myParametrisedCheckBox.addActionListener(e -> this.applyDirectiveChanges());
    }

    private void applyDirectiveChanges() {
        if (this.mySelectedDirective == null || !this.mySelectedDirective.isModifiable) {
            return;
        }
        this.mySelectedDirective.setDirective("@" + StringUtil.notNullize((String)this.myDirectiveNameTextField.getText()).trim());
        boolean parametrized = this.myParametrisedCheckBox.isSelected();
        this.mySelectedDirective.setParametrized(parametrized);
        UIUtil.setEnabled((Component)this.myInjectionPanel, (boolean)this.myParametrisedCheckBox.isSelected(), (boolean)true);
        this.mySelectedDirective.setPrefix(StringUtil.notNullize((String)this.myPrefixTextField.getText()).trim());
        this.mySelectedDirective.setSuffix(StringUtil.notNullize((String)this.mySuffixTextField.getText()).trim());
        int row = this.myDirectivesTableModel.indexOf(this.mySelectedDirective);
        this.myDirectivesTableModel.fireTableRowsUpdated(row, row);
        this.runValidation();
    }

    private void resetFromSelectedDirective(@Nullable InjectionDataEx directive) {
        this.mySelectedDirective = null;
        CardLayout cardLayout = (CardLayout)this.myDirectiveSettingsCardContainer.getLayout();
        if (directive == null) {
            cardLayout.show(this.myDirectiveSettingsCardContainer, "NoDirective");
        } else if (!directive.isModifiable) {
            cardLayout.show(this.myDirectiveSettingsCardContainer, "UnmodifiableDirective");
        } else {
            this.myDirectiveNameTextField.setText(directive.getDirective().substring(1));
            this.myParametrisedCheckBox.setSelected(directive.isParametrized());
            UIUtil.setEnabled((Component)this.myInjectionPanel, (boolean)this.myParametrisedCheckBox.isSelected(), (boolean)true);
            this.myPrefixTextField.setText(directive.getPrefix());
            this.mySuffixTextField.setText(directive.getSuffix());
            cardLayout.show(this.myDirectiveSettingsCardContainer, "Directive");
        }
        this.mySelectedDirective = directive;
        this.runValidation();
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified(BladeInjectionMappingService.BladeState state) {
        List<BladeInjectionMappingService.InjectionData> serviceInfos;
        Map<String, BladeInjectionMappingService.InjectionData> serviceMap;
        List infos = this.myDirectivesTableModel.getItems();
        Map<String, BladeInjectionMappingService.InjectionData> tableMap = BladeDirectivesSettingsForm.filterData(infos);
        return !Comparing.equal(tableMap, serviceMap = BladeDirectivesSettingsForm.filterData(serviceInfos = state.getDataList()));
    }

    private static Map<String, BladeInjectionMappingService.InjectionData> filterData(List<? extends BladeInjectionMappingService.InjectionData> data) {
        HashMap<String, BladeInjectionMappingService.InjectionData> result = new HashMap<String, BladeInjectionMappingService.InjectionData>();
        for (BladeInjectionMappingService.InjectionData injectionData : data) {
            String directive;
            if (injectionData instanceof InjectionDataEx && !((InjectionDataEx)injectionData).isModifiable || !(directive = injectionData.getDirective()).startsWith("@") || result.containsKey(directive)) continue;
            result.put(directive, injectionData);
        }
        return result;
    }

    public void apply(BladeInjectionMappingService.BladeState state) {
        List infos = this.myDirectivesTableModel.getItems();
        Map<String, BladeInjectionMappingService.InjectionData> filteredInfos = BladeDirectivesSettingsForm.filterData(infos);
        HashMap<String, BladeInjectionInfo> result = new HashMap<String, BladeInjectionInfo>();
        for (Map.Entry<String, BladeInjectionMappingService.InjectionData> info : filteredInfos.entrySet()) {
            result.put(info.getKey(), info.getValue().toInjectionInfo());
        }
        state.setDataMap(result);
    }

    public void reset(BladeInjectionMappingService service) {
        Map<String, BladeInjectionInfo> infos = service.getDirectiveInfos();
        ArrayList<InjectionDataEx> list = new ArrayList<InjectionDataEx>(infos.size());
        for (Map.Entry<String, BladeInjectionInfo> entry : infos.entrySet()) {
            list.add(new InjectionDataEx(entry.getKey(), entry.getValue()));
        }
        list.sort(Comparator.comparing(BladeInjectionMappingService.InjectionData::getDirective));
        this.myDirectivesTableModel.setItems(list);
        this.runValidation();
    }

    private void runValidation() {
        HashSet<Integer> invalidModelIndices = new HashSet<Integer>();
        List items = this.myDirectivesTableModel.getItems();
        HashSet<String> directives = new HashSet<String>();
        HashSet<String> duplicatingDirectives = new HashSet<String>();
        for (BladeInjectionMappingService.InjectionData item : items) {
            String directive = item.getDirective();
            if (directives.add(directive)) continue;
            duplicatingDirectives.add(directive);
        }
        for (BladeInjectionMappingService.InjectionData item : items) {
            if (BladeDirectivesSettingsForm.getValidationMessage(item, duplicatingDirectives) == null) continue;
            invalidModelIndices.add(this.myDirectivesTableModel.indexOf(item));
        }
        if (!this.myInvalidModelIndices.equals(invalidModelIndices)) {
            this.myInvalidModelIndices.addAll(invalidModelIndices);
            Integer first = this.myInvalidModelIndices.first();
            Integer last = this.myInvalidModelIndices.last();
            this.myInvalidModelIndices.clear();
            this.myInvalidModelIndices.addAll(invalidModelIndices);
            this.myDirectivesTableModel.fireTableRowsUpdated(first, last);
        }
        this.myErrorLabel.setVisible(!this.myInvalidModelIndices.isEmpty());
        this.runValidationOnCurrentDirective(duplicatingDirectives);
    }

    private void runValidationOnCurrentDirective(Set<String> duplicatingDirectives) {
        String currentValidationMessage = this.mySelectedDirective != null ? BladeDirectivesSettingsForm.getValidationMessage(this.mySelectedDirective, duplicatingDirectives) : null;
        this.myCurrentDirectiveErrorLabel.setText(currentValidationMessage);
        this.myCurrentDirectiveErrorLabel.setVisible(currentValidationMessage != null);
    }

    @Nullable
    @NlsContexts.Label
    private static String getValidationMessage(@NotNull BladeInjectionMappingService.InjectionData data, Set<String> duplicatingNames) {
        String directive;
        if (data == null) {
            BladeDirectivesSettingsForm.$$$reportNull$$$0(0);
        }
        if (duplicatingNames.contains(directive = data.getDirective())) {
            return BladeBundle.message("settings.directives.validation.duplicating.settings.for.directive.0", directive);
        }
        if (directive.length() == 1) {
            return BladeBundle.message("settings.directives.validation.no.directive.name", new Object[0]);
        }
        if (data.isParametrized() && data.getPrefix().isEmpty() && data.getSuffix().isEmpty()) {
            return BladeBundle.message("settings.directives.validation.no.injection.info", new Object[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/php/blade/ui/BladeDirectivesSettingsForm", "getValidationMessage"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JTextField jTextField3;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithoutIndentWithoutInsets.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/BladeBundle", BladeDirectivesSettingsForm.class).getString("settings.panel.directives"), (int)0, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTablePanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.putClientProperty("BorderFactoryClass", "");
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDirectiveSettingsCardContainer = jPanel2 = new JPanel();
        jPanel2.setLayout(new CardLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 2, null, null, null, 1));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, "Directive");
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeDirectivesSettingsForm.class).getString("label.name"));
        jPanel5.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectiveNameTextField = jTextField3 = new JTextField();
        jPanel5.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        this.myParametrisedCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeDirectivesSettingsForm.class).getString("checkbox.has.parameter"));
        jPanel5.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myInjectionPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 1, true));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeDirectivesSettingsForm.class).getString("label.prefix"));
        jPanel.add((Component)jBLabel4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myPrefixTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        this.mySuffixTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeDirectivesSettingsForm.class).getString("label.suffix"));
        jPanel.add((Component)jBLabel5, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myCurrentDirectiveErrorLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("");
        jPanel5.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, "NoDirective");
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeDirectivesSettingsForm.class).getString("label.no.directive.is.selected"));
        jPanel6.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, "UnmodifiableDirective");
        JBLabel jBLabel7 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel7, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeDirectivesSettingsForm.class).getString("label.unmodifiable.directive"));
        jPanel7.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myErrorLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/BladeBundle", BladeDirectivesSettingsForm.class).getString("label.some.directives.are.invalid.please.check.them"));
        jPanel4.add((Component)jBLabel, new GridConstraints(3, 0, 1, 1, 0, 3, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static final class InjectionDataEx
    extends BladeInjectionMappingService.InjectionData {
        private final boolean isModifiable;
        @Nullable
        private String description;

        private InjectionDataEx(@NotNull String directive, @Nullable BladeInjectionInfo info) {
            if (directive == null) {
                InjectionDataEx.$$$reportNull$$$0(0);
            }
            super(directive, info);
            boolean bl = this.isModifiable = info == null || info.isConfigurable();
            if (!this.isModifiable) {
                this.description = info.getUnmodifiablePresentableDescription();
            }
        }

        private InjectionDataEx(@NotNull String directive, boolean isParametrized, @NotNull String prefix, @NotNull String suffix) {
            if (directive == null) {
                InjectionDataEx.$$$reportNull$$$0(1);
            }
            if (prefix == null) {
                InjectionDataEx.$$$reportNull$$$0(2);
            }
            if (suffix == null) {
                InjectionDataEx.$$$reportNull$$$0(3);
            }
            super(directive, isParametrized, prefix, suffix);
            this.isModifiable = true;
        }

        @Nullable
        private String getDescription() {
            if (this.isParametrized()) {
                if (!this.isModifiable) {
                    return this.description;
                }
                return "(\"" + this.getPrefix() + "\", \"" + this.getSuffix() + "\")";
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "directive";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prefix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "suffix";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/blade/ui/BladeDirectivesSettingsForm$InjectionDataEx";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class DirectivesTableModel
    extends ListTableModel<InjectionDataEx> {
        private DirectivesTableModel() {
            super(new ColumnInfo[]{MY_DIRECTIVE_COLUMN, MY_INJECTION_COLUMN});
        }

        public void addRow() {
            InjectionDataEx item = new InjectionDataEx("@", false, "", "");
            this.addRow(item);
            BladeDirectivesSettingsForm.this.myDirectivesTable.setSelection(Collections.singleton(item));
            int rowIndex = BladeDirectivesSettingsForm.this.myDirectivesTable.convertRowIndexToView(BladeDirectivesSettingsForm.this.myDirectivesTableModel.indexOf(item));
            Rectangle cellRect = BladeDirectivesSettingsForm.this.myDirectivesTable.getCellRect(rowIndex, 0, false);
            BladeDirectivesSettingsForm.this.myDirectivesTable.scrollRectToVisible(cellRect);
            BladeDirectivesSettingsForm.this.myDirectiveNameTextField.requestFocusInWindow();
        }

        public void removeAll(Collection<InjectionDataEx> items) {
            if (items == null || items.size() == 0) {
                return;
            }
            for (InjectionDataEx item : items) {
                this.removeRow(this.indexOf(item));
            }
        }

        public void resetToDefaults() {
            BladeDirectivesSettingsForm.this.reset(BladeInjectionMappingService.getInstance(null));
        }
    }
}

