/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.psi;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.blade.psi.BladeDirectiveElementType;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BladeTokenSets {
    private static final IElementType[] DIRECTIVES_ARRAY = new IElementType[]{BladeTokenTypes.SECTION_DIRECTIVE, BladeTokenTypes.SECTION_MISSING_DIRECTIVE, BladeTokenTypes.SHOW_DIRECTIVE, BladeTokenTypes.YIELD_DIRECTIVE, BladeTokenTypes.EXTENDS_DIRECTIVE, BladeTokenTypes.EXTENDS_FIRST_DIRECTIVE, BladeTokenTypes.PARENT_DIRECTIVE, BladeTokenTypes.STOP_DIRECTIVE, BladeTokenTypes.IF_DIRECTIVE, BladeTokenTypes.ELSEIF_DIRECTIVE, BladeTokenTypes.ELSE_DIRECTIVE, BladeTokenTypes.ENDIF_DIRECTIVE, BladeTokenTypes.UNLESS_DIRECTIVE, BladeTokenTypes.ENDUNLESS_DIRECTIVE, BladeTokenTypes.FOR_DIRECTIVE, BladeTokenTypes.ENDFOR_DIRECTIVE, BladeTokenTypes.FOREACH_DIRECTIVE, BladeTokenTypes.ENDFOREACH_DIRECTIVE, BladeTokenTypes.WHILE_DIRECTIVE, BladeTokenTypes.ENDWHILE_DIRECTIVE, BladeTokenTypes.INCLUDE_DIRECTIVE, BladeTokenTypes.INCLUDE_IF_DIRECTIVE, BladeTokenTypes.INCLUDE_WHEN_DIRECTIVE, BladeTokenTypes.INCLUDE_UNLESS_DIRECTIVE, BladeTokenTypes.INCLUDE_FIRST_DIRECTIVE, BladeTokenTypes.OVERWRITE_DIRECTIVE, BladeTokenTypes.LANG_DIRECTIVE, BladeTokenTypes.ENDLANG_DIRECTIVE, BladeTokenTypes.CHOICE_DIRECTIVE, BladeTokenTypes.EACH_DIRECTIVE, BladeTokenTypes.APPEND_DIRECTIVE, BladeTokenTypes.ENDSECTION_DIRECTIVE, BladeTokenTypes.FORELSE_DIRECTIVE, BladeTokenTypes.EMPTY_DIRECTIVE, BladeTokenTypes.ENDEMPTY_DIRECTIVE, BladeTokenTypes.ENDFORELSE_DIRECTIVE, BladeTokenTypes.STACK_DIRECTIVE, BladeTokenTypes.PUSH_DIRECTIVE, BladeTokenTypes.ENDPUSH_DIRECTIVE, BladeTokenTypes.PREPEND_DIRECTIVE, BladeTokenTypes.ENDPREPEND_DIRECTIVE, BladeTokenTypes.UNSET_DIRECTIVE, BladeTokenTypes.PHP_DIRECTIVE, BladeTokenTypes.ENDPHP_DIRECTIVE, BladeTokenTypes.INJECT_DIRECTIVE, BladeTokenTypes.BREAK_DIRECTIVE, BladeTokenTypes.CONTINUE_DIRECTIVE, BladeTokenTypes.CAN_DIRECTIVE, BladeTokenTypes.ENDCAN_DIRECTIVE, BladeTokenTypes.CANNOT_DIRECTIVE, BladeTokenTypes.ENDCANNOT_DIRECTIVE, BladeTokenTypes.ELSECAN_DIRECTIVE, BladeTokenTypes.ELSECANNOT_DIRECTIVE, BladeTokenTypes.HASSECTION_DIRECTIVE, BladeTokenTypes.COMPONENT_DIRECTIVE, BladeTokenTypes.COMPONENT_FIRST_DIRECTIVE, BladeTokenTypes.ENDCOMPONENT_DIRECTIVE, BladeTokenTypes.ENDCOMPONENT_CLASS_DIRECTIVE, BladeTokenTypes.ENV_DIRECTIVE, BladeTokenTypes.ENDENV_DIRECTIVE, BladeTokenTypes.PRODUCTION_DIRECTIVE, BladeTokenTypes.ENDPRODUCTION_DIRECTIVE, BladeTokenTypes.ENDCOMPONENT_FIRST_DIRECTIVE, BladeTokenTypes.SLOT_DIRECTIVE, BladeTokenTypes.ENDSLOT_DIRECTIVE, BladeTokenTypes.VERBATIM_DIRECTIVE, BladeTokenTypes.ENDVERBATIM_DIRECTIVE, BladeTokenTypes.ISSET_DIRECTIVE, BladeTokenTypes.ENDISSET_DIRECTIVE, BladeTokenTypes.CASE_DIRECTIVE, BladeTokenTypes.DEFAULT_DIRECTIVE, BladeTokenTypes.SWITCH_DIRECTIVE, BladeTokenTypes.ENDSWITCH_DIRECTIVE, BladeTokenTypes.AUTH_DIRECTIVE, BladeTokenTypes.ELSE_AUTH_DIRECTIVE, BladeTokenTypes.ENDAUTH_DIRECTIVE, BladeTokenTypes.GUEST_DIRECTIVE, BladeTokenTypes.ELSE_GUEST_DIRECTIVE, BladeTokenTypes.ENDGUEST_DIRECTIVE, BladeTokenTypes.JSON_DIRECTIVE, BladeTokenTypes.DD_DIRECTIVE, BladeTokenTypes.DUMP_DIRECTIVE, BladeTokenTypes.CSRF_DIRECTIVE, BladeTokenTypes.METHOD_DIRECTIVE, BladeTokenTypes.CANANY_DIRECTIVE, BladeTokenTypes.ELSECANANY_DIRECTIVE, BladeTokenTypes.ENDCANANY_DIRECTIVE, BladeTokenTypes.ERROR_DIRECTIVE, BladeTokenTypes.ENDERROR_DIRECTIVE, BladeTokenTypes.ONCE_DIRECTIVE, BladeTokenTypes.ENDONCE_DIRECTIVE};
    private static final Map<String, BladeDirectiveElementType> myDirectiveTypes = Stream.of(DIRECTIVES_ARRAY).filter(t -> t instanceof BladeDirectiveElementType).map(t -> (BladeDirectiveElementType)((Object)t)).collect(Collectors.toMap(type -> BladeTokenSets.unifyDirectiveText(type.getText()), Function.identity()));
    public static final TokenSet TOKENS_TO_MERGE = TokenSet.create((IElementType[])new IElementType[]{BladeTokenTypes.COMMENT, BladeTokenTypes.WHITESPACE, BladeTokenTypes.TEMPLATE_HTML_TEXT, BladeTokenTypes.TEMPLATE_PHP_TEXT, BladeTokenTypes.TEXT_BLOCK_CONTENT, BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT});
    public static final TokenSet DIRECTIVES = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])BladeTokenSets.getDirectiveTypes()), TokenSet.create((IElementType[])new IElementType[]{BladeTokenTypes.CUSTOM_DIRECTIVE})});
    public static final TokenSet CLOSING_SECTION_DIRECTIVES = TokenSet.create((IElementType[])new IElementType[]{BladeTokenTypes.SHOW_DIRECTIVE, BladeTokenTypes.STOP_DIRECTIVE, BladeTokenTypes.OVERWRITE_DIRECTIVE, BladeTokenTypes.APPEND_DIRECTIVE, BladeTokenTypes.ENDSECTION_DIRECTIVE});

    private BladeTokenSets() {
    }

    public static BladeDirectiveElementType[] getDirectiveTypes() {
        Collection<BladeDirectiveElementType> values = myDirectiveTypes.values();
        return values.toArray(new BladeDirectiveElementType[0]);
    }

    @Nullable
    public static IElementType getDirectiveType(String directiveText) {
        return myDirectiveTypes.get(BladeTokenSets.unifyDirectiveText(directiveText));
    }

    @NotNull
    private static String unifyDirectiveText(String directiveText) {
        String string = StringUtil.toLowerCase((String)directiveText);
        if (string == null) {
            BladeTokenSets.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/blade/psi/BladeTokenSets", "unifyDirectiveText"));
    }
}

