/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.lang;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewModelBase;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.php.blade.psi.BladeDirectivePsiImpl;
import com.jetbrains.php.blade.psi.BladeFileImpl;
import com.jetbrains.php.blade.psi.BladePsiDirective;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import icons.BladeIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeStructureViewFactory
implements PsiStructureViewFactory {
    private static final Logger LOG = Logger.getInstance(BladeStructureViewFactory.class);
    private static final IElementType[] MY_FIRST_PARAMETER_DIRECTIVES = new IElementType[]{BladeTokenTypes.INCLUDE_DIRECTIVE, BladeTokenTypes.INCLUDE_IF_DIRECTIVE, BladeTokenTypes.INCLUDE_WHEN_DIRECTIVE, BladeTokenTypes.INCLUDE_UNLESS_DIRECTIVE, BladeTokenTypes.SECTION_DIRECTIVE, BladeTokenTypes.YIELD_DIRECTIVE, BladeTokenTypes.COMPONENT_DIRECTIVE, BladeTokenTypes.COMPONENT_FIRST_DIRECTIVE, BladeTokenTypes.SLOT_DIRECTIVE, BladeTokenTypes.PUSH_DIRECTIVE, BladeTokenTypes.STACK_DIRECTIVE, BladeTokenTypes.PREPEND_DIRECTIVE};
    private static final IElementType[] MY_DIRECTIVES_TO_SHOW = new IElementType[]{BladeTokenTypes.SECTION_DIRECTIVE, BladeTokenTypes.YIELD_DIRECTIVE, BladeTokenTypes.EXTENDS_DIRECTIVE, BladeTokenTypes.EXTENDS_FIRST_DIRECTIVE, BladeTokenTypes.INCLUDE_DIRECTIVE, BladeTokenTypes.INCLUDE_IF_DIRECTIVE, BladeTokenTypes.INCLUDE_WHEN_DIRECTIVE, BladeTokenTypes.INCLUDE_UNLESS_DIRECTIVE, BladeTokenTypes.INCLUDE_FIRST_DIRECTIVE, BladeTokenTypes.PARENT_DIRECTIVE, BladeTokenTypes.COMPONENT_DIRECTIVE, BladeTokenTypes.COMPONENT_FIRST_DIRECTIVE, BladeTokenTypes.SLOT_DIRECTIVE, BladeTokenTypes.PUSH_DIRECTIVE, BladeTokenTypes.STACK_DIRECTIVE, BladeTokenTypes.PREPEND_DIRECTIVE};

    @Nullable
    public StructureViewBuilder getStructureViewBuilder(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            BladeStructureViewFactory.$$$reportNull$$$0(0);
        }
        if (!(psiFile instanceof BladeFileImpl)) {
            return null;
        }
        final BladeFileImpl bladeFile = (BladeFileImpl)psiFile;
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                return new Model(bladeFile, editor);
            }
        };
    }

    private static boolean isComposite(@Nullable BladePsiDirective element) {
        if (element == null) {
            return false;
        }
        return element.isToBeClosed();
    }

    private static boolean isFirstParameterDirective(@Nullable BladePsiDirective element) {
        if (element == null) {
            return false;
        }
        IElementType type = element.getDirectiveElementType();
        return ArrayUtil.contains((Object)type, (Object[])MY_FIRST_PARAMETER_DIRECTIVES);
    }

    @NotNull
    private static String getPresentableDirectiveName(BladePsiDirective element) {
        if (element == null) {
            return "?";
        }
        String fullName = element.getName();
        if (fullName == null || fullName.length() < 2) {
            return "?";
        }
        String string = fullName.substring(1);
        if (string == null) {
            BladeStructureViewFactory.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String getPresentableDirectiveFirstParameter(BladePsiDirective element) {
        if (element == null) {
            return "?";
        }
        String name = BladeStructureViewFactory.getPresentableDirectiveName(element);
        String text = element.getText();
        Character quote = BladeDirectivePsiImpl.guessQuoteCharacter(text);
        if (quote == null) {
            String string = name + " (?)";
            if (string == null) {
                BladeStructureViewFactory.$$$reportNull$$$0(2);
            }
            return string;
        }
        int begin = text.indexOf(quote.charValue(), name.length());
        int end = text.indexOf(quote.charValue(), begin + 1);
        String parameter = end == -1 ? text.substring(begin + 1) : text.substring(begin + 1, end);
        String string = name + " (" + parameter + ")";
        if (string == null) {
            BladeStructureViewFactory.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/lang/BladeStructureViewFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/lang/BladeStructureViewFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableDirectiveName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableDirectiveFirstParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStructureViewBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class BladeElement<T extends PsiElement>
    extends PsiTreeElementBase<T> {
        protected BladeElement(T psiElement) {
            super(psiElement);
        }
    }

    private static final class DirectiveElement
    extends BladeElement<BladePsiDirective> {
        private final List<StructureViewTreeElement> myChildren = new ArrayList<StructureViewTreeElement>();
        private boolean isClosed = false;

        private DirectiveElement(BladePsiDirective element) {
            super(element);
            if (!element.isToBeClosed()) {
                this.isClosed = true;
            }
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            List<StructureViewTreeElement> list = this.myChildren;
            if (list == null) {
                DirectiveElement.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        public String getPresentableText() {
            if (BladeStructureViewFactory.isFirstParameterDirective((BladePsiDirective)this.getElement())) {
                String string = BladeStructureViewFactory.getPresentableDirectiveFirstParameter((BladePsiDirective)this.getElement());
                if (string == null) {
                    DirectiveElement.$$$reportNull$$$0(1);
                }
                return string;
            }
            String string = BladeStructureViewFactory.getPresentableDirectiveName((BladePsiDirective)this.getElement());
            if (string == null) {
                DirectiveElement.$$$reportNull$$$0(2);
            }
            return string;
        }

        public Icon getIcon(boolean open) {
            return BladeStructureViewFactory.isComposite((BladePsiDirective)this.getElement()) ? BladeIcons.Section : BladeIcons.Directive;
        }

        public void add(BladePsiDirective directive) {
            StructureViewTreeElement last;
            LOG.assertTrue(!this.isClosed());
            if (!this.myChildren.isEmpty() && (last = this.myChildren.get(this.myChildren.size() - 1)) instanceof DirectiveElement && !((DirectiveElement)last).isClosed()) {
                ((DirectiveElement)last).add(directive);
                return;
            }
            BladePsiDirective value = (BladePsiDirective)this.getValue();
            if (value != null && directive.closes(value)) {
                this.isClosed = true;
            }
            if (ArrayUtil.contains((Object)directive.getDirectiveElementType(), (Object[])MY_DIRECTIVES_TO_SHOW)) {
                this.myChildren.add((StructureViewTreeElement)new DirectiveElement(directive));
            }
        }

        public boolean isClosed() {
            return this.isClosed;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/php/blade/lang/BladeStructureViewFactory$DirectiveElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildrenBase";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static final class FileElement
    extends BladeElement<BladeFileImpl> {
        private FileElement(BladeFileImpl element) {
            super(element);
        }

        @Nullable
        public String getPresentableText() {
            BladeFileImpl element = (BladeFileImpl)this.getElement();
            if (element == null) {
                return "?";
            }
            return element.getName();
        }

        @NotNull
        public Collection<StructureViewTreeElement> getChildrenBase() {
            BladeFileImpl element = (BladeFileImpl)this.getElement();
            if (element == null) {
                List<StructureViewTreeElement> list = Collections.emptyList();
                if (list == null) {
                    FileElement.$$$reportNull$$$0(0);
                }
                return list;
            }
            ArrayList<StructureViewTreeElement> result = new ArrayList<StructureViewTreeElement>();
            DirectiveElement lastOpenElement = null;
            for (BladePsiDirective directive : element.getDirectives()) {
                if (lastOpenElement != null) {
                    lastOpenElement.add(directive);
                    if (!lastOpenElement.isClosed()) continue;
                    lastOpenElement = null;
                    continue;
                }
                if (!ArrayUtil.contains((Object)directive.getDirectiveElementType(), (Object[])MY_DIRECTIVES_TO_SHOW)) continue;
                DirectiveElement directiveElement = new DirectiveElement(directive);
                result.add((StructureViewTreeElement)directiveElement);
                if (directiveElement.isClosed()) continue;
                lastOpenElement = directiveElement;
            }
            ArrayList<StructureViewTreeElement> arrayList = result;
            if (arrayList == null) {
                FileElement.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/blade/lang/BladeStructureViewFactory$FileElement", "getChildrenBase"));
        }
    }

    private static final class Model
    extends StructureViewModelBase
    implements StructureViewModel.ElementInfoProvider {
        private static final Class[] SUITABLE_CLASSES = new Class[]{BladePsiDirective.class, BladeFileImpl.class};

        private Model(@NotNull BladeFileImpl psiFile, @Nullable Editor editor) {
            if (psiFile == null) {
                Model.$$$reportNull$$$0(0);
            }
            super((PsiFile)psiFile, editor, (StructureViewTreeElement)new FileElement(psiFile));
            this.withSuitableClasses(SUITABLE_CLASSES);
        }

        public boolean isAlwaysShowsPlus(StructureViewTreeElement element) {
            return !this.isAlwaysLeaf(element);
        }

        public boolean isAlwaysLeaf(StructureViewTreeElement element) {
            return element instanceof DirectiveElement && !BladeStructureViewFactory.isComposite((BladePsiDirective)((DirectiveElement)element).getElement());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/php/blade/lang/BladeStructureViewFactory$Model", "<init>"));
        }
    }
}

