/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.lang.PhpLanguage;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeDoubleInjectionInfo
extends BladeInjectionInfo {
    @NotNull
    private final String myMiddlePart;

    public BladeDoubleInjectionInfo(@NotNull String phpPrefix, @NotNull String phpMiddlePart, @NotNull String phpSuffix) {
        if (phpPrefix == null) {
            BladeDoubleInjectionInfo.$$$reportNull$$$0(0);
        }
        if (phpMiddlePart == null) {
            BladeDoubleInjectionInfo.$$$reportNull$$$0(1);
        }
        if (phpSuffix == null) {
            BladeDoubleInjectionInfo.$$$reportNull$$$0(2);
        }
        super(phpPrefix, phpSuffix, BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT);
        this.myMiddlePart = phpMiddlePart;
    }

    @Override
    public int getBladePrefixLength() {
        return "(".length();
    }

    @Override
    public int getBladeSuffixLength() {
        return ")".length();
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    @Nullable
    public String getUnmodifiablePresentableDescription() {
        return "(\"" + this.getPhpPrefix() + "\", \"" + this.myMiddlePart + "\", \"" + this.getPhpSuffix() + "\")";
    }

    @Override
    @Nullable
    public TextRange convertInjectedRangeToInnerVisible(BladePsiLanguageInjectionHost host, TextRange injected, int length, boolean showEmptyBorderIntersections) {
        int injectedTextLength = host.getTextLength() - this.getBladePrefixLength() - this.getBladeSuffixLength();
        if (injected.getEndOffset() < this.getPhpPrefix().length() || injected.getStartOffset() > this.getPhpPrefix().length() + injectedTextLength) {
            return null;
        }
        if (!(showEmptyBorderIntersections || injected.getEndOffset() != this.getPhpPrefix().length() && injected.getStartOffset() != this.getPhpPrefix().length() + injectedTextLength)) {
            return null;
        }
        int start = Math.max(injected.getStartOffset() - this.getPhpPrefix().length(), 0);
        int end = Math.min(injected.getEndOffset() - this.getPhpPrefix().length(), injected.getStartOffset() - this.getPhpPrefix().length() + injectedTextLength);
        return TextRange.create((int)(this.getBladePrefixLength() + start), (int)(this.getBladePrefixLength() + end));
    }

    @Override
    public void register(MultiHostRegistrar registrar, BladePsiLanguageInjectionHost host, PsiElement child) {
        int startOffsetInParent = child.getStartOffsetInParent();
        TextRange rangeInsideHost = new TextRange(startOffsetInParent, startOffsetInParent + child.getTextLength());
        String suffix = this.myMiddlePart + rangeInsideHost.substring(host.getText()) + this.getPhpSuffix();
        registrar.startInjecting((Language)PhpLanguage.INSTANCE).addPlace(this.getPhpPrefix(), suffix, (PsiLanguageInjectionHost)host, rangeInsideHost).doneInjecting();
    }

    @Override
    @NonNls
    public String toString() {
        return "BIIInfo{prefix='" + this.getPhpPrefix() + "', middlePart='" + this.myMiddlePart + "', suffix='" + this.getPhpSuffix() + "\\}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "phpPrefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "phpMiddlePart";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "phpSuffix";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/blade/injection/BladeDoubleInjectionInfo";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

