/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.highlighter;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.blade.highlighter.BladeHighlighter;
import com.jetbrains.php.blade.injection.BladeInjectingLexer;
import com.jetbrains.php.blade.psi.BladeTokenSets;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.lang.highlighter.PhpFileSyntaxHighlighter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeSyntaxHighlighter
extends SyntaxHighlighterBase
implements SyntaxHighlighter {
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();
    private static final PhpFileSyntaxHighlighter PHP_FILE_SYNTAX_HIGHLIGHTER = new PhpFileSyntaxHighlighter();
    private final Project myProject;

    public BladeSyntaxHighlighter(@Nullable Project project) {
        this.myProject = project;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new BladeInjectingLexer(this.myProject);
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey key = ATTRIBUTES.get(tokenType);
        if (key != null) {
            TextAttributesKey[] textAttributesKeyArray = BladeSyntaxHighlighter.pack((TextAttributesKey)BladeHighlighter.BACKGROUND, (TextAttributesKey)key);
            if (textAttributesKeyArray == null) {
                BladeSyntaxHighlighter.$$$reportNull$$$0(0);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = PHP_FILE_SYNTAX_HIGHLIGHTER.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            BladeSyntaxHighlighter.$$$reportNull$$$0(1);
        }
        return textAttributesKeyArray;
    }

    static {
        ATTRIBUTES.put(BladeTokenTypes.COMMENT, BladeHighlighter.COMMENT);
        BladeSyntaxHighlighter.fillMap(ATTRIBUTES, (TokenSet)BladeTokenSets.DIRECTIVES, (TextAttributesKey)BladeHighlighter.DIRECTIVE);
        ATTRIBUTES.put(BladeTokenTypes.DIRECTIVE_LBRACE, BladeHighlighter.DIRECTIVE);
        ATTRIBUTES.put(BladeTokenTypes.DIRECTIVE_RBRACE, BladeHighlighter.DIRECTIVE);
        ATTRIBUTES.put(BladeTokenTypes.TEXT_BLOCK_START, BladeHighlighter.TEXT_BLOCK_BOUNDARY);
        ATTRIBUTES.put(BladeTokenTypes.TEXT_BLOCK_END, BladeHighlighter.TEXT_BLOCK_BOUNDARY);
        ATTRIBUTES.put(BladeTokenTypes.RAW_TEXT_BLOCK_START, BladeHighlighter.TEXT_BLOCK_BOUNDARY);
        ATTRIBUTES.put(BladeTokenTypes.RAW_TEXT_BLOCK_END, BladeHighlighter.TEXT_BLOCK_BOUNDARY);
        ATTRIBUTES.put(BladeTokenTypes.ESCAPED_TEXT_BLOCK_START, BladeHighlighter.TEXT_BLOCK_BOUNDARY);
        ATTRIBUTES.put(BladeTokenTypes.ESCAPED_TEXT_BLOCK_END, BladeHighlighter.TEXT_BLOCK_BOUNDARY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/blade/highlighter/BladeSyntaxHighlighter", "getTokenHighlights"));
    }
}

