/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.formatter;

import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.blade.formatter.BladeDirectiveFormattingStack;
import com.jetbrains.php.blade.formatter.BladeDirectiveStructureBlock;
import com.jetbrains.php.blade.formatter.BladeLeafBlock;
import com.jetbrains.php.blade.formatter.BladeSectionContentBlock;
import com.jetbrains.php.blade.parser.BladeDirectiveStack;
import com.jetbrains.php.blade.parser.BladeElementTypes;
import com.jetbrains.php.blade.psi.BladePsiDirective;
import com.jetbrains.php.blade.psi.BladeTokenSets;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BladeSectionFormatHandler {
    private final List<Block> result;
    private List<Block> highLevelBlocks;
    private SectionBlockDescription currentSection;

    @NotNull
    static List<Block> patchBlocksWithSections(List<Block> blocks) {
        BladeSectionFormatHandler handler = new BladeSectionFormatHandler(blocks);
        List<Block> list = handler.getResult();
        if (list == null) {
            BladeSectionFormatHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    private BladeSectionFormatHandler(List<Block> blocks) {
        this.result = new ArrayList<Block>(blocks.size());
        this.highLevelBlocks = new ArrayList<Block>(blocks.size());
        for (Block block : blocks) {
            this.handleBlock(block);
        }
        if (this.currentSection != null) {
            this.currentSection.closeAndFlushBlocks(this.result, null);
        }
        BladeSectionFormatHandler.flushContentsIfNeeded(this.result, this.highLevelBlocks, false);
    }

    private void handleBlock(Block block) {
        ASTNode node;
        ASTNode childNode;
        if (block instanceof BladeLeafBlock && BladeElementTypes.DIRECTIVE == ((BladeLeafBlock)block).getNode().getElementType() && (childNode = (node = ((BladeLeafBlock)block).getNode()).getFirstChildNode()) != null) {
            boolean closingSection;
            IElementType type = childNode.getElementType();
            boolean openingSection = type == BladeTokenTypes.SECTION_DIRECTIVE;
            boolean bl = closingSection = !openingSection && BladeTokenSets.CLOSING_SECTION_DIRECTIVES.contains(type);
            if (openingSection) {
                PsiElement psiElement;
                if (this.currentSection != null) {
                    this.currentSection.closeAndFlushBlocks(this.result, null);
                }
                if ((psiElement = node.getPsi()) instanceof BladePsiDirective && BladeDirectiveStack.isInlinedSection((BladePsiDirective)psiElement)) {
                    this.currentSection = null;
                    this.highLevelBlocks.add(block);
                } else {
                    this.currentSection = new SectionBlockDescription(block);
                }
                BladeSectionFormatHandler.flushContentsIfNeeded(this.result, this.highLevelBlocks, false);
                this.highLevelBlocks = new ArrayList<Block>();
                return;
            }
            if (closingSection) {
                if (this.currentSection != null) {
                    this.currentSection.closeAndFlushBlocks(this.result, block);
                } else {
                    this.highLevelBlocks.add(block);
                }
                this.currentSection = null;
                return;
            }
        }
        if (this.currentSection != null) {
            this.currentSection.addContentBlock(block);
        } else {
            this.highLevelBlocks.add(block);
        }
    }

    public List<Block> getResult() {
        return this.result;
    }

    private static void flushContentsIfNeeded(List<Block> result, List<Block> sectionContents, boolean wrapWithSectionContent) {
        if (sectionContents != null && !sectionContents.isEmpty()) {
            List<Block> patchedContent = BladeDirectiveFormattingStack.patchBlocksWithStructureDirectives(sectionContents);
            if (wrapWithSectionContent) {
                BladeSectionContentBlock.flushToBladeSectionContentBlock(patchedContent, result);
            } else {
                result.addAll(patchedContent);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/blade/formatter/BladeSectionFormatHandler", "patchBlocksWithSections"));
    }

    private static final class SectionBlockDescription {
        private final List<Block> resultingBlocks = new ArrayList<Block>();
        private final List<Block> currentSectionContents = new ArrayList<Block>();

        private SectionBlockDescription(Block openingBlock) {
            this.resultingBlocks.add(openingBlock);
        }

        private void addContentBlock(Block block) {
            assert (!this.resultingBlocks.isEmpty());
            this.currentSectionContents.add(block);
        }

        private void closeAndFlushBlocks(List<Block> result, @Nullable Block closingBlock) {
            BladeSectionFormatHandler.flushContentsIfNeeded(this.resultingBlocks, this.currentSectionContents, true);
            if (closingBlock != null) {
                this.resultingBlocks.add(closingBlock);
            }
            BladeDirectiveStructureBlock.flushToBladeDirectiveStructureBlock(this.resultingBlocks, result);
        }
    }
}

