/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.formatter;

import com.intellij.formatting.Block;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import com.jetbrains.php.blade.formatter.BladeDirectiveStructureBlock;
import com.jetbrains.php.blade.formatter.BladeLeafBlock;
import com.jetbrains.php.blade.formatter.BladeSectionContentBlock;
import com.jetbrains.php.blade.parser.BladeDirectiveStructureData;
import com.jetbrains.php.blade.parser.BladeElementTypes;
import com.jetbrains.php.blade.psi.BladePsiDirective;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BladeDirectiveFormattingStack {
    private final Stack<BlockData> myDataStack = new Stack();
    private final List<Block> myResultingBlocks = new ArrayList<Block>();

    BladeDirectiveFormattingStack() {
    }

    static List<Block> patchBlocksWithStructureDirectives(List<? extends Block> contents) {
        BladeDirectiveFormattingStack stack = new BladeDirectiveFormattingStack();
        for (Block block : contents) {
            stack.addBlock(block);
        }
        return stack.flushBlocks();
    }

    private void addBlock(Block block) {
        IElementType type;
        ASTNode childNode;
        if (block instanceof BladeLeafBlock && BladeElementTypes.DIRECTIVE == ((BladeLeafBlock)block).getNode().getElementType() && (childNode = ((BladeLeafBlock)block).getNode().getFirstChildNode()) != null && this.addTypedBlock(type = childNode.getElementType(), childNode.getPsi(), block)) {
            return;
        }
        this.addContentBlock(block);
    }

    void addContentBlock(Block block) {
        if (this.myDataStack.isEmpty()) {
            this.myResultingBlocks.add(block);
        } else {
            ((BlockData)this.myDataStack.peek()).addContentBlock(block);
        }
    }

    private boolean addTypedBlock(IElementType type, @NotNull PsiElement element, Block block) {
        PsiElement parent;
        if (element == null) {
            BladeDirectiveFormattingStack.$$$reportNull$$$0(0);
        }
        if (!this.myDataStack.isEmpty()) {
            BlockData data = (BlockData)this.myDataStack.peek();
            if (data.isClosed(type)) {
                this.myDataStack.pop();
                BladeDirectiveStructureBlock.flushToBladeDirectiveStructureBlockToContent(data.flushResult(block), this);
                return true;
            }
            if (data.tryToContinue(type, block)) {
                return true;
            }
        }
        if ((parent = element.getParent()) instanceof BladePsiDirective && (BladeDirectiveStructureData.isContinued(type) || BladeDirectiveStructureData.isToBeClosed(type, (BladePsiDirective)parent))) {
            this.myDataStack.push((Object)new BlockData(type, block));
            return true;
        }
        return false;
    }

    private List<Block> flushBlocks() {
        ArrayList<Block> result = new ArrayList<Block>(this.myResultingBlocks);
        while (!this.myDataStack.isEmpty()) {
            BlockData data = (BlockData)this.myDataStack.pop();
            List<Block> blocks = data.flushResult(null);
            if (!this.myDataStack.isEmpty()) {
                BladeDirectiveStructureBlock.flushToBladeDirectiveStructureBlockToContent(blocks, this);
                continue;
            }
            BladeDirectiveStructureBlock.flushToBladeDirectiveStructureBlock(blocks, result);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/blade/formatter/BladeDirectiveFormattingStack", "addTypedBlock"));
    }

    private static final class BlockData {
        private final IElementType myType;
        private final Block myOpeningBlock;
        private final List<Block> myContentBlocks = new ArrayList<Block>();
        private BlockData myChildData;

        private BlockData(IElementType type, Block openingBlock) {
            this.myType = type;
            this.myOpeningBlock = openingBlock;
        }

        public boolean tryToContinue(@NotNull IElementType type, Block block) {
            if (type == null) {
                BlockData.$$$reportNull$$$0(0);
            }
            if (this.myChildData != null) {
                return this.myChildData.tryToContinue(type, block);
            }
            boolean continues = BladeDirectiveStructureData.continues(type, this.myType);
            if (continues) {
                this.myChildData = new BlockData(type, block);
            }
            return continues;
        }

        public void addContentBlock(Block block) {
            if (this.myChildData != null) {
                this.myChildData.addContentBlock(block);
            } else {
                this.myContentBlocks.add(block);
            }
        }

        public boolean isClosed(IElementType type) {
            if (this.myChildData != null) {
                return this.myChildData.isClosed(type);
            }
            return BladeDirectiveStructureData.closes(type, this.myType);
        }

        public List<Block> flushResult(@Nullable Block block) {
            ArrayList<Block> result = new ArrayList<Block>();
            result.add(this.myOpeningBlock);
            BladeSectionContentBlock.flushToBladeSectionContentBlock(this.myContentBlocks, result);
            if (this.myChildData != null) {
                result.addAll(this.myChildData.flushResult(block));
            } else if (block != null) {
                result.add(block);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/blade/formatter/BladeDirectiveFormattingStack$BlockData", "tryToContinue"));
        }
    }
}

