/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.blade.BladeFileType;
import com.jetbrains.php.blade.BladeLanguage;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.injection.BladeInjectionMappingService;
import com.jetbrains.php.blade.parser.BladeDirectiveStack;
import com.jetbrains.php.blade.parser.BladeDirectiveStructureData;
import com.jetbrains.php.blade.psi.BladeDirectivePsiImpl;
import com.jetbrains.php.blade.psi.BladePsiDirective;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladeTokenSets;
import com.jetbrains.php.completion.insert.PhpInsertHandlerUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeCompletionContributor
extends CompletionContributor {
    static final Key<Object> DIRECTIVE_LOOKUP_USER_DATA_MARKER_KEY = new Key("BLADE_DIRECTIVE_COMPLETION_LOOKUP_ELEMENT_MARKER");

    public BladeCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inVirtualFile((ElementPattern)PlatformPatterns.virtualFile().ofType((FileType)BladeFileType.INSTANCE))).andNot((ElementPattern)PlatformPatterns.psiElement().withLanguage(BladeLanguage.INSTANCE)), new BladeDirectiveCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withLanguage(BladeLanguage.INSTANCE)).withElementType(BladeTokenSets.DIRECTIVES), new BladeDirectiveCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withLanguage((Language)PhpLanguage.INSTANCE), new BladeIntroducedVariablesCompletionProvider());
    }

    private static PsiElement getElementToAllign(@Nullable PsiElement elementAtCaret) {
        if (elementAtCaret != null) {
            PsiElement parentOfParent;
            if (BladeDirectiveStructureData.CLOSING_DIRECTIVES.containsScalarValue((Object)elementAtCaret.getNode().getElementType()) || BladeDirectiveStructureData.CONTINUING_DIRECTIVES.containsScalarValue((Object)elementAtCaret.getNode().getElementType())) {
                return elementAtCaret;
            }
            PsiElement parent = elementAtCaret.getParent();
            PsiElement psiElement = parentOfParent = parent != null ? parent.getParent() : null;
            if (parentOfParent instanceof BladeDirectivePsiImpl && BladeDirectiveStructureData.CONTINUING_DIRECTIVES.containsScalarValue((Object)((BladeDirectivePsiImpl)parentOfParent).getDirectiveElementType())) {
                return parentOfParent;
            }
        }
        return null;
    }

    private static class BladeIntroducedVariablesCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private BladeIntroducedVariablesCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                BladeIntroducedVariablesCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                BladeIntroducedVariablesCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                BladeIntroducedVariablesCompletionProvider.$$$reportNull$$$0(2);
            }
            PsiElement originalPosition = parameters.getOriginalPosition();
            PsiFile originalFile = parameters.getOriginalFile();
            if (originalPosition == null || !InjectedLanguageManager.getInstance((Project)originalFile.getProject()).isInjectedFragment(originalFile)) {
                return;
            }
            PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)parameters.getEditor().getProject()).getInjectionHost(originalPosition);
            if (!(host instanceof BladePsiLanguageInjectionHost)) {
                return;
            }
            String prefix = result.getPrefixMatcher().getPrefix();
            if (prefix.startsWith("$")) {
                result = result.withPrefixMatcher(prefix.substring(1));
            }
            final CompletionResultSet finalResult = result;
            BladeDirectiveStack stack = new BladeDirectiveStack(){

                @Override
                protected void reportMissingOpeningProblem(BladePsiDirective directive) {
                }

                @Override
                protected void reportMissingClosingProblem(BladePsiDirective directive) {
                    Object[] dirVariables = BladeIntroducedVariablesCompletionProvider.collectVariableLookupElements(directive);
                    if (dirVariables != null) {
                        for (Object variable : dirVariables) {
                            finalResult.addElement((LookupElement)variable);
                        }
                    }
                }
            };
            stack.handleDirectivesBeforeElement((PsiElement)host);
        }

        private static Object @Nullable [] collectVariableLookupElements(BladePsiDirective element) {
            BladePsiLanguageInjectionHost injectionHost = (BladePsiLanguageInjectionHost)PsiTreeUtil.getChildOfType((PsiElement)element, BladePsiLanguageInjectionHost.class);
            if (injectionHost == null) {
                return null;
            }
            List files = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectedPsiFiles((PsiElement)injectionHost);
            if (files == null) {
                return null;
            }
            return VariableImpl.getVariableVariants((PsiElement)((PsiElement)((Pair)files.get((int)0)).first), (boolean)false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/blade/completion/BladeCompletionContributor$BladeIntroducedVariablesCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BladeDirectiveCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private BladeDirectiveCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                BladeDirectiveCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                BladeDirectiveCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                BladeDirectiveCompletionProvider.$$$reportNull$$$0(2);
            }
            Map<String, BladeInjectionInfo> infos = BladeInjectionMappingService.getInstance(parameters.getOriginalFile().getProject()).getDirectiveInfos();
            String prefix = result.getPrefixMatcher().getPrefix();
            boolean hasAt = prefix.startsWith("@");
            if (!hasAt) {
                PsiElement position = parameters.getPosition();
                int offsetInPosition = parameters.getOffset() - position.getTextRange().getStartOffset();
                if (offsetInPosition > prefix.length()) {
                    hasAt = position.getText().charAt(offsetInPosition - prefix.length() - 1) == '@';
                }
            }
            for (Map.Entry<String, BladeInjectionInfo> entry : infos.entrySet()) {
                LookupElementBuilder builder = BladeDirectiveCompletionProvider.createLookupBuilder(entry.getKey().substring(1), entry.getValue() != null, hasAt);
                result.addElement((LookupElement)builder);
            }
        }

        private static LookupElementBuilder createLookupBuilder(String s, final boolean isParametrized, final boolean hasAt) {
            InsertHandler<LookupElement> handler = new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    if (context == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (item == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!hasAt) {
                        context.getEditor().getDocument().insertString(context.getStartOffset(), (CharSequence)"@");
                    }
                    if (isParametrized) {
                        if (context.getCompletionChar() == '(') {
                            context.setAddCompletionChar(false);
                        }
                        if (!PhpInsertHandlerUtil.isStringAtCaret((Editor)context.getEditor(), (String)"(")) {
                            boolean isClosed = PhpInsertHandlerUtil.isStringAtCaret((Editor)context.getEditor(), (String)")");
                            PhpInsertHandlerUtil.insertStringAtCaret((Editor)context.getEditor(), (String)(isClosed ? "(" : "()"));
                            if (!isClosed) {
                                context.getEditor().getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
                            }
                        } else if (PhpInsertHandlerUtil.isStringAtCaret((Editor)context.getEditor(), (String)"()")) {
                            context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
                        } else {
                            context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
                            if (!PhpInsertHandlerUtil.isStringAtCaret((Editor)context.getEditor(), (String)")")) {
                                PhpInsertHandlerUtil.insertStringAtCaret((Editor)context.getEditor(), (String)")");
                                context.getEditor().getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
                            }
                        }
                    }
                    context.commitDocument();
                    PsiFile file = context.getFile();
                    PsiElement elementAtCaret = file.findElementAt(context.getEditor().getCaretModel().getOffset() - 1);
                    PsiElement elementToAllign = BladeCompletionContributor.getElementToAllign(elementAtCaret);
                    if (elementToAllign != null) {
                        CodeStyleManager.getInstance((Project)context.getProject()).adjustLineIndent(file, elementToAllign.getTextOffset());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "context";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "item";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/php/blade/completion/BladeCompletionContributor$BladeDirectiveCompletionProvider$1";
                    objectArray[2] = "handleInsert";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            LookupElementBuilder lookupElement = LookupElementBuilder.create((String)s).withBoldness(true).withPresentableText("@" + s).withInsertHandler((InsertHandler)handler);
            lookupElement.putUserData(DIRECTIVE_LOOKUP_USER_DATA_MARKER_KEY, new Object());
            return lookupElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/blade/completion/BladeCompletionContributor$BladeDirectiveCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

