/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.util;

import com.intellij.ui.JBColor;
import com.jetbrains.rd.ui.util.CIELabUtils;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a \u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"getContrastedForeground", "Ljava/awt/Color;", "background", "foreground", "getContrastedForegroundIfNotThemed", "addContrastToForegroundIfNeeded", "", "intellij.rd.ui"})
public final class ColorUtilsKt {
    @NotNull
    public static final Color getContrastedForegroundIfNotThemed(@NotNull Color background, @NotNull Color foreground, boolean addContrastToForegroundIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
        if (foreground instanceof JBColor || !addContrastToForegroundIfNeeded) {
            return foreground;
        }
        return ColorUtilsKt.getContrastedForeground(background, foreground);
    }

    public static /* synthetic */ Color getContrastedForegroundIfNotThemed$default(Color color, Color color2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return ColorUtilsKt.getContrastedForegroundIfNotThemed(color, color2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Color getContrastedForeground(@NotNull Color background, @NotNull Color foreground) {
        float fL;
        void bL;
        float[] fArray;
        float[] fArray2;
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
        float contrast = 0.45f;
        float margin = 0.02f;
        float whiteBalance = 0.66f;
        float[] fArray3 = foreground.getColorComponents(null);
        Intrinsics.checkNotNullExpressionValue((Object)fArray3, (String)"foreground.getColorComponents(null)");
        float[] fArray4 = fArray2 = CIELabUtils.INSTANCE.fromRGB(fArray3);
        boolean bl = false;
        float f = fArray4[0];
        fArray4 = fArray2;
        bl = false;
        float f2 = fArray4[1];
        fArray4 = fArray2;
        bl = false;
        float fB = fArray4[2];
        float[] fArray5 = background.getColorComponents(null);
        Intrinsics.checkNotNullExpressionValue((Object)fArray5, (String)"background.getColorComponents(null)");
        float[] fArray6 = fArray = CIELabUtils.INSTANCE.fromRGB(fArray5);
        boolean bl2 = false;
        float f3 = fArray6[0];
        fArray6 = fArray;
        bl2 = false;
        float f4 = fArray6[1];
        fArray6 = fArray;
        bl2 = false;
        float bB = fArray6[2];
        if (Math.abs((float)(bL - fL)) / 100.0f < contrast) {
            void g;
            void r;
            void fA;
            float[] fArray7;
            float lightness;
            fL = bL / 100.0f > whiteBalance ? (bL / 100.0f - (lightness = Math.min((float)(fL / 100.0f), margin)) < contrast ? lightness * 100.0f : (bL / 100.0f - contrast) * 100.0f) : ((lightness = Math.max((float)(fL / 100.0f), 1.0f - margin)) - bL / 100.0f < contrast ? lightness * 100.0f : (bL / 100.0f + contrast) * 100.0f);
            float[] fArray8 = fArray7 = CIELabUtils.INSTANCE.toRGB(new float[]{fL, fA, fB});
            boolean bl3 = false;
            lightness = fArray8[0];
            fArray8 = fArray7;
            bl3 = false;
            float f5 = fArray8[1];
            fArray8 = fArray7;
            bl3 = false;
            float b = fArray8[2];
            Color rgb = new Color((float)r, (float)g, b);
            int min = Math.min(Math.min(foreground.getRed(), foreground.getGreen()), foreground.getBlue());
            int max = Math.max(Math.max(foreground.getRed(), foreground.getGreen()), foreground.getBlue());
            if (max != min) {
                double redPortion = (double)(foreground.getRed() - min) / (double)(max - min);
                double greenPortion = (double)(foreground.getGreen() - min) / (double)(max - min);
                double bluePortion = (double)(foreground.getBlue() - min) / (double)(max - min);
                Integer[] sorted = new Integer[]{rgb.getRed(), rgb.getGreen(), rgb.getBlue()};
                Comparable[] comparableArray = sorted;
                boolean bl4 = false;
                ArraysKt.sort((Object[])comparableArray);
                min = (sorted[0] + sorted[1]) / 2;
                max = sorted[2];
                return new Color((int)(redPortion * (double)(max - min) + (double)min), (int)(greenPortion * (double)(max - min) + (double)min), (int)(bluePortion * (double)(max - min) + (double)min), foreground.getAlpha());
            }
            return new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), foreground.getAlpha());
        }
        return foreground;
    }
}

