/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.util;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rd/ui/util/CIELabUtils;", "", "()V", "xyz_D65", "", "LabtoXYZ", "lab", "RGBtoXYZ", "rgb", "XYZtoLab", "xyz", "XYZtoRGB", "f", "", "t", "fromRGB", "rgbvalue", "toRGB", "colorvalue", "intellij.rd.ui"})
public final class CIELabUtils {
    private static final float[] xyz_D65;
    @NotNull
    public static final CIELabUtils INSTANCE;

    @NotNull
    public final float[] fromRGB(@NotNull float[] rgbvalue) {
        Intrinsics.checkNotNullParameter((Object)rgbvalue, (String)"rgbvalue");
        return this.XYZtoLab(this.RGBtoXYZ(rgbvalue));
    }

    @NotNull
    public final float[] toRGB(@NotNull float[] colorvalue) {
        Intrinsics.checkNotNullParameter((Object)colorvalue, (String)"colorvalue");
        return this.XYZtoRGB(this.LabtoXYZ(colorvalue));
    }

    /*
     * WARNING - void declaration
     */
    private final float[] RGBtoXYZ(float[] rgb) {
        void gLinear;
        void rLinear;
        float[] fArray;
        float[] fArray2 = fArray = rgb;
        boolean bl = false;
        float f = fArray2[0];
        fArray2 = fArray;
        bl = false;
        float f2 = fArray2[1];
        fArray2 = fArray;
        bl = false;
        float bLinear = fArray2[2];
        void r = rLinear > 0.04045f ? (float)Math.pow(((double)rLinear + 0.055) / 1.055, 2.2) : rLinear / 12.92f;
        void g = gLinear > 0.04045f ? (float)Math.pow(((double)gLinear + 0.055) / 1.055, 2.2) : gLinear / 12.92f;
        float b = bLinear > 0.04045f ? (float)Math.pow(((double)bLinear + 0.055) / 1.055, 2.2) : bLinear / 12.92f;
        float x = r * 0.4124f + g * 0.3576f + b * 0.1805f;
        float y = r * 0.2126f + g * 0.7152f + b * 0.0722f;
        float z = r * 0.0193f + g * 0.1192f + b * 0.9505f;
        float f3 = x > 0.9505f ? 0.9505f : (x = x < 0.0f ? 0.0f : x);
        float f4 = y > 1.0f ? 1.0f : (y = y < 0.0f ? 0.0f : y);
        z = z > 1.089f ? 1.089f : (z < 0.0f ? 0.0f : z);
        return new float[]{x, y, z};
    }

    /*
     * WARNING - void declaration
     */
    private final float[] XYZtoLab(float[] xyz) {
        void X;
        void x;
        void Y;
        void y;
        float[] fArray;
        float[] fArray2;
        float[] fArray3 = fArray2 = xyz;
        boolean bl = false;
        float f = fArray3[0];
        fArray3 = fArray2;
        bl = false;
        float f2 = fArray3[1];
        fArray3 = fArray2;
        bl = false;
        float z = fArray3[2];
        float[] fArray4 = fArray = xyz_D65;
        boolean bl2 = false;
        float f3 = fArray4[0];
        fArray4 = fArray;
        bl2 = false;
        float f4 = fArray4[1];
        fArray4 = fArray;
        bl2 = false;
        float Z = fArray4[2];
        return new float[]{116.0f * this.f((float)(y / Y)) - (float)16, 500.0f * (this.f((float)(x / X)) - this.f((float)(y / Y))), 200.0f * (this.f((float)(y / Y)) - this.f(z / Z))};
    }

    /*
     * WARNING - void declaration
     */
    private final float[] LabtoXYZ(float[] lab) {
        float z;
        void Y;
        void X;
        float[] fArray;
        void a;
        void l;
        float[] fArray2;
        float theta = 0.20689656f;
        float[] fArray3 = fArray2 = lab;
        boolean bl = false;
        float f = fArray3[0];
        fArray3 = fArray2;
        bl = false;
        float f2 = fArray3[1];
        fArray3 = fArray2;
        bl = false;
        float b = fArray3[2];
        void fy = (l + 16.0f) / 116.0f;
        void fx = fy + a / 500.0f;
        void fz = fy - b / 200.0f;
        float[] fArray4 = fArray = xyz_D65;
        boolean bl2 = false;
        float f3 = fArray4[0];
        fArray4 = fArray;
        bl2 = false;
        float f4 = fArray4[1];
        fArray4 = fArray;
        bl2 = false;
        float Z = fArray4[2];
        float x = fx > theta ? X * (fx * fx * fx) : (fx - 0.13793103f) * (float)3 * (theta * theta) * X;
        float y = fy > theta ? Y * (fy * fy * fy) : (fy - 0.13793103f) * (float)3 * (theta * theta) * Y;
        float f5 = z = fz > theta ? Z * (fz * fz * fz) : (fz - 0.13793103f) * (float)3 * (theta * theta) * Z;
        float f6 = x > 0.9505f ? 0.9505f : (x = x < 0.0f ? 0.0f : x);
        float f7 = y > 1.0f ? 1.0f : (y = y < 0.0f ? 0.0f : y);
        z = z > 1.089f ? 1.089f : (z < 0.0f ? 0.0f : z);
        return new float[]{x, y, z};
    }

    /*
     * WARNING - void declaration
     */
    private final float[] XYZtoRGB(float[] xyz) {
        void y;
        void x;
        float[] fArray;
        float[] fArray2 = fArray = xyz;
        int n = 0;
        float f = fArray2[0];
        fArray2 = fArray;
        n = 0;
        float f2 = fArray2[1];
        fArray2 = fArray;
        n = 0;
        float z = fArray2[2];
        float[] cLinear = new float[]{x * 3.241f - y * 1.5374f - z * 0.4986f, -x * 0.9692f + y * 1.876f + z * 0.0416f, x * 0.0556f - y * 0.204f + z * 1.057f};
        int n2 = 0;
        n = 2;
        while (n2 <= n) {
            void i;
            float f3 = cLinear[i] = cLinear[i] <= 0.0031308f ? 12.92f * cLinear[i] : 1.055f * (float)Math.pow(cLinear[i], 0.45454545454545453) - 0.055f;
            if (cLinear[i] > 1.0f) {
                cLinear[i] = 1.0f;
            }
            if (cLinear[i] < 0.0f) {
                cLinear[i] = 0.0f;
            }
            ++i;
        }
        return cLinear;
    }

    private final float f(float t) {
        return t > 0.008856f ? (float)Math.pow(t, 0.3333333333333333) : 7.787f * t + 0.13793103f;
    }

    private CIELabUtils() {
    }

    static {
        CIELabUtils cIELabUtils;
        INSTANCE = cIELabUtils = new CIELabUtils();
        xyz_D65 = new float[]{0.9505f, 1.0f, 1.089f};
    }
}

