/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.PaintingParent;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.Alarm;
import com.intellij.util.IconUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ide.model.RotatedIconModel;
import com.jetbrains.rd.ui.icons.IconWrapper;
import com.jetbrains.rd.ui.icons.RdIconHost;
import com.jetbrains.rd.ui.icons.RotatedIconWrapper;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ImageObserver;
import java.util.LinkedHashSet;
import java.util.concurrent.ExecutorService;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\nB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rd/ui/icons/RotatedIconWrapper;", "Lcom/jetbrains/rd/ui/icons/IconWrapper;", "iconNode", "Lcom/jetbrains/rd/ide/model/RotatedIconModel;", "iconHost", "Lcom/jetbrains/rd/ui/icons/RdIconHost;", "(Lcom/jetbrains/rd/ide/model/RotatedIconModel;Lcom/jetbrains/rd/ui/icons/RdIconHost;)V", "myStaticIcon", "Ljavax/swing/Icon;", "createIcon", "RotatedIcon", "intellij.rd.ui"})
public final class RotatedIconWrapper
implements IconWrapper {
    private final Icon myStaticIcon;

    @Override
    @NotNull
    public Icon createIcon() {
        return new RotatedIcon(this.myStaticIcon, 0, 0, 6, null);
    }

    public RotatedIconWrapper(@NotNull RotatedIconModel iconNode, @NotNull RdIconHost iconHost) {
        Intrinsics.checkNotNullParameter((Object)iconNode, (String)"iconNode");
        Intrinsics.checkNotNullParameter((Object)((Object)iconHost), (String)"iconHost");
        this.myStaticIcon = iconHost.createWrapper(iconNode.getStaticNode()).createIcon();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J*\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\"\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rd/ui/icons/RotatedIconWrapper$RotatedIcon;", "Ljavax/swing/Icon;", "staticIcon", "speedFactor", "", "direction", "(Ljavax/swing/Icon;II)V", "getDirection", "()I", "getSpeedFactor", "getStaticIcon", "()Ljavax/swing/Icon;", "getIconHeight", "getIconWidth", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "requestRepaint", "Companion", "RepaintRequest", "RepaintScheduler", "intellij.rd.ui"})
    public static final class RotatedIcon
    implements Icon {
        @NotNull
        private final Icon staticIcon;
        private final int speedFactor;
        private final int direction;
        private static final RepaintScheduler ourRepaintScheduler;
        private static final ExecutorService ourIconsCalculatingExecutor;
        private static final TransferToEDTQueue<Runnable> ourLaterInvocator;
        @NotNull
        public static final Companion Companion;

        @Override
        public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            long time = System.nanoTime() / (long)1000 / (long)1000 / (long)this.speedFactor;
            double angle = Math.toRadians(time % (long)360) * (double)this.direction;
            RotatedIcon.Companion.paintRotatedIcon(this.staticIcon, c, g, x, y, angle);
            this.requestRepaint(c, x, y);
        }

        private final void requestRepaint(Component c, int x, int y) {
            if (c == null) {
                return;
            }
            Component target = RotatedIcon.Companion.getTarget(c);
            Container paintingParent = SwingUtilities.getAncestorOfClass(PaintingParent.class, c);
            Rectangle paintingParentRec = paintingParent == null ? null : ((PaintingParent)paintingParent).getChildRec(c);
            ourIconsCalculatingExecutor.execute(new Runnable(target, paintingParent, paintingParentRec){
                final /* synthetic */ Component $target;
                final /* synthetic */ Container $paintingParent;
                final /* synthetic */ Rectangle $paintingParentRec;

                public final void run() {
                    RotatedIcon.access$getOurLaterInvocator$cp().offer((Object)new Runnable(this){
                        final /* synthetic */ requestRepaint.1 this$0;

                        public final void run() {
                            Component actualTarget = this.this$0.$target;
                            if (actualTarget != null && SwingUtilities.getWindowAncestor(actualTarget) == null && ((actualTarget = (Component)this.this$0.$paintingParent) == null || SwingUtilities.getWindowAncestor(actualTarget) == null)) {
                                actualTarget = null;
                            }
                            if (actualTarget == null) {
                                return;
                            }
                            RotatedIcon.access$getOurRepaintScheduler$cp().pushDirtyComponent(actualTarget, this.this$0.$paintingParentRec);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.$target = component;
                    this.$paintingParent = container;
                    this.$paintingParentRec = rectangle;
                }
            });
        }

        @Override
        public int getIconWidth() {
            return this.staticIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.staticIcon.getIconHeight();
        }

        @NotNull
        public final Icon getStaticIcon() {
            return this.staticIcon;
        }

        public final int getSpeedFactor() {
            return this.speedFactor;
        }

        public final int getDirection() {
            return this.direction;
        }

        public RotatedIcon(@NotNull Icon staticIcon, int speedFactor, int direction) {
            Intrinsics.checkNotNullParameter((Object)staticIcon, (String)"staticIcon");
            this.staticIcon = staticIcon;
            this.speedFactor = speedFactor;
            this.direction = direction;
        }

        public /* synthetic */ RotatedIcon(Icon icon, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n = 5;
            }
            if ((n3 & 4) != 0) {
                n2 = 1;
            }
            this(icon, n, n2);
        }

        static {
            Companion = new Companion(null);
            ourRepaintScheduler = new RepaintScheduler();
            ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"IconsCalculatingExecutor", (int)1);
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"AppExecutorUtil.createBo\u2026sCalculatingExecutor\", 1)");
            ourIconsCalculatingExecutor = executorService;
            ourLaterInvocator = TransferToEDTQueue.createRunnableMerger((String)"Rotated icon later invocator", (int)200);
        }

        public static final /* synthetic */ TransferToEDTQueue access$getOurLaterInvocator$cp() {
            return ourLaterInvocator;
        }

        public static final /* synthetic */ RepaintScheduler access$getOurRepaintScheduler$cp() {
            return ourRepaintScheduler;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rd/ui/icons/RotatedIconWrapper$RotatedIcon$RepaintScheduler;", "", "()V", "myAlarm", "Lcom/intellij/util/Alarm;", "myQueue", "Ljava/util/LinkedHashSet;", "Lcom/jetbrains/rd/ui/icons/RotatedIconWrapper$RotatedIcon$RepaintRequest;", "pushDirtyComponent", "", "c", "Ljava/awt/Component;", "rec", "Ljava/awt/Rectangle;", "intellij.rd.ui"})
        private static final class RepaintScheduler {
            private final Alarm myAlarm = new Alarm();
            private final LinkedHashSet<RepaintRequest> myQueue = new LinkedHashSet();

            public final void pushDirtyComponent(@NotNull Component c, @Nullable Rectangle rec) {
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                ApplicationManager.getApplication().assertIsDispatchThread();
                this.myAlarm.cancelAllRequests();
                this.myAlarm.addRequest(new Runnable(this){
                    final /* synthetic */ RepaintScheduler this$0;

                    public final void run() {
                        for (RepaintRequest request : RepaintScheduler.access$getMyQueue$p(this.this$0)) {
                            Rectangle r = request.getRectangle();
                            if (r == null) {
                                request.getComponent().repaint();
                                continue;
                            }
                            request.getComponent().repaint(r.x, r.y, r.width, r.height);
                        }
                        RepaintScheduler.access$getMyQueue$p(this.this$0).clear();
                    }
                    {
                        this.this$0 = repaintScheduler;
                    }
                }, 50);
                this.myQueue.add(new RepaintRequest(c, rec));
            }

            public static final /* synthetic */ LinkedHashSet access$getMyQueue$p(RepaintScheduler $this) {
                return $this.myQueue;
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rd/ui/icons/RotatedIconWrapper$RotatedIcon$RepaintRequest;", "", "component", "Ljava/awt/Component;", "rectangle", "Ljava/awt/Rectangle;", "(Ljava/awt/Component;Ljava/awt/Rectangle;)V", "getComponent", "()Ljava/awt/Component;", "getRectangle", "()Ljava/awt/Rectangle;", "intellij.rd.ui"})
        private static final class RepaintRequest {
            @NotNull
            private final Component component;
            @Nullable
            private final Rectangle rectangle;

            @NotNull
            public final Component getComponent() {
                return this.component;
            }

            @Nullable
            public final Rectangle getRectangle() {
                return this.rectangle;
            }

            public RepaintRequest(@NotNull Component component, @Nullable Rectangle rectangle) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                this.component = component;
                this.rectangle = rectangle;
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J6\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rd/ui/icons/RotatedIconWrapper$RotatedIcon$Companion;", "", "()V", "ourIconsCalculatingExecutor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "ourLaterInvocator", "Lcom/intellij/util/containers/TransferToEDTQueue;", "Ljava/lang/Runnable;", "kotlin.jvm.PlatformType", "ourRepaintScheduler", "Lcom/jetbrains/rd/ui/icons/RotatedIconWrapper$RotatedIcon$RepaintScheduler;", "getTarget", "Ljava/awt/Component;", "c", "paintRotatedIcon", "", "Ljavax/swing/Icon;", "g", "Ljava/awt/Graphics;", "x", "", "y", "angle", "", "intellij.rd.ui"})
        public static final class Companion {
            private final Component getTarget(Component c) {
                Container list2 = SwingUtilities.getAncestorOfClass(JList.class, c);
                if (list2 != null) {
                    return list2;
                }
                Container tree2 = SwingUtilities.getAncestorOfClass(JTree.class, c);
                if (tree2 != null) {
                    return tree2;
                }
                Container table2 = SwingUtilities.getAncestorOfClass(JTable.class, c);
                if (table2 != null) {
                    return table2;
                }
                Container box = SwingUtilities.getAncestorOfClass(JComboBox.class, c);
                if (box != null) {
                    return box;
                }
                Container tabLabel = SwingUtilities.getAncestorOfClass(TabLabel.class, c);
                if (tabLabel != null) {
                    return tabLabel;
                }
                return c;
            }

            private final void paintRotatedIcon(Icon $this$paintRotatedIcon, Component c, Graphics g, int x, int y, double angle) {
                double cx = (double)x + (double)$this$paintRotatedIcon.getIconWidth() / 2.0;
                double cy = (double)y + (double)$this$paintRotatedIcon.getIconHeight() / 2.0;
                Graphics graphics = g.create();
                if (graphics == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
                }
                Graphics2D gg = (Graphics2D)graphics;
                gg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                gg.rotate(angle, cx, cy);
                UIUtil.drawImage((Graphics)gg, (Image)IconUtil.toImage((Icon)$this$paintRotatedIcon), (int)x, (int)y, (ImageObserver)c);
                gg.dispose();
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

