/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views.utils;

import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.jetbrains.ide.model.uiautomation.BeControlSize;
import com.jetbrains.ide.model.uiautomation.BeControlSizeCustom;
import com.jetbrains.ide.model.uiautomation.BeControlSizePredefined;
import com.jetbrains.ide.model.uiautomation.BeControlSizeProportional;
import com.jetbrains.ide.model.uiautomation.BeControlSizeType;
import com.jetbrains.ide.model.uiautomation.BeMargin;
import com.jetbrains.ide.model.uiautomation.BeMarginItem;
import com.jetbrains.ide.model.uiautomation.BeMarginType;
import com.jetbrains.rd.ui.bindable.views.utils.MarginType;
import com.jetbrains.rd.ui.bindable.views.utils.MarginTypesKt;
import com.jetbrains.rd.ui.bindable.views.utils.MarginTypesKt$WhenMappings;
import java.awt.Dimension;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0012\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 \u001a\u0016\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\"*\u00020\u001e\u001a\u0012\u0010!\u001a\u00020#*\u00020\u001e2\u0006\u0010$\u001a\u00020#\u001a\n\u0010%\u001a\u00020\u000b*\u00020&\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0014\u0010\u0006\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0014\u0010\b\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u001b\u0010\n\u001a\u00020\u000b8@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\"\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"DEFAULT_HORIZONTAL", "Lcom/jetbrains/rd/ui/bindable/views/utils/MarginType;", "getDEFAULT_HORIZONTAL", "()Lcom/jetbrains/rd/ui/bindable/views/utils/MarginType;", "DEFAULT_NONE", "getDEFAULT_NONE", "DEFAULT_SPAN", "getDEFAULT_SPAN", "DEFAULT_VERTICAL", "getDEFAULT_VERTICAL", "checkboxMarginSize", "", "getCheckboxMarginSize", "()I", "checkboxMarginSize$delegate", "Lkotlin/Lazy;", "intercellSpacing", "marginItemToString", "", "item", "Lcom/jetbrains/ide/model/uiautomation/BeMarginItem;", "marginToMig", "margin", "Lcom/jetbrains/ide/model/uiautomation/BeMargin;", "marginTypeToPx", "type", "Lcom/jetbrains/ide/model/uiautomation/BeMarginType;", "marginTypeToString", "applyToContent", "", "Lcom/jetbrains/ide/model/uiautomation/BeControlSize;", "content", "Ljavax/swing/JComponent;", "getSize", "Lkotlin/Pair;", "Ljava/awt/Dimension;", "dimension", "toSwing", "Lcom/jetbrains/ide/model/uiautomation/BeControlSizeType;", "intellij.rd.ui"})
public final class MarginTypesKt {
    @NotNull
    private static final Lazy checkboxMarginSize$delegate = LazyKt.lazy((Function0)checkboxMarginSize.2.INSTANCE);
    private static int intercellSpacing = 5;
    @NotNull
    private static final MarginType DEFAULT_VERTICAL = new MarginType(0, 0, 0, intercellSpacing);
    @NotNull
    private static final MarginType DEFAULT_HORIZONTAL = new MarginType(0, 0, intercellSpacing, 0);
    @NotNull
    private static final MarginType DEFAULT_SPAN = new MarginType(0, 0, intercellSpacing, intercellSpacing);
    @NotNull
    private static final MarginType DEFAULT_NONE = new MarginType(0, 0, 0, 0);

    public static final int getCheckboxMarginSize() {
        Lazy lazy = checkboxMarginSize$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public static final MarginType getDEFAULT_VERTICAL() {
        return DEFAULT_VERTICAL;
    }

    @NotNull
    public static final MarginType getDEFAULT_HORIZONTAL() {
        return DEFAULT_HORIZONTAL;
    }

    @NotNull
    public static final MarginType getDEFAULT_SPAN() {
        return DEFAULT_SPAN;
    }

    @NotNull
    public static final MarginType getDEFAULT_NONE() {
        return DEFAULT_NONE;
    }

    public static final int marginTypeToPx(@NotNull BeMarginType type) {
        int n;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (MarginTypesKt$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = MarginTypesKt.getCheckboxMarginSize();
                break;
            }
            case 4: {
                n = MarginTypesKt.getCheckboxMarginSize();
                break;
            }
            case 5: {
                n = 0;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            case 7: {
                n = 20;
                break;
            }
            case 8: {
                n = 2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @NotNull
    public static final String marginItemToString(@NotNull BeMarginItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return MarginTypesKt.marginTypeToPx(item.getUnit()) * item.getMultiplier() + "px";
    }

    @NotNull
    public static final String marginTypeToString(@NotNull BeMarginType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return MarginTypesKt.marginTypeToPx(type) + "px";
    }

    @Nullable
    public static final String marginToMig(@NotNull BeMargin margin) {
        Intrinsics.checkNotNullParameter((Object)margin, (String)"margin");
        BeMarginItem left = margin.getLeft();
        BeMarginItem right = margin.getRight();
        BeMarginItem top = margin.getTop();
        BeMarginItem bottom = margin.getBottom();
        return "gap " + MarginTypesKt.marginItemToString(left) + ' ' + MarginTypesKt.marginItemToString(right) + ' ' + MarginTypesKt.marginItemToString(top) + ' ' + MarginTypesKt.marginItemToString(bottom) + ' ';
    }

    public static final void applyToContent(@NotNull BeControlSize $this$applyToContent, @NotNull JComponent content2) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToContent, (String)"$this$applyToContent");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        Dimension dimension = content2.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"content.preferredSize");
        content2.setPreferredSize(MarginTypesKt.getSize($this$applyToContent, dimension));
    }

    public static final int toSwing(@NotNull BeControlSizeType $this$toSwing) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$toSwing, (String)"$this$toSwing");
        switch (MarginTypesKt$WhenMappings.$EnumSwitchMapping$1[$this$toSwing.ordinal()]) {
            case 1: {
                n = 100;
                break;
            }
            case 2: {
                n = 200;
                break;
            }
            case 3: {
                n = 300;
                break;
            }
            case 4: {
                n = 400;
                break;
            }
            case 5: {
                n = 500;
                break;
            }
            case 6: {
                n = 800;
                break;
            }
            case 7: {
                n = -1;
                break;
            }
            case 8: {
                n = 600;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return JBUI.scale((int)n);
    }

    @NotNull
    public static final Pair<Integer, Integer> getSize(@NotNull BeControlSize $this$getSize) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)$this$getSize, (String)"$this$getSize");
        int resultWidth = -1;
        int resultHeight = -1;
        BeControlSize beControlSize = $this$getSize;
        if (beControlSize instanceof BeControlSizePredefined) {
            int localHeight;
            int localWidth = MarginTypesKt.toSwing(((BeControlSizePredefined)$this$getSize).getWidth().getType());
            if (localWidth >= 0) {
                resultWidth = localWidth * ((BeControlSizePredefined)$this$getSize).getWidth().getMultiplier();
            }
            if ((localHeight = MarginTypesKt.toSwing(((BeControlSizePredefined)$this$getSize).getHeight().getType())) >= 0) {
                resultHeight = localHeight * ((BeControlSizePredefined)$this$getSize).getHeight().getMultiplier();
            }
            pair = new Pair((Object)resultWidth, (Object)resultHeight);
        } else if (beControlSize instanceof BeControlSizeCustom) {
            pair = new Pair((Object)((BeControlSizeCustom)$this$getSize).getWidth(), (Object)((BeControlSizeCustom)$this$getSize).getHeight());
        } else if (beControlSize instanceof BeControlSizeProportional) {
            int baseSize = MarginTypesKt.toSwing(((BeControlSizeProportional)$this$getSize).getSize());
            pair = ((BeControlSizeProportional)$this$getSize).getProportion() < 1.0f ? new Pair((Object)baseSize, (Object)((int)((float)baseSize / ((BeControlSizeProportional)$this$getSize).getProportion()))) : new Pair((Object)((int)((float)baseSize * ((BeControlSizeProportional)$this$getSize).getProportion())), (Object)baseSize);
        } else {
            pair = new Pair((Object)resultWidth, (Object)resultHeight);
        }
        return pair;
    }

    @NotNull
    public static final Dimension getSize(@NotNull BeControlSize $this$getSize, @NotNull Dimension dimension) {
        Dimension dimension2;
        Intrinsics.checkNotNullParameter((Object)$this$getSize, (String)"$this$getSize");
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        BeControlSize beControlSize = $this$getSize;
        if (beControlSize instanceof BeControlSizePredefined) {
            int localHeight;
            Dimension localSize = dimension;
            int localWidth = MarginTypesKt.toSwing(((BeControlSizePredefined)$this$getSize).getWidth().getType());
            if (localWidth >= 0) {
                localSize.width = localWidth * ((BeControlSizePredefined)$this$getSize).getWidth().getMultiplier();
            }
            if ((localHeight = MarginTypesKt.toSwing(((BeControlSizePredefined)$this$getSize).getHeight().getType())) >= 0) {
                localSize.height = localHeight * ((BeControlSizePredefined)$this$getSize).getHeight().getMultiplier();
            }
            dimension2 = localSize;
        } else if (beControlSize instanceof BeControlSizeCustom) {
            JBDimension jBDimension = JBUI.size((int)((BeControlSizeCustom)$this$getSize).getWidth(), (int)((BeControlSizeCustom)$this$getSize).getHeight());
            Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"JBUI.size(width, height)");
            dimension2 = (Dimension)jBDimension;
        } else if (beControlSize instanceof BeControlSizeProportional) {
            Dimension dimension3;
            int baseSize = MarginTypesKt.toSwing(((BeControlSizeProportional)$this$getSize).getSize());
            dimension2 = dimension3 = ((BeControlSizeProportional)$this$getSize).getProportion() < 1.0f ? new Dimension(baseSize, (int)((float)baseSize / ((BeControlSizeProportional)$this$getSize).getProportion())) : new Dimension((int)((float)baseSize * ((BeControlSizeProportional)$this$getSize).getProportion()), baseSize);
        } else {
            dimension2 = dimension;
        }
        return dimension2;
    }
}

