/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views.listControl.utils;

import com.jetbrains.rd.platform.util.TreeTraverse;
import com.jetbrains.rd.ui.bindable.views.listControl.utils.SwingTreeUtilsKt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b*\u00020\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\r"}, d2={"getDeepestRendererComponentByEvent", "Ljavax/swing/JComponent;", "container", "Ljava/awt/Container;", "rendererComponent", "Ljava/awt/Component;", "nodeBounds", "Ljava/awt/Rectangle;", "e", "Ljava/awt/event/MouseEvent;", "pathToRoot", "Lkotlin/sequences/Sequence;", "root", "intellij.rd.ui"})
public final class SwingTreeUtilsKt {
    @Nullable
    public static final JComponent getDeepestRendererComponentByEvent(@NotNull Container container, @NotNull Component rendererComponent, @NotNull Rectangle nodeBounds, @NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)rendererComponent, (String)"rendererComponent");
        Intrinsics.checkNotNullParameter((Object)nodeBounds, (String)"nodeBounds");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        container.add(rendererComponent);
        int shiftedXBound = nodeBounds.width > 0 ? nodeBounds.x + 1 : nodeBounds.x;
        int shiftedWidth = nodeBounds.width > 0 ? nodeBounds.width - 1 : nodeBounds.width;
        rendererComponent.setBounds(shiftedXBound, nodeBounds.y, shiftedWidth, nodeBounds.height);
        rendererComponent.validate();
        Point componentPoint = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), rendererComponent);
        Component component = SwingUtilities.getDeepestComponentAt(rendererComponent, componentPoint.x, componentPoint.y);
        if (!(component instanceof JComponent)) {
            component = null;
        }
        JComponent activeComponent = (JComponent)component;
        container.remove(rendererComponent);
        return activeComponent;
    }

    @NotNull
    public static final Sequence<Component> pathToRoot(@NotNull Component $this$pathToRoot, @Nullable Component root) {
        Intrinsics.checkNotNullParameter((Object)$this$pathToRoot, (String)"$this$pathToRoot");
        return SequencesKt.takeWhile((Sequence)TreeTraverse.INSTANCE.pathToRoot((Object)$this$pathToRoot, (Function1)pathToRoot.1.INSTANCE), (Function1)((Function1)new Function1<Component, Boolean>(root){
            final /* synthetic */ Component $root;

            public final boolean invoke(@NotNull Component it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it, (Object)this.$root) ^ true;
            }
            {
                this.$root = component;
                super(1);
            }
        }));
    }

    public static /* synthetic */ Sequence pathToRoot$default(Component component, Component component2, int n, Object object) {
        if ((n & 1) != 0) {
            component2 = null;
        }
        return SwingTreeUtilsKt.pathToRoot(component, component2);
    }
}

