/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views.listControl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.BeCheckbox;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeTreeGrid;
import com.jetbrains.ide.model.uiautomation.ControlVisibility;
import com.jetbrains.rd.ui.bedsl.extensions.BeGetterExtensionsKt;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.ui.bedsl.extensions.UpdateFlag;
import com.jetbrains.rd.ui.bindable.views.listControl.BeTree;
import com.jetbrains.rd.ui.bindable.views.listControl.BeTreeAndTableExtensionsKt;
import com.jetbrains.rd.ui.bindable.views.listControl.BeTreeAndTableListenersKt;
import com.jetbrains.rd.ui.bindable.views.listControl.BeTreeTable;
import com.jetbrains.rd.ui.bindable.views.listControl.TreeGridUserObject;
import com.jetbrains.rd.ui.bindable.views.listControl.TreeGridUserObjectKt;
import com.jetbrains.rd.ui.bindable.views.listControl.TreeMouseMotionListener;
import com.jetbrains.rd.ui.bindable.views.listControl.TreeTableMouseMotionListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0016\b\u0002\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t\u001a\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0016\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u0006\u0010!\u001a\u00020\"\u001a\f\u0010#\u001a\u00020\u000b*\u00020\u0015H\u0000\u001a\u001a\u0010$\u001a\u00020\u000b*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&\u001a\u000e\u0010'\u001a\u0004\u0018\u00010(*\u00020\u0015H\u0000\u001a\f\u0010)\u001a\u00020\u000b*\u00020*H\u0002\u00a8\u0006+"}, d2={"autoScrollToEnd", "Ljavax/swing/event/TreeModelListener;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "autoScrollToSelection", "Ljavax/swing/event/TreeSelectionListener;", "navigateOnDoubleClick", "Lcom/intellij/ui/DoubleClickListener;", "navigateOverride", "Lkotlin/Function1;", "Ljava/awt/event/MouseEvent;", "", "sendExpandToModel", "Ljavax/swing/event/TreeWillExpandListener;", "updateFromUi", "Lcom/jetbrains/rd/ui/bedsl/extensions/UpdateFlag;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "sendFocusGainedToModel", "Ljava/awt/event/FocusAdapter;", "component", "Ljavax/swing/JComponent;", "viewModel", "Lcom/jetbrains/ide/model/uiautomation/BeTreeGrid;", "sendKeyboardEnterToModel", "Ljava/awt/event/KeyAdapter;", "sendMouseClickToModel", "Ljava/awt/event/MouseAdapter;", "sendSelectionToModel", "toggle", "", "o", "Ljavax/swing/tree/DefaultMutableTreeNode;", "toggleCheckboxOnSpaceBar", "Ljava/awt/event/KeyListener;", "addSpeedSearch", "enableStartEditingOnFocus", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getMouseMotionListener", "Ljava/awt/event/MouseMotionListener;", "startEditing", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "intellij.rd.ui"})
public final class BeTreeAndTableListenersKt {
    @NotNull
    public static final KeyListener toggleCheckboxOnSpaceBar() {
        return new KeyAdapter(){

            public final boolean isToggleEvent(@NotNull JComponent component, @NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return e.getKeyCode() == 32 && SpeedSearchSupply.getSupply((JComponent)component) == null;
            }

            /*
             * WARNING - void declaration
             */
            public void keyPressed(@NotNull KeyEvent e) {
                void component;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Pair<JComponent, Tree> pair = BeTreeAndTableExtensionsKt.getComponentAndTree(e.getSource());
                JComponent jComponent = (JComponent)pair.component1();
                Tree tree2 = (Tree)pair.component2();
                if (this.isToggleEvent((JComponent)component, e)) {
                    TreePath[] selectionPaths = tree2.getSelectionPaths();
                    if (selectionPaths != null) {
                        TreePath[] treePathArray = selectionPaths;
                        int n = treePathArray.length;
                        for (int i = 0; i < n; ++i) {
                            TreePath path;
                            TreePath treePath = path = treePathArray[i];
                            Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"path");
                            Object object = treePath.getLastPathComponent();
                            if (object == null) {
                                throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                            }
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
                            BeTreeAndTableListenersKt.access$toggle(node);
                            component.repaint();
                        }
                    }
                    e.consume();
                    component.repaint();
                }
            }
        };
    }

    private static final boolean toggle(DefaultMutableTreeNode o) {
        TreeGridUserObject userObject = TreeGridUserObjectKt.treeGridUserObject(o);
        BeCheckbox beCheckbox = (BeCheckbox)SequencesKt.firstOrNull(BeGetterExtensionsKt.descendantsOfType((BeControl)userObject.getLine(), BeCheckbox.class));
        if (beCheckbox == null) {
            return false;
        }
        BeCheckbox checkBox = beCheckbox;
        if ((ControlVisibility)InterfacesKt.valueOrDefault((IOptProperty)checkBox.getVisible(), (Object)ControlVisibility.Visible) != ControlVisibility.Visible) {
            return false;
        }
        Boolean bl = (Boolean)checkBox.getProperty().getValue();
        checkBox.getProperty().setValue((Object)(!(bl != null ? bl : false) ? 1 : 0));
        return true;
    }

    @NotNull
    public static final DoubleClickListener navigateOnDoubleClick(@Nullable Function1<? super MouseEvent, Unit> navigateOverride) {
        return new DoubleClickListener(navigateOverride){
            final /* synthetic */ Function1 $navigateOverride;

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$navigateOverride != null) {
                    this.$navigateOverride.invoke((Object)event);
                    return true;
                }
                DefaultMutableTreeNode node = this.findTreeNodeByEvent(event);
                if (node == null) {
                    return false;
                }
                if (node.getChildCount() > 0) {
                    return false;
                }
                TreeGridUserObject userObject = TreeGridUserObjectKt.treeGridUserObject(node);
                InterfacesKt.fire((ISignal)userObject.getLine().getSignal());
                return true;
            }

            private final DefaultMutableTreeNode findTreeNodeByEvent(MouseEvent e) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                Object source = e.getSource();
                Object object = source;
                if (object instanceof TreeTable) {
                    TreeTable treeTable = (TreeTable)source;
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.point");
                    Object object2 = BeTreeAndTableExtensionsKt.nodeAtPoint(treeTable, point);
                    if (!(object2 instanceof DefaultMutableTreeNode)) {
                        object2 = null;
                    }
                    defaultMutableTreeNode = (DefaultMutableTreeNode)object2;
                } else if (object instanceof Tree) {
                    Tree tree2 = (Tree)source;
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.point");
                    Object object3 = BeTreeAndTableExtensionsKt.nodeAtPoint(tree2, point);
                    if (!(object3 instanceof DefaultMutableTreeNode)) {
                        object3 = null;
                    }
                    defaultMutableTreeNode = (DefaultMutableTreeNode)object3;
                } else {
                    defaultMutableTreeNode = null;
                }
                return defaultMutableTreeNode;
            }
            {
                this.$navigateOverride = $captured_local_variable$0;
            }
        };
    }

    public static /* synthetic */ DoubleClickListener navigateOnDoubleClick$default(Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return BeTreeAndTableListenersKt.navigateOnDoubleClick((Function1<? super MouseEvent, Unit>)function1);
    }

    @NotNull
    public static final TreeWillExpandListener sendExpandToModel(@NotNull UpdateFlag updateFromUi, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)updateFromUi, (String)"updateFromUi");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        return new TreeWillExpandListener(updateFromUi, logger){
            final /* synthetic */ UpdateFlag $updateFromUi;
            final /* synthetic */ Logger $logger;

            public void treeWillCollapse(@NotNull TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TreePath treePath = event.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"event.path");
                this.setExpanded(treePath.getLastPathComponent(), false);
            }

            public void treeWillExpand(@NotNull TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TreePath treePath = event.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"event.path");
                this.setExpanded(treePath.getLastPathComponent(), true);
            }

            private final void setExpanded(Object inputNode, boolean isExpanded) {
                LocalChangeKt.ignoreOnReentrancy(this.$updateFromUi, (Function0<Unit>)((Function0)new Function0<Unit>(this, inputNode, isExpanded){
                    final /* synthetic */ sendExpandToModel.1 this$0;
                    final /* synthetic */ Object $inputNode;
                    final /* synthetic */ boolean $isExpanded;

                    public final void invoke() {
                        Object object = this.$inputNode;
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                        }
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
                        if (node.isRoot()) {
                            return;
                        }
                        Logger $this$trace$iv = this.this$0.$logger;
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            Logger logger = $this$trace$iv;
                            boolean bl = false;
                            String string = "setExpanded (" + BeTreeAndTableExtensionsKt.toLog(node) + ") : " + this.$isExpanded;
                            logger.trace(string);
                        }
                        TreeGridUserObject userObject = TreeGridUserObjectKt.treeGridUserObject(node);
                        userObject.getLine().isExpanded().set((Object)this.$isExpanded);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$inputNode = object;
                        this.$isExpanded = bl;
                        super(0);
                    }
                }));
            }
            {
                this.$updateFromUi = $captured_local_variable$0;
                this.$logger = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    public static final TreeSelectionListener sendSelectionToModel(@NotNull UpdateFlag updateFromUi, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)updateFromUi, (String)"updateFromUi");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        return new TreeSelectionListener(logger, updateFromUi){
            final /* synthetic */ Logger $logger;
            final /* synthetic */ UpdateFlag $updateFromUi;

            /*
             * WARNING - void declaration
             */
            public void valueChanged(@Nullable TreeSelectionEvent e) {
                if (e == null) {
                    return;
                }
                Logger $this$trace$iv22 = this.$logger;
                boolean $i$f$trace = false;
                if ($this$trace$iv22.isTraceEnabled()) {
                    Logger logger = $this$trace$iv22;
                    boolean bl = false;
                    String string = "changed " + BeTreeAndTableExtensionsKt.toLog(e);
                    logger.trace(string);
                }
                int $this$trace$iv22 = 0;
                TreePath[] treePathArray = e.getPaths();
                Intrinsics.checkNotNullExpressionValue((Object)treePathArray, (String)"e.paths");
                int n = treePathArray.length;
                while ($this$trace$iv22 < n) {
                    void i;
                    TreePath treePath = e.getPaths()[i];
                    Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"e.paths[i]");
                    this.updateModelSelection(treePath, e.isAddedPath((int)i));
                    ++i;
                }
            }

            private final void updateModelSelection(TreePath path, boolean isSelected) {
                LocalChangeKt.ignoreOnReentrancy(this.$updateFromUi, (Function0<Unit>)((Function0)new Function0<Unit>(this, path, isSelected){
                    final /* synthetic */ sendSelectionToModel.1 this$0;
                    final /* synthetic */ TreePath $path;
                    final /* synthetic */ boolean $isSelected;

                    public final void invoke() {
                        Object object = this.$path.getLastPathComponent();
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
                        }
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)object;
                        Logger $this$trace$iv = this.this$0.$logger;
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            Logger logger = $this$trace$iv;
                            boolean bl = false;
                            String string = "updateModelSelection set (" + BeTreeAndTableExtensionsKt.toLog(node) + "), isSelected: " + this.$isSelected;
                            logger.trace(string);
                        }
                        TreeGridUserObjectKt.treeGridUserObject(node).getLine().isSelected().set((Object)this.$isSelected);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$path = treePath;
                        this.$isSelected = bl;
                        super(0);
                    }
                }));
            }
            {
                this.$logger = $captured_local_variable$0;
                this.$updateFromUi = $captured_local_variable$1;
            }
        };
    }

    @NotNull
    public static final TreeSelectionListener autoScrollToSelection(@NotNull Tree tree2) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        return new TreeSelectionListener(tree2){
            final /* synthetic */ Tree $tree;

            public void valueChanged(@Nullable TreeSelectionEvent e) {
                TreeSelectionEvent treeSelectionEvent = e;
                this.$tree.scrollPathToVisible(treeSelectionEvent != null ? treeSelectionEvent.getNewLeadSelectionPath() : null);
            }
            {
                this.$tree = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public static final TreeModelListener autoScrollToEnd(@NotNull Tree tree2) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        return new TreeModelListener(tree2){
            final /* synthetic */ Tree $tree;

            private final void scrollToEnd() {
                int row = this.$tree.getRowCount() - 1;
                TreePath lastRowPath = this.$tree.getPathForRow(row);
                this.$tree.scrollPathToVisible(lastRowPath);
            }

            public void treeNodesInserted(@Nullable TreeModelEvent e) {
                this.scrollToEnd();
            }

            public void treeStructureChanged(@Nullable TreeModelEvent e) {
                this.scrollToEnd();
            }

            public void treeNodesChanged(@Nullable TreeModelEvent e) {
            }

            public void treeNodesRemoved(@Nullable TreeModelEvent e) {
                this.scrollToEnd();
            }
            {
                this.$tree = $captured_local_variable$0;
            }
        };
    }

    public static final void enableStartEditingOnFocus(@NotNull JComponent $this$enableStartEditingOnFocus, @NotNull BeTreeGrid viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)$this$enableStartEditingOnFocus, (String)"$this$enableStartEditingOnFocus");
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        $this$enableStartEditingOnFocus.putClientProperty("JTable.autoStartsEdit", true);
        IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
        Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.getGlobalInstance()");
        IdeFocusManager focusManager = ideFocusManager;
        viewModel.getFocus().advise(lifetime, (Function1)new Function1<Unit, Unit>($this$enableStartEditingOnFocus, focusManager){
            final /* synthetic */ JComponent $this_enableStartEditingOnFocus;
            final /* synthetic */ IdeFocusManager $focusManager;

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$focusManager.doWhenFocusSettlesDown(new Runnable(this){
                    final /* synthetic */ enableStartEditingOnFocus.1 this$0;

                    public final void run() {
                        SwingUtilities.invokeLater(new Runnable(this){
                            final /* synthetic */ enableStartEditingOnFocus.1 this$0;

                            public final void run() {
                                if (this.this$0.this$0.$this_enableStartEditingOnFocus instanceof TreeTable) {
                                    BeTreeAndTableListenersKt.access$startEditing((TreeTable)this.this$0.this$0.$this_enableStartEditingOnFocus);
                                } else if (this.this$0.this$0.$this_enableStartEditingOnFocus instanceof JTree) {
                                    ((JTree)this.this$0.this$0.$this_enableStartEditingOnFocus).startEditingAtPath(((JTree)this.this$0.this$0.$this_enableStartEditingOnFocus).getSelectionPath());
                                }
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$this_enableStartEditingOnFocus = jComponent;
                this.$focusManager = ideFocusManager;
                super(1);
            }
        });
    }

    private static final void startEditing(TreeTable $this$startEditing) {
        block5: {
            TableCellEditor tableCellEditor = $this$startEditing.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            int row = $this$startEditing.getSelectedRow();
            if (row < 0) {
                TreeTableTree treeTableTree = $this$startEditing.getTree();
                Intrinsics.checkNotNullExpressionValue((Object)treeTableTree, (String)"tree");
                int[] nArray = treeTableTree.getSelectionRows();
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"tree.selectionRows");
                Integer n = ArraysKt.min((int[])nArray);
                row = n != null ? n : -1;
            }
            $this$startEditing.scrollRectToVisible($this$startEditing.getCellRect(row, 0, true));
            if (!$this$startEditing.editCellAt(row, 0)) break block5;
            Component component = $this$startEditing.getEditorComponent();
            if (!(component instanceof JComponent)) {
                component = null;
            }
            JComponent editorComponent = (JComponent)component;
            IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
            Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.getGlobalInstance()");
            IdeFocusManager ideFocusManager2 = ideFocusManager;
            if (editorComponent != null && Intrinsics.areEqual((Object)ideFocusManager2.getFocusOwner(), (Object)editorComponent) ^ true) {
                JComponent jComponent = ideFocusManager2.getFocusTargetFor(editorComponent);
                if (jComponent != null) {
                    jComponent.requestFocusInWindow();
                }
            }
        }
    }

    @NotNull
    public static final MouseAdapter sendMouseClickToModel(@NotNull JComponent component, @NotNull BeTreeGrid viewModel) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        return new MouseAdapter(viewModel){
            final /* synthetic */ BeTreeGrid $viewModel;

            public void mouseReleased(@Nullable MouseEvent e) {
                if (e == null || UIUtil.isActionClick((MouseEvent)e, (int)502) && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !e.isConsumed()) {
                    InterfacesKt.fire((ISignal)this.$viewModel.getMouseClicked());
                }
            }
            {
                this.$viewModel = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public static final KeyAdapter sendKeyboardEnterToModel(@NotNull JComponent component, @NotNull BeTreeGrid viewModel) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        return new KeyAdapter(viewModel){
            final /* synthetic */ BeTreeGrid $viewModel;

            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10) {
                    InterfacesKt.fire((ISignal)this.$viewModel.getEnter());
                }
            }
            {
                this.$viewModel = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public static final FocusAdapter sendFocusGainedToModel(@NotNull JComponent component, @NotNull BeTreeGrid viewModel) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        return new FocusAdapter(component, viewModel){
            final /* synthetic */ JComponent $component;
            final /* synthetic */ BeTreeGrid $viewModel;

            public void focusGained(@Nullable FocusEvent e) {
                if (!this.$component.isFocusOwner()) {
                    InterfacesKt.fire((ISignal)this.$viewModel.getFocus());
                }
            }
            {
                this.$component = $captured_local_variable$0;
                this.$viewModel = $captured_local_variable$1;
            }
        };
    }

    @Nullable
    public static final MouseMotionListener getMouseMotionListener(@NotNull JComponent $this$getMouseMotionListener) {
        Intrinsics.checkNotNullParameter((Object)$this$getMouseMotionListener, (String)"$this$getMouseMotionListener");
        JComponent jComponent = $this$getMouseMotionListener;
        return jComponent instanceof BeTree ? (MouseMotionListener)new TreeMouseMotionListener((BeTree)((Object)$this$getMouseMotionListener)) : (jComponent instanceof BeTreeTable ? (MouseMotionListener)new TreeTableMouseMotionListener((BeTreeTable)((Object)$this$getMouseMotionListener)) : null);
    }

    public static final void addSpeedSearch(@NotNull JComponent $this$addSpeedSearch) {
        block1: {
            JComponent jComponent;
            block0: {
                Intrinsics.checkNotNullParameter((Object)$this$addSpeedSearch, (String)"$this$addSpeedSearch");
                jComponent = $this$addSpeedSearch;
                if (!(jComponent instanceof BeTree)) break block0;
                TreeSpeedSearch speedSearch = new TreeSpeedSearch((JTree)$this$addSpeedSearch);
                speedSearch.setComparator(new SpeedSearchComparator(false));
                break block1;
            }
            if (!(jComponent instanceof BeTreeTable)) break block1;
            TreeTableSpeedSearch speedSearch = new TreeTableSpeedSearch((TreeTable)$this$addSpeedSearch);
            speedSearch.setComparator(new SpeedSearchComparator(false));
        }
    }

    public static final /* synthetic */ boolean access$toggle(DefaultMutableTreeNode o) {
        return BeTreeAndTableListenersKt.toggle(o);
    }

    public static final /* synthetic */ void access$startEditing(TreeTable $this$access_u24startEditing) {
        BeTreeAndTableListenersKt.startEditing($this$access_u24startEditing);
    }
}

