/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views.listControl;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.StatusText;
import com.jetbrains.ide.model.uiautomation.AbstractProgress;
import com.jetbrains.ide.model.uiautomation.BeEmptyText;
import com.jetbrains.ide.model.uiautomation.BeTreeGrid;
import com.jetbrains.rd.ui.bindable.views.listControl.BeTree;
import com.jetbrains.rd.ui.bindable.views.listControl.BeTreeAndTableExtensionsKt;
import com.jetbrains.rd.ui.bindable.views.listControl.utils.SwingTreeUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rdclient.util.idea.ui.ModelRichTextExKt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0018\u001a\u00020\bH\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/listControl/BeTree;", "Lcom/intellij/ui/treeStructure/Tree;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "showAsList", "", "viewModel", "Lcom/jetbrains/ide/model/uiautomation/BeTreeGrid;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljavax/swing/tree/DefaultTreeModel;ZLcom/jetbrains/ide/model/uiautomation/BeTreeGrid;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getShowAsList", "()Z", "getData", "", "dataId", "", "getRendererComponentToolTip", "event", "Ljava/awt/event/MouseEvent;", "getToolTipText", "shouldShowBusyIconIfNeeded", "intellij.rd.ui"})
public final class BeTree
extends Tree
implements DataProvider {
    private final Logger logger;
    private final boolean showAsList;
    private final BeTreeGrid viewModel;

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return LangDataKeys.NO_NEW_ACTION.is(dataId) ? Boolean.valueOf(true) : BeTreeAndTableExtensionsKt.treeGetData(this, (String)this.viewModel.getControlId().getValue(), dataId, this.logger);
    }

    protected boolean shouldShowBusyIconIfNeeded() {
        return true;
    }

    private final String getRendererComponentToolTip(MouseEvent event) {
        TreePath path;
        Point point = event.getPoint();
        int row = this.getRowForLocation(point.x, point.y);
        TreeCellRenderer renderer = this.getCellRenderer();
        if (row == -1 || renderer == null) {
            return null;
        }
        TreePath treePath = path = this.getPathForRow(row);
        Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"path");
        Object lastPath = treePath.getLastPathComponent();
        Component rendererComponent = renderer.getTreeCellRendererComponent((JTree)((Object)this), lastPath, this.isRowSelected(row), super.isExpanded(row), this.getModel().isLeaf(lastPath), row, true);
        if (!(rendererComponent instanceof JComponent)) {
            return null;
        }
        Rectangle rectangle = this.getPathBounds(path);
        if (rectangle == null) {
            return null;
        }
        Rectangle pathBounds = rectangle;
        JComponent jComponent = SwingTreeUtilsKt.getDeepestRendererComponentByEvent((Container)((Object)this), rendererComponent, pathBounds, event);
        if (jComponent == null) {
            return null;
        }
        JComponent activeComponent = jComponent;
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull(SwingTreeUtilsKt.pathToRoot(activeComponent, (Component)((Object)this)), (Function1)getRendererComponentToolTip.1.INSTANCE));
    }

    @Nullable
    public String getToolTipText(@Nullable MouseEvent event) {
        if (event == null) {
            return this.getToolTipText();
        }
        String string = this.getRendererComponentToolTip(event);
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    public final boolean getShowAsList() {
        return this.showAsList;
    }

    public BeTree(@NotNull Lifetime lifetime, @NotNull DefaultTreeModel treeModel, boolean showAsList, @NotNull BeTreeGrid viewModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)treeModel, (String)"treeModel");
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        super((TreeModel)treeModel);
        this.showAsList = showAsList;
        this.viewModel = viewModel;
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BeTree.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.logger = logger;
        if (!this.showAsList) {
            this.setBorder((Border)new JBEmptyBorder(0, 4, 0, 0));
        } else {
            this.setBorder((Border)new JBEmptyBorder(0));
            KeyStroke pressedEnter = KeyStroke.getKeyStroke(10, 0);
            InputMap inputMap = SwingUtilities.getUIInputMap((JComponent)((Object)this), 2);
            if (inputMap != null) {
                inputMap.remove(pressedEnter);
            }
            InputMap inputMap2 = SwingUtilities.getUIInputMap((JComponent)((Object)this), 0);
            if (inputMap2 != null) {
                inputMap2.remove(pressedEnter);
            }
        }
        BeTreeAndTableExtensionsKt.bindProgress(lifetime, (IProperty<AbstractProgress>)this.viewModel.getProgress(), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                this.setPaintBusy(it);
            }
        }));
        StatusText statusText = this.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"this.emptyText");
        ModelRichTextExKt.bindToBeEmptyText(statusText, lifetime, (IProperty<BeEmptyText>)this.viewModel.getEmptyText());
    }
}

