/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.BeHtmlViewer;
import com.jetbrains.rd.ui.bedsl.extensions.BeGetterExtensionsKt;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Color;
import java.awt.Font;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/HtmlViewerViewControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeHtmlViewer;", "()V", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "intellij.rd.ui"})
public final class HtmlViewerViewControl
implements ViewBinder<BeHtmlViewer> {
    @Override
    @NotNull
    public JComponent bind(@NotNull BeHtmlViewer viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        UIUtil.JBWordWrapHtmlEditorKit kit = new UIUtil.JBWordWrapHtmlEditorKit();
        jEditorPane.setEditorKit((EditorKit)kit);
        jEditorPane.setBackground(UIUtil.getPanelBackground());
        Document doc = kit.createDefaultDocument();
        jEditorPane.setDocument(doc);
        String htmlString = (String)viewModel.getText().getValue();
        jEditorPane.setContentType("text/html");
        StyleSheet css = kit.getStyleSheet();
        css.addRule("body {color:#" + ColorUtil.toHex((Color)UIUtil.getLabelForeground()) + " }");
        StringBuilder stringBuilder = new StringBuilder().append("body {font:");
        Font font = UIUtil.getLabelFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"UIUtil.getLabelFont()");
        css.addRule(stringBuilder.append(font.getFamily()).append(" }").toString());
        css.addRule("body {word-break: break-all;}");
        Iterable $this$forEach$iv = BeGetterExtensionsKt.valueOrEmpty(viewModel.getCssRules());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            css.addRule(it);
        }
        if (htmlString != null) {
            viewModel.getText().advise(lifetime, (Function1)new Function1<String, Unit>(jEditorPane){
                final /* synthetic */ JEditorPane $jEditorPane;

                public final void invoke(@Nullable String v) {
                    this.$jEditorPane.setText(v);
                }
                {
                    this.$jEditorPane = jEditorPane;
                    super(1);
                }
            });
        } else {
            viewModel.getUrl().advise(lifetime, (Function1)new Function1<String, Unit>(jEditorPane){
                final /* synthetic */ JEditorPane $jEditorPane;

                public final void invoke(@NotNull String v) {
                    Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                    this.$jEditorPane.setPage(new URL(v));
                }
                {
                    this.$jEditorPane = jEditorPane;
                    super(1);
                }
            });
            jEditorPane.setText("<html> " + viewModel.getTextOnError() + "</html>");
        }
        return jEditorPane;
    }
}

