/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.jetbrains.ide.model.popups.ProtoViewModel;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.ui.bindable.ProtocolViewModelAdapter;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.ui.bindable.ViewModel;
import com.jetbrains.rd.ui.bindable.views.listControl.IActionOwner;
import com.jetbrains.rd.ui.bindable.views.listControl.IRendererOwner;
import com.jetbrains.rd.ui.bindable.views.listControl.ITreeGridRenderer;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J'\u0010\u000b\u001a\u0004\u0018\u00010\f\"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J'\u0010\u0013\u001a\n\u0012\u0004\u0012\u0002H\r\u0018\u00010\n\"\b\b\u0000\u0010\r*\u00020\u00012\u0006\u0010\u000f\u001a\u0002H\rH\u0002\u00a2\u0006\u0002\u0010\u0014J&\u0010\u0013\u001a\n\u0012\u0004\u0012\u0002H\r\u0018\u00010\n\"\b\b\u0000\u0010\r*\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\r0\u0016J\u001e\u0010\u0013\u001a\n\u0012\u0004\u0012\u0002H\r\u0018\u00010\n\"\u0004\b\u0000\u0010\r2\u0006\u0010\u0017\u001a\u00020\tH\u0002J4\u0010\u0018\u001a.\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a \u001b*\u0015\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a0\u001d\u00a2\u0006\u0002\b\u001c0\u0019\u00a2\u0006\u0002\b\u001cH\u0002J\u001c\u0010\u001e\u001a\u00020\t\"\u0004\b\u0000\u0010\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\r0\u0016H\u0002J%\u0010\u001f\u001a\n\u0012\u0004\u0012\u0002H\r\u0018\u00010 \"\b\b\u0000\u0010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u0002H\r\u00a2\u0006\u0002\u0010!J%\u0010\"\u001a\u00020#\"\b\b\u0000\u0010\r*\u00020$2\u0006\u0010\u000f\u001a\u0002H\r2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010%J'\u0010\"\u001a\u00020#\"\b\b\u0000\u0010\r*\u00020&2\u0006\u0010\u000f\u001a\u0002H\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/rd/ui/bindable/ViewRegistry;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "myCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "getAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "T", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/ide/model/uiautomation/BeControl;Lcom/jetbrains/rd/util/lifetime/Lifetime;)Lcom/intellij/openapi/actionSystem/AnAction;", "getByKey", "(Ljava/lang/Object;)Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "clazz", "Ljava/lang/Class;", "key", "getExtensions", "", "Lcom/intellij/openapi/extensions/KeyedFactoryEPBean;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "getKey", "getRenderer", "Lcom/jetbrains/rd/ui/bindable/views/listControl/ITreeGridRenderer;", "(Lcom/jetbrains/ide/model/uiautomation/BeControl;)Lcom/jetbrains/rd/ui/bindable/views/listControl/ITreeGridRenderer;", "getView", "Ljavax/swing/JComponent;", "Lcom/jetbrains/ide/model/popups/ProtoViewModel;", "(Lcom/jetbrains/ide/model/popups/ProtoViewModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;)Ljavax/swing/JComponent;", "Lcom/jetbrains/rd/ui/bindable/ViewModel;", "(Lcom/jetbrains/rd/ui/bindable/ViewModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;)Ljavax/swing/JComponent;", "Companion", "intellij.rd.ui"})
public final class ViewRegistry {
    private final Logger logger;
    private final ConcurrentHashMap<String, ViewBinder<Object>> myCache;
    private final Project project;
    private static final ProjectExtensionPointName<KeyedFactoryEPBean> EP_NAME;
    @NotNull
    public static final Companion Companion;

    private final <T> String getKey(Class<T> key) {
        String string = key.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.name");
        return string;
    }

    @Nullable
    public final <T> ViewBinder<T> getByKey(@NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        String key = this.getKey(clazz);
        ViewBinder<Object> cached = this.myCache.get(key);
        if (cached != null) {
            return cached;
        }
        cached = this.getByKey((T)key);
        if (cached != null) {
            ((Map)this.myCache).put(key, cached);
        }
        return cached;
    }

    private final <T> ViewBinder<T> getByKey(String key) {
        List<KeyedFactoryEPBean> epBeans = this.getExtensions();
        for (KeyedFactoryEPBean epBean : epBeans) {
            if (!Comparing.strEqual((String)key, (String)epBean.key)) continue;
            try {
                if (epBean.implementationClass == null) continue;
                String string = epBean.implementationClass;
                KeyedFactoryEPBean keyedFactoryEPBean = epBean;
                Intrinsics.checkNotNullExpressionValue((Object)keyedFactoryEPBean, (String)"epBean");
                return (ViewBinder)this.project.instantiateClass(string, keyedFactoryEPBean.getPluginDescriptor());
            }
            catch (Exception e) {
                throw (Throwable)new RuntimeException(e);
            }
        }
        return null;
    }

    private final List<KeyedFactoryEPBean> getExtensions() {
        List list2 = EP_NAME.getExtensions((AreaInstance)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"EP_NAME.getExtensions(project)");
        return list2;
    }

    @NotNull
    public final <T extends ViewModel> JComponent getView(@NotNull T viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter(viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (viewModel instanceof ProtocolViewModelAdapter) {
            return this.getView(((ProtocolViewModelAdapter)viewModel).getVm(), lifetime);
        }
        ViewBinder<T> viewBinder = this.getByKey(viewModel);
        if (viewBinder == null) {
            throw (Throwable)new IllegalArgumentException("There's no registered view for '" + this.getKey(viewModel.getClass()) + "' viewModel (fqn:'" + viewModel.getClass() + "').");
        }
        ViewBinder<T> view2 = viewBinder;
        return ViewBinder.DefaultImpls.bind$default(view2, viewModel, null, 2, null);
    }

    public static /* synthetic */ JComponent getView$default(ViewRegistry viewRegistry, ViewModel viewModel, Lifetime lifetime, int n, Object object) {
        if ((n & 2) != 0) {
            lifetime = Lifetime.Companion.getEternal();
        }
        return viewRegistry.getView(viewModel, lifetime);
    }

    @NotNull
    public final <T extends ProtoViewModel> JComponent getView(@NotNull T viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter(viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        ViewBinder<T> viewBinder = this.getByKey(viewModel);
        if (viewBinder == null) {
            throw (Throwable)new IllegalArgumentException("There's no registered view for '" + this.getKey(viewModel.getClass()) + "' viewModel (fqn:'" + viewModel.getClass() + "').");
        }
        ViewBinder<T> view2 = viewBinder;
        return view2.bind(viewModel, lifetime);
    }

    private final <T> ViewBinder<T> getByKey(T viewModel) {
        Class<?> superclass;
        Class<?> clazz = viewModel.getClass();
        ViewBinder<Class<?>> viewBinder = this.getByKey((T)clazz);
        if (viewBinder != null) {
            return viewBinder;
        }
        if (Intrinsics.areEqual(clazz.getSuperclass(), viewModel)) {
            return null;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (!(clazz2 instanceof Class)) {
            clazz2 = null;
        }
        if ((superclass = clazz2) != null) {
            return this.getByKey((T)superclass);
        }
        return null;
    }

    @Nullable
    public final <T extends BeControl> ITreeGridRenderer<T> getRenderer(@NotNull T viewModel) {
        IRendererOwner rendererOwner;
        Intrinsics.checkNotNullParameter(viewModel, (String)"viewModel");
        ViewBinder<T> viewBinder = this.getByKey(viewModel);
        if (!(viewBinder instanceof IRendererOwner)) {
            viewBinder = null;
        }
        if ((rendererOwner = (IRendererOwner)((Object)viewBinder)) == null) {
            this.logger.warn(viewModel.getClass().getSimpleName() + " is not an IRendererOwner");
        }
        IRendererOwner iRendererOwner = rendererOwner;
        if (iRendererOwner == null) {
            return null;
        }
        IRendererOwner view2 = iRendererOwner;
        return view2.getRenderer(viewModel);
    }

    @Nullable
    public final <T extends BeControl> AnAction getAction(@NotNull T viewModel, @NotNull Lifetime lifetime) {
        IActionOwner actionOwner;
        Intrinsics.checkNotNullParameter(viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        ViewBinder<T> viewBinder = this.getByKey(viewModel);
        if (!(viewBinder instanceof IActionOwner)) {
            viewBinder = null;
        }
        if ((actionOwner = (IActionOwner)((Object)viewBinder)) == null) {
            this.logger.warn(viewModel.getClass().getSimpleName() + " is not an IActionOwner");
        }
        IActionOwner iActionOwner = actionOwner;
        if (iActionOwner == null) {
            return null;
        }
        IActionOwner view2 = iActionOwner;
        return view2.getAction(lifetime, viewModel);
    }

    public ViewRegistry(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ViewRegistry.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.logger = logger;
        this.myCache = new ConcurrentHashMap();
    }

    static {
        Companion = new Companion(null);
        EP_NAME = new ProjectExtensionPointName("com.intellij.rdclient.view");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rd/ui/bindable/ViewRegistry$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ProjectExtensionPointName;", "Lcom/intellij/openapi/extensions/KeyedFactoryEPBean;", "getInstance", "Lcom/jetbrains/rd/ui/bindable/ViewRegistry;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rd.ui"})
    public static final class Companion {
        @NotNull
        public final ViewRegistry getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Project $this$service$iv = project;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(ViewRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
            return (ViewRegistry)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

