/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.EffectStyle;
import com.jetbrains.rd.ide.model.FontStyle;
import com.jetbrains.rd.ide.model.RgbColor;
import com.jetbrains.rd.ide.model.RichStringModel;
import com.jetbrains.rd.ide.model.RichTextBlockModel;
import com.jetbrains.rd.ide.model.RichTextModel;
import com.jetbrains.rd.ui.ProtocolUIKt$WhenMappings;
import com.jetbrains.rd.ui.util.ColorUtilsKt;
import com.jetbrains.rdclient.util.idea.ui.ModelRichTextExKt;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0016\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u00020\u0005*\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u0007\u001a\u00020\u000b*\u00020\b2\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u0007\u001a\u00020\u000b*\u00020\u00062\n\u0010\f\u001a\u00060\rj\u0002`\u000e2\u0006\u0010\t\u001a\u00020\n\u001a\n\u0010\u000f\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\u0010"}, d2={"isGrayed", "", "Lcom/jetbrains/rd/ide/model/RgbColor;", "splitByGrayColor", "Lkotlin/Pair;", "", "Lcom/jetbrains/rd/ide/model/RichTextModel;", "toHtml", "Lcom/jetbrains/rd/ide/model/RichTextBlockModel;", "bgColor", "Ljava/awt/Color;", "", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toSimpleText", "intellij.rd.ui"})
public final class ProtocolUIKt {
    public static final boolean isGrayed(@NotNull RgbColor $this$isGrayed) {
        Intrinsics.checkNotNullParameter((Object)$this$isGrayed, (String)"$this$isGrayed");
        return $this$isGrayed.getRed() == $this$isGrayed.getGreen() && $this$isGrayed.getGreen() == $this$isGrayed.getBlue() && $this$isGrayed.getRed() < 255 && $this$isGrayed.getRed() > 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toSimpleText(@NotNull RichTextModel $this$toSimpleText) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toSimpleText, (String)"$this$toSimpleText");
        Iterable iterable = $this$toSimpleText.getParts();
        String initial$iv = "";
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void modelString;
            RichStringModel richStringModel = (RichStringModel)element$iv;
            String s = accumulator$iv;
            boolean bl = false;
            accumulator$iv = s + modelString.getText();
        }
        return accumulator$iv;
    }

    @NotNull
    public static final Pair<String, String> splitByGrayColor(@NotNull RichTextModel $this$splitByGrayColor) {
        Intrinsics.checkNotNullParameter((Object)$this$splitByGrayColor, (String)"$this$splitByGrayColor");
        StringBuilder appender = new StringBuilder();
        StringBuilder grayBuilder = new StringBuilder();
        for (RichStringModel part : $this$splitByGrayColor.getParts()) {
            RgbColor foregroundColor;
            AbstractColor abstractColor = part.getForegroundColor();
            if (!(abstractColor instanceof RgbColor)) {
                abstractColor = null;
            }
            if ((foregroundColor = (RgbColor)abstractColor) != null && ProtocolUIKt.isGrayed(foregroundColor)) {
                grayBuilder.append(part.getText());
                continue;
            }
            CharSequence charSequence = grayBuilder;
            boolean bl = false;
            if (charSequence.length() > 0) {
                return new Pair((Object)ProtocolUIKt.toSimpleText($this$splitByGrayColor), (Object)"");
            }
            appender.append(part.getText());
        }
        String string = appender.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"appender.toString()");
        String string2 = grayBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"grayBuilder.toString()");
        return new Pair((Object)string, (Object)string2);
    }

    public static final void toHtml(@NotNull RichTextModel $this$toHtml, @NotNull StringBuilder stringBuilder, @NotNull Color bgColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"$this$toHtml");
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"stringBuilder");
        Intrinsics.checkNotNullParameter((Object)bgColor, (String)"bgColor");
        for (RichStringModel part : $this$toHtml.getParts()) {
            FontStyle fs;
            EffectStyle effectStyle;
            Color fgColor;
            stringBuilder.append("<span style=\"");
            stringBuilder.append("background-color:").append(ColorUtil.toHtmlColor((Color)bgColor)).append(";");
            AbstractColor abstractColor = part.getForegroundColor();
            Color color = fgColor = abstractColor != null ? ModelRichTextExKt.toColor(abstractColor) : null;
            if (fgColor != null) {
                Color contrastedFgColor = ColorUtilsKt.getContrastedForegroundIfNotThemed(bgColor, fgColor, true);
                stringBuilder.append("color:").append(ColorUtil.toHtmlColor((Color)contrastedFgColor)).append(';');
            }
            if ((effectStyle = part.getEffectStyle()) != EffectStyle.None) {
                switch (ProtocolUIKt$WhenMappings.$EnumSwitchMapping$0[effectStyle.ordinal()]) {
                    case 1: {
                        stringBuilder.append("text-decoration: underline;");
                        break;
                    }
                    case 2: {
                        stringBuilder.append("text-decoration: line-through;");
                        break;
                    }
                    default: {
                        throw (Throwable)new IllegalArgumentException(effectStyle + " is unsupported effect.");
                    }
                }
            }
            if ((fs = part.getFontStyle()) != FontStyle.Regular) {
                if (fs == FontStyle.Bold) {
                    stringBuilder.append("font-weight: bold;");
                }
                if (fs == FontStyle.Italic) {
                    stringBuilder.append("font-style: italic;");
                }
                if (fs == FontStyle.Strikeout) {
                    stringBuilder.append("text-decoration: line-through;");
                }
                if (fs == FontStyle.Underline) {
                    stringBuilder.append("text-decoration: underline;");
                }
            }
            stringBuilder.append("\">").append(StringUtil.escapeXmlEntities((String)part.getText())).append("</span>");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void toHtml(@NotNull RichTextBlockModel $this$toHtml, @NotNull StringBuilder stringBuilder, @NotNull Color bgColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"$this$toHtml");
        Intrinsics.checkNotNullParameter((Object)stringBuilder, (String)"stringBuilder");
        Intrinsics.checkNotNullParameter((Object)bgColor, (String)"bgColor");
        boolean bl = false;
        for (RichTextModel line : (Iterable)$this$toHtml.getLines()) {
            void i;
            void var6_6 = i;
            if (true <= var6_6 && $this$toHtml.getLines().size() > var6_6) {
                stringBuilder.append("<br/>");
            }
            ProtocolUIKt.toHtml(line, stringBuilder, bgColor);
            ++i;
        }
    }

    @NotNull
    public static final String toHtml(@NotNull RichTextBlockModel $this$toHtml, @NotNull Color bgColor) {
        Intrinsics.checkNotNullParameter((Object)$this$toHtml, (String)"$this$toHtml");
        Intrinsics.checkNotNullParameter((Object)bgColor, (String)"bgColor");
        StringBuilder builder = new StringBuilder();
        ProtocolUIKt.toHtml($this$toHtml, builder, bgColor);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }
}

