/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher.model;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.Pair;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.plugins.watcher.model.TasksPersistentComponent;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ApplicationTasksOptions", storages={@Storage(value="watcherDefaultTasks.xml")})
public class ApplicationTasksOptions
extends TasksPersistentComponent {
    private static final String GLOBAL_WATCHERS = "global-watchers";
    private final List<TaskOptions> myGlobalWatchers = new ArrayList<TaskOptions>();
    private final EventDispatcher<WatcherListListener> myDispatcher = EventDispatcher.create(WatcherListListener.class);

    public void addWatcherListListener(@NotNull WatcherListListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            ApplicationTasksOptions.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            ApplicationTasksOptions.$$$reportNull$$$0(1);
        }
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    public static ApplicationTasksOptions getInstance() {
        return (ApplicationTasksOptions)ApplicationManager.getApplication().getService(ApplicationTasksOptions.class);
    }

    @Nullable
    public Element getState() {
        Element element = ApplicationTasksOptions.createElementRespectEnabledState(this.getTasks());
        if (!this.myGlobalWatchers.isEmpty()) {
            Element globalWatchersElement = new Element(GLOBAL_WATCHERS);
            for (TaskOptions watcher : this.myGlobalWatchers) {
                globalWatchersElement.addContent(ApplicationTasksOptions.serializeWatcher(watcher));
            }
            element.addContent(globalWatchersElement);
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            ApplicationTasksOptions.$$$reportNull$$$0(2);
        }
        this.setTasks(ApplicationTasksOptions.loadFileWatcherList(state));
        Element globalWatchersElement = state.getChild(GLOBAL_WATCHERS);
        if (globalWatchersElement != null) {
            ArrayList<TaskOptions> globalWatchers = new ArrayList<TaskOptions>();
            for (Element item : globalWatchersElement.getChildren("TaskOptions")) {
                globalWatchers.add(ApplicationTasksOptions.deserializeWatcher(item));
            }
            this.setGlobalWatchers(globalWatchers);
        } else {
            this.setGlobalWatchers(Collections.emptyList());
        }
    }

    public void addOrUpdate(List<Pair<TaskOptions, Boolean>> tasks) {
        HashMap<String, Integer> map2index = new HashMap<String, Integer>();
        List<Pair<TaskOptions, Boolean>> myTasks = this.getTasks();
        for (int i = 0; i < myTasks.size(); ++i) {
            Pair<TaskOptions, Boolean> optionsPair = myTasks.get(i);
            map2index.put(((TaskOptions)optionsPair.getFirst()).getName(), i);
        }
        for (Pair<TaskOptions, Boolean> optionsPair : tasks) {
            TaskOptions options = (TaskOptions)optionsPair.getFirst();
            Integer index = (Integer)map2index.get(options.getName());
            if (index == null) {
                map2index.put(options.getName(), myTasks.size());
                myTasks.add(optionsPair);
                continue;
            }
            myTasks.set(index, optionsPair);
        }
    }

    @Nullable
    public TaskOptions getLastEditedWatcherWithName(@NotNull String name) {
        if (name == null) {
            ApplicationTasksOptions.$$$reportNull$$$0(3);
        }
        for (Pair<TaskOptions, Boolean> task : this.getTasks()) {
            if (!name.equals(((TaskOptions)task.first).getName())) continue;
            return (TaskOptions)task.first;
        }
        return null;
    }

    public List<TaskOptions> getGlobalWatchers() {
        return ImmutableList.copyOf(this.myGlobalWatchers);
    }

    public void setGlobalWatchers(@NotNull List<TaskOptions> globalWatchers) {
        if (globalWatchers == null) {
            ApplicationTasksOptions.$$$reportNull$$$0(4);
        }
        this.myGlobalWatchers.clear();
        this.myGlobalWatchers.addAll(globalWatchers);
        this.fireWatcherListUpdated();
    }

    private void fireWatcherListUpdated() {
        ((WatcherListListener)this.myDispatcher.getMulticaster()).watcherListUpdated();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalWatchers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/plugins/watcher/model/ApplicationTasksOptions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addWatcherListListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getLastEditedWatcherWithName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setGlobalWatchers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface WatcherListListener
    extends EventListener {
        public void watcherListUpdated();
    }
}

