/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.DialogManager;
import git4idea.GitCommit;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class GitRebaseOverMergeProblem {
    private static final Logger LOG = Logger.getInstance(GitRebaseOverMergeProblem.class);

    public static boolean hasProblem(@NotNull Project project, @NotNull VirtualFile root, @NotNull String baseRef, @NotNull String currentRef) {
        if (project == null) {
            GitRebaseOverMergeProblem.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitRebaseOverMergeProblem.$$$reportNull$$$0(1);
        }
        if (baseRef == null) {
            GitRebaseOverMergeProblem.$$$reportNull$$$0(2);
        }
        if (currentRef == null) {
            GitRebaseOverMergeProblem.$$$reportNull$$$0(3);
        }
        String range = baseRef + ".." + currentRef;
        try {
            List<GitCommit> commits2 = GitHistoryUtils.history(project, root, range, "--merges");
            return StreamEx.of(commits2).anyMatch(commit2 -> !commit2.getChanges().isEmpty());
        }
        catch (VcsException e) {
            LOG.warn("Couldn't get git log --merges " + range, (Throwable)e);
            return false;
        }
    }

    @NotNull
    public static Decision showDialog() {
        Ref decision = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> decision.set((Object)GitRebaseOverMergeProblem.doShowDialog()));
        Decision decision2 = (Decision)((Object)decision.get());
        if (decision2 == null) {
            GitRebaseOverMergeProblem.$$$reportNull$$$0(4);
        }
        return decision2;
    }

    @NotNull
    private static Decision doShowDialog() {
        int decision = DialogManager.showMessage(GitBundle.message("dialog.message.rebasing.merge.commits", new Object[0]), GitBundle.message("dialog.title.rebasing.merge.commits", new Object[0]), Decision.getButtonTitles(), Decision.getDefaultButtonIndex(), Decision.getFocusedButtonIndex(), Messages.getWarningIcon(), null);
        Decision decision2 = Decision.getOption(decision);
        if (decision2 == null) {
            GitRebaseOverMergeProblem.$$$reportNull$$$0(5);
        }
        return decision2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRef";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/update/GitRebaseOverMergeProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/update/GitRebaseOverMergeProblem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "showDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doShowDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasProblem";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Decision {
        MERGE_INSTEAD("rebasing.merge.commits.button.merge"),
        REBASE_ANYWAY("rebasing.merge.commits.button.rebase"),
        CANCEL_OPERATION("rebasing.merge.commits.button.cancel");

        private final String myButtonTextKey;

        private Decision(String buttonTextKey) {
            if (buttonTextKey == null) {
                Decision.$$$reportNull$$$0(0);
            }
            this.myButtonTextKey = buttonTextKey;
        }

        private static @NlsContexts.Button String @NotNull [] getButtonTitles() {
            String[] stringArray = (String[])ContainerUtil.map2Array((Object[])Decision.values(), String.class, decision -> GitBundle.message(decision.myButtonTextKey, new Object[0]));
            if (stringArray == null) {
                Decision.$$$reportNull$$$0(1);
            }
            return stringArray;
        }

        @NotNull
        public static Decision getOption(int index) {
            Decision decision2 = Objects.requireNonNull((Decision)((Object)ContainerUtil.find((Object[])Decision.values(), decision -> decision.ordinal() == index)));
            if (decision2 == null) {
                Decision.$$$reportNull$$$0(2);
            }
            return decision2;
        }

        private static int getDefaultButtonIndex() {
            return MERGE_INSTEAD.ordinal();
        }

        private static int getFocusedButtonIndex() {
            return REBASE_ANYWAY.ordinal();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buttonTextKey";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/update/GitRebaseOverMergeProblem$Decision";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/update/GitRebaseOverMergeProblem$Decision";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getButtonTitles";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOption";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

