/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.dvcs.branch.DvcsBranchManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.ThreeState;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackChangeListener;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import git4idea.branch.GitBranchType;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchManager;
import git4idea.ui.branch.dashboard.BranchInfo;
import git4idea.ui.branch.dashboard.BranchesDashboardController;
import git4idea.ui.branch.dashboard.BranchesDashboardControllerKt;
import git4idea.ui.branch.dashboard.BranchesDashboardUi;
import git4idea.ui.branch.dashboard.BranchesDashboardUiKt;
import git4idea.ui.branch.dashboard.BranchesDashboardUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0085\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0002*\u0001\u0011\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007JJ\u0010\u001e\u001a\u00020\u001f2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0#0!2\u0018\u0010$\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0#\u0012\u0004\u0012\u00020\u001f0!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001f0&H\u0002J\u0006\u0010'\u001a\u00020\u0016J\b\u0010(\u001a\u00020\u001fH\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,H\u0016J\u000e\u0010-\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020\u001f2\u0006\u0010.\u001a\u00020/J\u000e\u00104\u001a\u00020\u001f2\u0006\u00101\u001a\u000202J\b\u00105\u001a\u00020\u001fH\u0002J\b\u00106\u001a\u00020\u001fH\u0002J\u0006\u00107\u001a\u00020\u001fJ \u00108\u001a\u00020\u001f*\b\u0012\u0004\u0012\u00020\f092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\f09H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR+\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesDashboardController;", "Lcom/intellij/openapi/Disposable;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "ui", "Lgit4idea/ui/branch/dashboard/BranchesDashboardUi;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/ui/branch/dashboard/BranchesDashboardUi;)V", "changeListener", "Lcom/intellij/vcs/log/data/DataPackChangeListener;", "localBranches", "Ljava/util/HashSet;", "Lgit4idea/ui/branch/dashboard/BranchInfo;", "Lkotlin/collections/HashSet;", "getLocalBranches", "()Ljava/util/HashSet;", "logUiPropertiesListener", "git4idea/ui/branch/dashboard/BranchesDashboardController$logUiPropertiesListener$1", "Lgit4idea/ui/branch/dashboard/BranchesDashboardController$logUiPropertiesListener$1;", "remoteBranches", "getRemoteBranches", "<set-?>", "", "showOnlyMy", "getShowOnlyMy", "()Z", "setShowOnlyMy", "(Z)V", "showOnlyMy$delegate", "Lkotlin/properties/ReadWriteProperty;", "calculateMyBranchesInBackground", "", "run", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "", "onSuccess", "onFinished", "Lkotlin/Function0;", "checkForBranchesUpdate", "dispose", "getData", "", "dataId", "", "registerDataPackListener", "vcsLogData", "Lcom/intellij/vcs/log/data/VcsLogData;", "registerLogUiPropertiesListener", "vcsLogUiProperties", "Lcom/intellij/vcs/log/impl/VcsLogUiProperties;", "removeDataPackListener", "removeLogUiPropertiesListener", "updateBranchesIsFavoriteState", "updateBranchesIsMyState", "updateLogBranchFilter", "updateUnsureBranchesStateFrom", "", "updateFromBranches", "intellij.vcs.git"})
public final class BranchesDashboardController
implements Disposable,
DataProvider {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final DataPackChangeListener changeListener;
    private final logUiPropertiesListener.1 logUiPropertiesListener;
    @NotNull
    private final HashSet<BranchInfo> localBranches;
    @NotNull
    private final HashSet<BranchInfo> remoteBranches;
    @NotNull
    private final ReadWriteProperty showOnlyMy$delegate;
    private final Project project;
    private final BranchesDashboardUi ui;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(BranchesDashboardController.class, "showOnlyMy", "getShowOnlyMy()Z", 0))};
    }

    @NotNull
    public final HashSet<BranchInfo> getLocalBranches() {
        return this.localBranches;
    }

    @NotNull
    public final HashSet<BranchInfo> getRemoteBranches() {
        return this.remoteBranches;
    }

    public final boolean getShowOnlyMy() {
        return (Boolean)this.showOnlyMy$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public final void setShowOnlyMy(boolean bl) {
        this.showOnlyMy$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    public void dispose() {
        this.localBranches.clear();
        this.remoteBranches.clear();
    }

    public final void updateLogBranchFilter() {
        this.ui.updateLogBranchFilter$intellij_vcs_git();
    }

    public final boolean checkForBranchesUpdate() {
        boolean changed;
        boolean remoteChanged;
        Set<BranchInfo> newLocalBranches = BranchesDashboardUtil.INSTANCE.getLocalBranches(this.project);
        Set<BranchInfo> newRemoteBranches = BranchesDashboardUtil.INSTANCE.getRemoteBranches(this.project);
        boolean localChanged = this.localBranches.size() != newLocalBranches.size() || !this.localBranches.containsAll((Collection)newLocalBranches);
        boolean bl = remoteChanged = this.remoteBranches.size() != newRemoteBranches.size() || !this.remoteBranches.containsAll((Collection)newRemoteBranches);
        if (localChanged) {
            this.localBranches.clear();
            this.localBranches.addAll((Collection<BranchInfo>)newLocalBranches);
        }
        if (remoteChanged) {
            this.remoteBranches.clear();
            this.remoteBranches.addAll((Collection<BranchInfo>)newRemoteBranches);
        }
        boolean bl2 = changed = localChanged || remoteChanged;
        if (changed) {
            if (this.getShowOnlyMy()) {
                this.updateBranchesIsMyState();
            }
            this.ui.stopLoadingBranches();
        }
        return changed;
    }

    private final void updateBranchesIsFavoriteState() {
        Object $this$apply;
        boolean bl;
        boolean isFavorite;
        Object element$iv;
        boolean $i$f$any;
        Object $this$any$iv;
        boolean changed = false;
        Project $this$service$iv = this.project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GitBranchManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        Object object2 = object;
        boolean bl2 = false;
        boolean bl3 = false;
        GitBranchManager $this$with = (GitBranchManager)((Object)object2);
        boolean bl4 = false;
        for (BranchInfo localBranch : this.localBranches) {
            boolean bl5;
            block9: {
                $this$any$iv = localBranch.getRepositories();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv = iterator.next();
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl6 = false;
                        if (!$this$with.isFavorite(GitBranchType.LOCAL, it, localBranch.getBranchName())) continue;
                        bl5 = true;
                        break block9;
                    }
                    bl5 = false;
                }
            }
            isFavorite = bl5;
            changed |= localBranch.isFavorite() != isFavorite;
            $this$any$iv = localBranch;
            $i$f$any = false;
            bl = false;
            $this$apply = $this$any$iv;
            boolean bl7 = false;
            ((BranchInfo)$this$apply).setFavorite(isFavorite);
        }
        for (BranchInfo remoteBranch : this.remoteBranches) {
            boolean bl8;
            block10: {
                $this$any$iv = remoteBranch.getRepositories();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl8 = false;
                } else {
                    Iterator iterator = $this$any$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv = iterator.next();
                        GitRepository it = (GitRepository)element$iv;
                        boolean bl9 = false;
                        if (!$this$with.isFavorite(GitBranchType.REMOTE, it, remoteBranch.getBranchName())) continue;
                        bl8 = true;
                        break block10;
                    }
                    bl8 = false;
                }
            }
            isFavorite = bl8;
            changed |= remoteBranch.isFavorite() != isFavorite;
            BranchInfo branchInfo = remoteBranch;
            boolean bl10 = false;
            bl = false;
            $this$apply = branchInfo;
            boolean bl11 = false;
            ((BranchInfo)$this$apply).setFavorite(isFavorite);
        }
        if (changed) {
            this.ui.refreshTree();
        }
    }

    private final void updateBranchesIsMyState() {
        VcsProjectLog.runWhenLogIsReady((Project)this.project, (Consumer)((Consumer)new Consumer<VcsLogManager>(this){
            final /* synthetic */ BranchesDashboardController this$0;

            /*
             * WARNING - void declaration
             */
            public final void consume(VcsLogManager it) {
                void $this$filterTo$iv$iv;
                Set allBranches = SetsKt.plus((Set)this.this$0.getLocalBranches(), (Iterable)this.this$0.getRemoteBranches());
                Iterable $this$filter$iv = allBranches;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    BranchInfo it2 = (BranchInfo)element$iv$iv;
                    boolean bl = false;
                    if (!(it2.isMy() == ThreeState.UNSURE)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List branchesToCheck = (List)destination$iv$iv;
                BranchesDashboardController.access$getUi$p(this.this$0).startLoadingBranches();
                BranchesDashboardController.access$calculateMyBranchesInBackground(this.this$0, (Function1)new Function1<ProgressIndicator, Set<? extends BranchInfo>>(this, branchesToCheck){
                    final /* synthetic */ updateBranchesIsMyState.1 this$0;
                    final /* synthetic */ List $branchesToCheck;

                    @NotNull
                    public final Set<BranchInfo> invoke(@NotNull ProgressIndicator indicator) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        VcsProjectLog vcsProjectLog = VcsProjectLog.getInstance((Project)BranchesDashboardController.access$getProject$p(this.this$0.this$0));
                        Intrinsics.checkNotNullExpressionValue((Object)vcsProjectLog, (String)"VcsProjectLog.getInstance(project)");
                        return BranchesDashboardUtil.INSTANCE.checkIsMyBranchesSynchronously(vcsProjectLog, this.$branchesToCheck, indicator);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$branchesToCheck = list2;
                        super(1);
                    }
                }, (Function1)new Function1<Set<? extends BranchInfo>, Unit>(this){
                    final /* synthetic */ updateBranchesIsMyState.1 this$0;

                    public final void invoke(@NotNull Set<BranchInfo> branches2) {
                        Intrinsics.checkNotNullParameter(branches2, (String)"branches");
                        BranchesDashboardController.access$updateUnsureBranchesStateFrom(this.this$0.this$0, this.this$0.this$0.getLocalBranches(), branches2);
                        BranchesDashboardController.access$updateUnsureBranchesStateFrom(this.this$0.this$0, this.this$0.this$0.getRemoteBranches(), branches2);
                        BranchesDashboardController.access$getUi$p(this.this$0.this$0).refreshTree();
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ updateBranchesIsMyState.1 this$0;

                    public final void invoke() {
                        BranchesDashboardController.access$getUi$p(this.this$0.this$0).stopLoadingBranches();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = branchesDashboardController;
            }
        }));
    }

    private final void updateUnsureBranchesStateFrom(Collection<BranchInfo> $this$updateUnsureBranchesStateFrom, Collection<BranchInfo> updateFromBranches) {
        if (updateFromBranches.isEmpty()) {
            return;
        }
        for (BranchInfo branch : $this$updateUnsureBranchesStateFrom) {
            if (branch.isMy() != ThreeState.UNSURE) continue;
            branch.setMy(updateFromBranches.contains(branch) ? ThreeState.YES : ThreeState.NO);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateMyBranchesInBackground(Function1<? super ProgressIndicator, ? extends Set<BranchInfo>> run, Function1<? super Set<BranchInfo>, Unit> onSuccess2, Function0<Unit> onFinished) {
        void calculatedBranches;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        new Task.Backgroundable(this, (Ref.ObjectRef)calculatedBranches, run, onSuccess2, onFinished, this.project, GitBundle.message("action.Git.Show.My.Branches.description.calculating.branches.progress", new Object[0]), true){
            final /* synthetic */ BranchesDashboardController this$0;
            final /* synthetic */ Ref.ObjectRef $calculatedBranches;
            final /* synthetic */ Function1 $run;
            final /* synthetic */ Function1 $onSuccess;
            final /* synthetic */ Function0 $onFinished;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.$calculatedBranches.element = (Set)this.$run.invoke((Object)indicator);
            }

            public void onSuccess() {
                Set branches2 = (Set)this.$calculatedBranches.element;
                if (branches2 != null) {
                    this.$onSuccess.invoke((Object)branches2);
                }
            }

            public void onFinished() {
                this.$onFinished.invoke();
            }
            {
                this.this$0 = this$0;
                this.$calculatedBranches = $captured_local_variable$1;
                this.$run = $captured_local_variable$2;
                this.$onSuccess = $captured_local_variable$3;
                this.$onFinished = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        }.queue();
    }

    public final void registerDataPackListener(@NotNull VcsLogData vcsLogData) {
        Intrinsics.checkNotNullParameter((Object)vcsLogData, (String)"vcsLogData");
        vcsLogData.addDataPackChangeListener(this.changeListener);
    }

    public final void removeDataPackListener(@NotNull VcsLogData vcsLogData) {
        Intrinsics.checkNotNullParameter((Object)vcsLogData, (String)"vcsLogData");
        vcsLogData.removeDataPackChangeListener(this.changeListener);
    }

    public final void registerLogUiPropertiesListener(@NotNull VcsLogUiProperties vcsLogUiProperties) {
        Intrinsics.checkNotNullParameter((Object)vcsLogUiProperties, (String)"vcsLogUiProperties");
        vcsLogUiProperties.addChangeListener((VcsLogUiProperties.PropertiesChangeListener)this.logUiPropertiesListener);
    }

    public final void removeLogUiPropertiesListener(@NotNull VcsLogUiProperties vcsLogUiProperties) {
        Intrinsics.checkNotNullParameter((Object)vcsLogUiProperties, (String)"vcsLogUiProperties");
        vcsLogUiProperties.removeChangeListener((VcsLogUiProperties.PropertiesChangeListener)this.logUiPropertiesListener);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (BranchesDashboardControllerKt.getBRANCHES_UI_CONTROLLER().is(dataId)) {
            return this;
        }
        return null;
    }

    public BranchesDashboardController(@NotNull Project project, @NotNull BranchesDashboardUi ui) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        this.project = project;
        this.ui = ui;
        this.changeListener = new DataPackChangeListener(this){
            final /* synthetic */ BranchesDashboardController this$0;

            public final void onDataPackChange(@NotNull DataPack it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                BranchesDashboardController.access$getUi$p(this.this$0).updateBranchesTree(false);
            }
            {
                this.this$0 = branchesDashboardController;
            }
        };
        this.logUiPropertiesListener = new VcsLogUiProperties.PropertiesChangeListener(this){
            final /* synthetic */ BranchesDashboardController this$0;

            public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
                Intrinsics.checkNotNullParameter(property, (String)"property");
                if (Intrinsics.areEqual(property, (Object)BranchesDashboardUiKt.getSHOW_GIT_BRANCHES_LOG_PROPERTY())) {
                    BranchesDashboardController.access$getUi$p(this.this$0).toggleBranchesPanelVisibility();
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        boolean bl = false;
        this.localBranches = new HashSet();
        bl = false;
        this.remoteBranches = new HashSet();
        Delegates delegates = Delegates.INSTANCE;
        Boolean initialValue$iv = false;
        boolean $i$f$observable = false;
        this.showOnlyMy$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ BranchesDashboardController this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = branchesDashboardController;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                void new_;
                void old;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                boolean bl = (Boolean)newValue;
                boolean bl2 = (Boolean)oldValue;
                KProperty $noName_0 = property;
                boolean bl3 = false;
                if (old != new_) {
                    BranchesDashboardController.access$updateBranchesIsMyState(this.this$0);
                }
            }
        };
        Disposer.register((Disposable)this.ui, (Disposable)this);
        this.project.getMessageBus().connect((Disposable)this).subscribe(DvcsBranchManager.DVCS_BRANCH_SETTINGS_CHANGED, (Object)new DvcsBranchManager.DvcsBranchManagerListener(){

            public final void branchSettingsChanged() {
                this.updateBranchesIsFavoriteState();
            }
        });
    }

    public static final /* synthetic */ BranchesDashboardUi access$getUi$p(BranchesDashboardController $this) {
        return $this.ui;
    }

    public static final /* synthetic */ void access$calculateMyBranchesInBackground(BranchesDashboardController $this, Function1 run, Function1 onSuccess2, Function0 onFinished) {
        $this.calculateMyBranchesInBackground((Function1<? super ProgressIndicator, ? extends Set<BranchInfo>>)run, (Function1<? super Set<BranchInfo>, Unit>)onSuccess2, (Function0<Unit>)onFinished);
    }

    public static final /* synthetic */ Project access$getProject$p(BranchesDashboardController $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$updateUnsureBranchesStateFrom(BranchesDashboardController $this, Collection $this$access_u24updateUnsureBranchesStateFrom, Collection updateFromBranches) {
        $this.updateUnsureBranchesStateFrom($this$access_u24updateUnsureBranchesStateFrom, updateFromBranches);
    }

    public static final /* synthetic */ void access$updateBranchesIsMyState(BranchesDashboardController $this) {
        $this.updateBranchesIsMyState();
    }
}

