/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.RepositoryChangesBrowserNode;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserStringNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingSupport;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Processor;
import com.intellij.vcs.log.Hash;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitStashCache;
import git4idea.stash.GitStashTracker;
import git4idea.stash.GitStashTrackerListener;
import git4idea.stash.ui.GitStashActionsKt;
import git4idea.ui.StashInfo;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0016J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J \u0010\"\u001a\u00020\u001a*\u00020#2\u0006\u0010$\u001a\u00020%2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"Lgit4idea/stash/ui/GitStashTree;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "stashCache", "Lgit4idea/stash/GitStashCache;", "getStashCache", "()Lgit4idea/stash/GitStashCache;", "stashTracker", "Lgit4idea/stash/GitStashTracker;", "getStashTracker", "()Lgit4idea/stash/GitStashTracker;", "createRootNode", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getData", "", "dataId", "", "installGroupingSupport", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport;", "loadStash", "", "treePath", "Ljavax/swing/tree/TreePath;", "rebuildTree", "resetTreeState", "selectedStashes", "Ljava/util/stream/Stream;", "Lgit4idea/ui/StashInfo;", "insertErrorNode", "Lcom/intellij/openapi/vcs/changes/ui/TreeModelBuilder;", "error", "Lcom/intellij/openapi/vcs/VcsException;", "parent", "Companion", "StashInfoChangesBrowserNode", "intellij.vcs.git"})
public final class GitStashTree
extends ChangesTree {
    @NotNull
    private static final DataKey<Boolean> GIT_STASH_TREE_FLAG;
    @NonNls
    private static final String GROUPING_PROPERTY_NAME = "GitStash.ChangesTree.GroupingKeys";
    @NotNull
    public static final Companion Companion;

    private final GitStashTracker getStashTracker() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GitStashTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return (GitStashTracker)object;
    }

    private final GitStashCache getStashCache() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GitStashCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return (GitStashCache)object;
    }

    private final void loadStash(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        if (!(object instanceof ChangesBrowserNode)) {
            object = null;
        }
        ChangesBrowserNode changesBrowserNode = (ChangesBrowserNode)object;
        if (changesBrowserNode == null) {
            return;
        }
        ChangesBrowserNode node2 = changesBrowserNode;
        Object object2 = node2.getUserObject();
        if (!(object2 instanceof StashInfo)) {
            object2 = null;
        }
        StashInfo stashInfo = (StashInfo)object2;
        if (stashInfo == null) {
            return;
        }
        StashInfo stashInfo2 = stashInfo;
        this.getStashCache().loadStashData(stashInfo2);
    }

    /*
     * WARNING - void declaration
     */
    public void rebuildTree() {
        VirtualFile stashesMap;
        TreeModelBuilder modelBuilder = new TreeModelBuilder(this.getProject(), this.getGroupingSupport().getGrouping());
        VirtualFile virtualFile = stashesMap = this.getStashTracker().getStashes();
        boolean bl = false;
        Iterator<Map.Entry<VirtualFile, GitStashTracker.Stashes>> iterator = virtualFile.entrySet().iterator();
        while (iterator.hasNext()) {
            ChangesBrowserNode<?> changesBrowserNode;
            Map.Entry<VirtualFile, GitStashTracker.Stashes> entry;
            Map.Entry<VirtualFile, GitStashTracker.Stashes> entry2 = entry = iterator.next();
            boolean bl2 = false;
            virtualFile = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            GitStashTracker.Stashes stashesList = entry2.getValue();
            if (stashesMap.size() > 1) {
                void root;
                ChangesBrowserNode<?> changesBrowserNode2 = this.createRootNode((VirtualFile)root);
                boolean bl3 = false;
                boolean bl4 = false;
                ChangesBrowserNode<?> it = changesBrowserNode2;
                boolean bl5 = false;
                modelBuilder.insertSubtreeRoot(it);
                changesBrowserNode = changesBrowserNode2;
            } else {
                ChangesBrowserNode<?> changesBrowserNode3 = modelBuilder.myRoot;
                changesBrowserNode = changesBrowserNode3;
                Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode3, (String)"modelBuilder.myRoot");
            }
            ChangesBrowserNode<?> rootNode = changesBrowserNode;
            GitStashTracker.Stashes stashes = stashesList;
            if (stashes instanceof GitStashTracker.Stashes.Error) {
                this.insertErrorNode(modelBuilder, ((GitStashTracker.Stashes.Error)stashesList).getError(), rootNode);
                continue;
            }
            if (!(stashes instanceof GitStashTracker.Stashes.Loaded)) continue;
            for (StashInfo stash : ((GitStashTracker.Stashes.Loaded)stashesList).getStashes()) {
                StashInfoChangesBrowserNode stashNode = new StashInfoChangesBrowserNode(stash);
                modelBuilder.insertSubtreeRoot((ChangesBrowserNode)stashNode, rootNode);
                GitStashCache.StashData stashData = this.getStashCache().getCachedStashData(stash);
                if (stashData instanceof GitStashCache.StashData.ChangeList) {
                    modelBuilder.insertChanges(((GitStashCache.StashData.ChangeList)stashData).getChangeList().getChanges(), (ChangesBrowserNode)stashNode);
                    continue;
                }
                if (stashData instanceof GitStashCache.StashData.Error) {
                    this.insertErrorNode(modelBuilder, ((GitStashCache.StashData.Error)stashData).getError(), stashNode);
                    continue;
                }
                if (stashData != null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)modelBuilder.insertSubtreeRoot((ChangesBrowserNode)new ChangesBrowserStringNode(IdeBundle.message((String)"treenode.loading", (Object[])new Object[0])), (ChangesBrowserNode)stashNode), (String)"modelBuilder.insertSubtr\u2026de.loading\")), stashNode)");
            }
        }
        this.updateTreeModel(modelBuilder.build());
    }

    private final ChangesBrowserNode<?> createRootNode(VirtualFile root) {
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.getProject()).getRepositoryForRootQuick(root);
        if (gitRepository == null) {
            ChangesBrowserNode changesBrowserNode = ChangesBrowserNode.createFile((Project)this.getProject(), (VirtualFile)root);
            Intrinsics.checkNotNullExpressionValue((Object)changesBrowserNode, (String)"ChangesBrowserNode.createFile(project, root)");
            return changesBrowserNode;
        }
        Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"GitRepositoryManager.get\u2026createFile(project, root)");
        GitRepository repository = gitRepository;
        return (ChangesBrowserNode)new RepositoryChangesBrowserNode((Repository)repository, null, 2, null);
    }

    private final void insertErrorNode(TreeModelBuilder $this$insertErrorNode, VcsException error, ChangesBrowserNode<?> parent) {
        ChangesBrowserStringNode errorNode = new ChangesBrowserStringNode(error.getLocalizedMessage());
        errorNode.setAttributes(SimpleTextAttributes.ERROR_ATTRIBUTES);
        $this$insertErrorNode.insertSubtreeRoot((ChangesBrowserNode)errorNode, parent);
    }

    public void resetTreeState() {
        this.expandDefaults();
    }

    @NotNull
    protected ChangesGroupingSupport installGroupingSupport() {
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        ChangesGroupingSupport groupingSupport2 = new ChangesGroupingSupport(this, project, ChangesGroupingSupport.Companion, false){
            final /* synthetic */ GitStashTree this$0;

            public boolean isAvailable(@NotNull String groupingKey) {
                Intrinsics.checkNotNullParameter((Object)groupingKey, (String)"groupingKey");
                return Intrinsics.areEqual((Object)groupingKey, (Object)"repository") ^ true && super.isAvailable(groupingKey);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        GitStashTree.access$installGroupingSupport$s30922977(this, groupingSupport2, GROUPING_PROPERTY_NAME, Arrays.copyOf(ChangesTree.DEFAULT_GROUPING_KEYS, ChangesTree.DEFAULT_GROUPING_KEYS.length));
        return groupingSupport2;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (GitStashActionsKt.getSTASH_INFO().is(dataId)) {
            return StreamsKt.toList(this.selectedStashes());
        }
        if (GIT_STASH_TREE_FLAG.is(dataId)) {
            return true;
        }
        Object object = VcsTreeModelData.getData((Project)this.myProject, (JTree)((JTree)((Object)this)), (String)dataId);
        if (object == null) {
            object = super.getData(dataId);
        }
        return object;
    }

    private final Stream<StashInfo> selectedStashes() {
        Stream stream = VcsTreeModelData.selected((JTree)((JTree)((Object)this))).userObjectsStream(StashInfo.class);
        Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"VcsTreeModelData.selecte\u2026am(StashInfo::class.java)");
        return stream;
    }

    public GitStashTree(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(project, false, false);
        this.setKeepTreeState(true);
        this.setScrollToSelection(false);
        this.setEmptyText(GitBundle.message("stash.empty.text", new Object[0]));
        this.setDoubleClickHandler((Processor)new Processor<MouseEvent>(){

            public final boolean process(MouseEvent e) {
                AnAction diffAction = ActionManager.getInstance().getAction("Diff.ShowDiff");
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)((Object)this));
                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"DataManager.getInstance().getDataContext(this)");
                DataContext dataContext2 = dataContext;
                AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)diffAction, (InputEvent)e, (String)"GitStashUiPlace", (DataContext)dataContext2);
                Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"AnActionEvent.createFrom\u2026SH_UI_PLACE, dataContext)");
                AnActionEvent event = anActionEvent;
                boolean isEnabled = ActionUtil.lastUpdateAndCheckDumb((AnAction)diffAction, (AnActionEvent)event, (boolean)true);
                if (isEnabled) {
                    ActionUtil.performActionDumbAwareWithCallbacks((AnAction)diffAction, (AnActionEvent)event, (DataContext)dataContext2);
                }
                return isEnabled;
            }
        });
        project.getMessageBus().connect(parentDisposable).subscribe(GitStashCache.Companion.getGIT_STASH_LOADED(), (Object)new GitStashCache.StashLoadedListener(){

            @Override
            public void stashLoaded(@NotNull VirtualFile root, @NotNull Hash hash) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                this.rebuildTree();
            }
        });
        this.getStashTracker().addListener(new GitStashTrackerListener(){

            @Override
            public void stashesUpdated() {
                this.rebuildTree();
            }
        }, parentDisposable);
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(@NotNull TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TreePath treePath = event.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"event.path");
                this.loadStash(treePath);
            }

            @Override
            public void treeCollapsed(@NotNull TreeExpansionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public final void valueChanged(@NotNull TreeSelectionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                TreePath treePath = event.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"event.path");
                this.loadStash(treePath);
            }
        });
    }

    static {
        Companion = new Companion(null);
        DataKey dataKey = DataKey.create((String)"GitStashTreeFlag");
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"DataKey.create<Boolean>(\"GitStashTreeFlag\")");
        GIT_STASH_TREE_FLAG = dataKey;
    }

    public static final /* synthetic */ void access$installGroupingSupport$s30922977(ChangesTree p0, ChangesGroupingSupport p1, String p2, String ... p3) {
        ChangesTree.installGroupingSupport((ChangesTree)p0, (ChangesGroupingSupport)p1, (String)p2, (String[])p3);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lgit4idea/stash/ui/GitStashTree$StashInfoChangesBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lgit4idea/ui/StashInfo;", "stash", "(Lgit4idea/ui/StashInfo;)V", "getTextPresentation", "", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "shouldExpandByDefault", "intellij.vcs.git"})
    public static final class StashInfoChangesBrowserNode
    extends ChangesBrowserNode<StashInfo> {
        private final StashInfo stash;

        public void render(@NotNull ChangesBrowserNodeRenderer renderer2, boolean selected, boolean expanded, boolean hasFocus) {
            Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
            renderer2.append(this.stash.getStash(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            renderer2.append(": ");
            String string = this.stash.getBranch();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                renderer2.append(it, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
                renderer2.append(": ");
            }
            renderer2.append(this.stash.getMessage());
        }

        @NotNull
        public String getTextPresentation() {
            String string = this.stash.getStash();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stash.stash");
            return string;
        }

        public boolean shouldExpandByDefault() {
            return false;
        }

        public StashInfoChangesBrowserNode(@NotNull StashInfo stash) {
            Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
            super((Object)stash);
            this.stash = stash;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00020\u000b8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgit4idea/stash/ui/GitStashTree$Companion;", "", "()V", "GIT_STASH_TREE_FLAG", "Lcom/intellij/openapi/actionSystem/DataKey;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getGIT_STASH_TREE_FLAG", "()Lcom/intellij/openapi/actionSystem/DataKey;", "GROUPING_PROPERTY_NAME", "", "intellij.vcs.git"})
    public static final class Companion {
        @NotNull
        public final DataKey<Boolean> getGIT_STASH_TREE_FLAG() {
            return GIT_STASH_TREE_FLAG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

