/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.ignore.VcsRepositoryIgnoredFilesHolderBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtilKt;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import git4idea.GitLocalBranch;
import git4idea.commands.Git;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUntrackedFilesHolder
implements Disposable,
AsyncVfsEventsListener {
    private static final Logger LOG = Logger.getInstance(GitUntrackedFilesHolder.class);
    private final Project myProject;
    private final VirtualFile myRoot;
    private final FilePath myRootPath;
    private final GitRepository myRepository;
    private final ChangeListManager myChangeListManager;
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final Git myGit;
    private final Set<FilePath> myDefinitelyUntrackedFiles;
    private final Set<FilePath> myPossiblyUntrackedFiles;
    private boolean myReady;
    private final Object LOCK;
    private final Object RESCAN_LOCK;

    GitUntrackedFilesHolder(@NotNull GitRepository repository) {
        if (repository == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(0);
        }
        this.myDefinitelyUntrackedFiles = new HashSet<FilePath>();
        this.myPossiblyUntrackedFiles = new HashSet<FilePath>();
        this.LOCK = new Object();
        this.RESCAN_LOCK = new Object();
        this.myProject = repository.getProject();
        this.myRepository = repository;
        this.myRoot = repository.getRoot();
        this.myRootPath = VcsUtil.getFilePath((VirtualFile)this.myRoot);
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.myGit = Git.getInstance();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
    }

    void setupVfsListener(@NotNull Project project) {
        if (project == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!project.isDisposed()) {
                AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, (Disposable)this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDefinitelyUntrackedFiles.clear();
            this.myPossiblyUntrackedFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull FilePath file) {
        if (file == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(2);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myDefinitelyUntrackedFiles.add(file);
            this.myPossiblyUntrackedFiles.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull Collection<? extends FilePath> files) {
        if (files == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(3);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myDefinitelyUntrackedFiles.addAll(files);
            this.myPossiblyUntrackedFiles.addAll(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NotNull Collection<? extends FilePath> files) {
        if (files == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(4);
        }
        Object object = this.LOCK;
        synchronized (object) {
            files.forEach(this.myDefinitelyUntrackedFiles::remove);
            this.myPossiblyUntrackedFiles.addAll(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markPossiblyUntracked(@NotNull Collection<? extends FilePath> files) {
        if (files == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(5);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myPossiblyUntrackedFiles.addAll(files);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @NotNull
    public Collection<VirtualFile> retrieveUntrackedFiles() throws VcsException {
        List list2 = ContainerUtil.mapNotNull(this.retrieveUntrackedFilePaths(), FilePath::getVirtualFile);
        if (list2 == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(6);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myReady = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<FilePath> getUntrackedFilePaths() {
        Object object = this.LOCK;
        // MONITORENTER : object
        ArrayList<FilePath> arrayList = new ArrayList<FilePath>(this.myDefinitelyUntrackedFiles);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        GitUntrackedFilesHolder.$$$reportNull$$$0(7);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsFile(@NotNull FilePath filePath) {
        if (filePath == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(8);
        }
        Object object = this.LOCK;
        synchronized (object) {
            return this.myDefinitelyUntrackedFiles.contains(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<FilePath> retrieveUntrackedFilePaths() throws VcsException {
        Object object = this.RESCAN_LOCK;
        synchronized (object) {
            this.rescan();
        }
        Collection<FilePath> collection = this.getUntrackedFilePaths();
        if (collection == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(9);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescan() throws VcsException {
        HashSet<FilePath> suspiciousFiles;
        Object object = this.LOCK;
        synchronized (object) {
            suspiciousFiles = this.myReady ? new HashSet<FilePath>(this.myPossiblyUntrackedFiles) : null;
            this.myPossiblyUntrackedFiles.clear();
        }
        Set<FilePath> untrackedFiles = this.myGit.untrackedFilePaths(this.myProject, this.myRoot, suspiciousFiles);
        this.removePathsUnderOtherRoots(untrackedFiles);
        Object object2 = this.LOCK;
        synchronized (object2) {
            if (suspiciousFiles != null) {
                this.myDefinitelyUntrackedFiles.removeIf(definitelyUntrackedFile -> VcsFileUtilKt.isUnder((FilePath)this.myRootPath, (Set)suspiciousFiles, (FilePath)definitelyUntrackedFile));
                this.myDefinitelyUntrackedFiles.addAll(untrackedFiles);
            } else {
                this.myDefinitelyUntrackedFiles.clear();
                this.myDefinitelyUntrackedFiles.addAll(untrackedFiles);
                this.myReady = true;
            }
        }
    }

    private void removePathsUnderOtherRoots(@NotNull Collection<FilePath> untrackedFiles) {
        if (untrackedFiles == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(10);
        }
        int removedFiles = 0;
        int maxFilesToReport = 10;
        Iterator<FilePath> it = untrackedFiles.iterator();
        while (it.hasNext()) {
            FilePath filePath = it.next();
            VirtualFile root = this.myVcsManager.getVcsRootFor(filePath);
            if (this.myRoot.equals(root)) continue;
            it.remove();
            if (++removedFiles >= maxFilesToReport) continue;
            LOG.warn(String.format("Ignoring untracked file under another root: %s; root: %s; mapped root: %s", filePath.getPresentableUrl(), this.myRoot.getPresentableUrl(), root != null ? root.getPresentableUrl() : "null"));
        }
        if (removedFiles >= maxFilesToReport) {
            LOG.warn(String.format("Ignoring untracked file under another root: %s files total", removedFiles));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filesChanged(@NotNull List<? extends VFileEvent> events) {
        Object object;
        if (events == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(11);
        }
        boolean allChanged = false;
        HashSet<FilePath> filesToRefresh = new HashSet<FilePath>();
        for (VFileEvent vFileEvent : events) {
            if (allChanged) break;
            String path = vFileEvent.getPath();
            if (GitUntrackedFilesHolder.totalRefreshNeeded(this.myRepository, path)) {
                allChanged = true;
                continue;
            }
            Set affectedPaths = VcsRepositoryIgnoredFilesHolderBase.getAffectedFilePaths((VFileEvent)vFileEvent);
            for (FilePath affectedFilePath : affectedPaths) {
                if (!this.notIgnored(affectedFilePath)) continue;
                filesToRefresh.add(affectedFilePath);
            }
        }
        if (allChanged) {
            this.rescanIgnoredFiles(() -> {
                LOG.debug(String.format("GitUntrackedFilesHolder: total refresh is needed, marking %s recursively dirty", this.myRoot));
                this.myDirtyScopeManager.dirDirtyRecursively(this.myRoot);
            });
            object = this.LOCK;
            synchronized (object) {
                this.myReady = false;
            }
        }
        object = this.LOCK;
        synchronized (object) {
            this.myPossiblyUntrackedFiles.addAll(filesToRefresh);
        }
    }

    private static boolean totalRefreshNeeded(@NotNull GitRepository repository, @NotNull String path) {
        if (repository == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(12);
        }
        if (path == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(13);
        }
        return GitUntrackedFilesHolder.indexChanged(repository, path) || GitUntrackedFilesHolder.externallyCommitted(repository, path) || GitUntrackedFilesHolder.headMoved(repository, path) || GitUntrackedFilesHolder.headChanged(repository, path) || GitUntrackedFilesHolder.currentBranchChanged(repository, path) || GitUntrackedFilesHolder.gitignoreChanged(repository, path);
    }

    private static boolean headChanged(@NotNull GitRepository repository, @NotNull String path) {
        if (repository == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(14);
        }
        if (path == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(15);
        }
        return repository.getRepositoryFiles().isHeadFile(path);
    }

    private static boolean currentBranchChanged(@NotNull GitRepository repository, @NotNull String path) {
        GitLocalBranch currentBranch;
        if (repository == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(16);
        }
        if (path == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(17);
        }
        return (currentBranch = repository.getCurrentBranch()) != null && repository.getRepositoryFiles().isBranchFile(path, currentBranch.getFullName());
    }

    private static boolean headMoved(@NotNull GitRepository repository, @NotNull String path) {
        if (repository == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(18);
        }
        if (path == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(19);
        }
        return repository.getRepositoryFiles().isOrigHeadFile(path);
    }

    public static boolean indexChanged(@NotNull GitRepository repository, @NotNull String path) {
        if (repository == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(20);
        }
        if (path == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(21);
        }
        return repository.getRepositoryFiles().isIndexFile(path);
    }

    private static boolean externallyCommitted(@NotNull GitRepository repository, @NotNull String path) {
        if (repository == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(22);
        }
        if (path == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(23);
        }
        return repository.getRepositoryFiles().isCommitMessageFile(path);
    }

    private static boolean gitignoreChanged(@NotNull GitRepository repository, @NotNull String path) {
        if (repository == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(24);
        }
        if (path == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(25);
        }
        return path.endsWith(".gitignore") || repository.getRepositoryFiles().isExclude(path);
    }

    private void rescanIgnoredFiles(@NotNull Runnable doAfterRescan) {
        if (doAfterRescan == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(26);
        }
        this.myRepository.getIgnoredFilesHolder().startRescan(doAfterRescan);
    }

    private boolean notIgnored(@Nullable FilePath file) {
        return file != null && this.belongsToThisRepository(file) && !this.myChangeListManager.isIgnoredFile(file);
    }

    private boolean belongsToThisRepository(FilePath file) {
        return this.myRoot.equals(this.myVcsManager.getVcsRootFor(file));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitUntrackedFilesHolder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untrackedFiles";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doAfterRescan";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitUntrackedFilesHolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveUntrackedFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUntrackedFilePaths";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveUntrackedFilePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupVfsListener";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "markPossiblyUntracked";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "containsFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removePathsUnderOtherRoots";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filesChanged";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "totalRefreshNeeded";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "headChanged";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "currentBranchChanged";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "headMoved";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "indexChanged";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "externallyCommitted";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "gitignoreChanged";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "rescanIgnoredFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

